/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.silverpeas.components.gallery.Watermark;
import org.silverpeas.components.gallery.constant.MediaMimeType;
import org.silverpeas.components.gallery.constant.MediaResolution;
import org.silverpeas.components.gallery.constant.MediaType;
import org.silverpeas.components.gallery.media.DrewMediaMetadataExtractor;
import org.silverpeas.components.gallery.media.MediaMetadataException;
import org.silverpeas.components.gallery.model.GalleryRuntimeException;
import org.silverpeas.components.gallery.model.InternalMedia;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.MediaPK;
import org.silverpeas.components.gallery.model.MetaData;
import org.silverpeas.components.gallery.model.Photo;
import org.silverpeas.components.gallery.model.Sound;
import org.silverpeas.components.gallery.model.Video;
import org.silverpeas.core.io.media.Definition;
import org.silverpeas.core.io.media.MetadataExtractor;
import org.silverpeas.core.io.media.image.ImageInfoType;
import org.silverpeas.core.io.media.image.ImageTool;
import org.silverpeas.core.io.media.image.ImageToolDirective;
import org.silverpeas.core.io.media.image.option.AbstractImageToolOption;
import org.silverpeas.core.io.media.image.option.AnchoringPosition;
import org.silverpeas.core.io.media.image.option.DimensionOption;
import org.silverpeas.core.io.media.image.option.OrientationOption;
import org.silverpeas.core.io.media.image.option.WatermarkImageOption;
import org.silverpeas.core.io.media.image.option.WatermarkTextOption;
import org.silverpeas.core.io.media.video.VideoThumbnailExtractor;
import org.silverpeas.core.notification.message.MessageManager;
import org.silverpeas.core.process.io.file.FileHandler;
import org.silverpeas.core.process.io.file.HandledFile;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.core.util.logging.SilverLogger;

public class MediaUtil {
    private MediaUtil() {
    }

    private static void pasteFile(HandledFile fromFile, HandledFile toFile, boolean cut) {
        if (fromFile.exists(new String[0])) {
            try {
                if (cut) {
                    fromFile.moveFile(toFile);
                } else {
                    fromFile.copyFile(toFile);
                }
            }
            catch (Exception e) {
                SilverLogger.getLogger(MediaUtil.class).error("Unable to copy file : fromImage = " + fromFile.getFile().getPath() + ", toImage = " + toFile.getFile().getPath(), (Throwable)e);
            }
        }
    }

    private static HandledFile getHandledFile(FileHandler fileHandler, InternalMedia media) {
        if (StringUtil.isNotDefined((String)media.getFileName())) {
            throw new IllegalArgumentException("media.getFilename() must return a defined name");
        }
        return fileHandler.getHandledFile(Media.BASE_PATH, new String[]{media.getComponentInstanceId(), media.getWorkspaceSubFolderName(), media.getFileName()});
    }

    private static void setMetaData(FileHandler fileHandler, Photo photo, String lang) throws MediaMetadataException, IOException {
        HandledFile handledFile;
        if (MediaMimeType.JPG == photo.getFileMimeType() && (handledFile = fileHandler.getHandledFile(Media.BASE_PATH, new String[]{photo.getInstanceId(), photo.getWorkspaceSubFolderName(), photo.getFileName()})).exists(new String[0])) {
            try {
                DrewMediaMetadataExtractor extractor = new DrewMediaMetadataExtractor(photo.getInstanceId());
                extractor.extractImageExifMetaData(handledFile.getFile(), lang).forEach(photo::addMetaData);
                extractor.extractImageIptcMetaData(handledFile.getFile(), lang).forEach(photo::addMetaData);
            }
            catch (UnsupportedEncodingException e) {
                SilverLogger.getLogger(MediaUtil.class).silent((Throwable)e).error("Bad metadata encoding in image " + photo.getTitle() + ": " + e.getMessage(), new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void processSound(FileHandler fileHandler, Sound sound, FileItem fileItem) throws Exception {
        String name;
        if (fileItem != null && (name = fileItem.getName()) != null) {
            try {
                sound.setFileName(StringUtil.normalize((String)FileUtil.getFilename((String)name)));
                HandledFile handledSoundFile = MediaUtil.getHandledFile(fileHandler, sound);
                handledSoundFile.copyInputStreamToFile(fileItem.getInputStream());
                new SoundProcess(handledSoundFile, sound).process();
            }
            finally {
                fileItem.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void processSound(FileHandler fileHandler, Sound sound, File uploadedFile) throws Exception {
        if (uploadedFile != null) {
            try {
                sound.setFileName(StringUtil.normalize((String)uploadedFile.getName()));
                HandledFile handledSoundFile = MediaUtil.getHandledFile(fileHandler, sound);
                fileHandler.copyFile(uploadedFile, handledSoundFile);
                new SoundProcess(handledSoundFile, sound).process();
            }
            finally {
                FileUtils.deleteQuietly((File)uploadedFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void processVideo(FileHandler fileHandler, Video video, FileItem fileItem) throws Exception {
        String name;
        if (fileItem != null && (name = fileItem.getName()) != null) {
            try {
                video.setFileName(StringUtil.normalize((String)FileUtil.getFilename((String)name)));
                HandledFile handledVideoFile = MediaUtil.getHandledFile(fileHandler, video);
                handledVideoFile.copyInputStreamToFile(fileItem.getInputStream());
                new VideoProcess(handledVideoFile, video).process();
            }
            finally {
                fileItem.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void processVideo(FileHandler fileHandler, Video video, File uploadedFile) throws Exception {
        if (uploadedFile != null) {
            try {
                video.setFileName(StringUtil.normalize((String)uploadedFile.getName()));
                HandledFile handledVideoFile = MediaUtil.getHandledFile(fileHandler, video);
                fileHandler.copyFile(uploadedFile, handledVideoFile);
                new VideoProcess(handledVideoFile, video).process();
            }
            finally {
                FileUtils.deleteQuietly((File)uploadedFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void processPhoto(FileHandler fileHandler, Photo photo, FileItem image, Watermark watermark) throws Exception {
        String name;
        if (image != null && (name = image.getName()) != null) {
            try {
                photo.setFileName(StringUtil.normalize((String)image.getName()));
                HandledFile handledImageFile = MediaUtil.getHandledFile(fileHandler, photo);
                handledImageFile.copyInputStreamToFile(image.getInputStream());
                new PhotoProcess(handledImageFile, photo, watermark).process();
            }
            finally {
                image.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void processPhoto(FileHandler fileHandler, Photo photo, File image, Watermark watermark) throws Exception {
        if (image != null) {
            try {
                photo.setFileName(StringUtil.normalize((String)image.getName()));
                HandledFile handledImageFile = MediaUtil.getHandledFile(fileHandler, photo);
                fileHandler.copyFile(image, handledImageFile);
                new PhotoProcess(handledImageFile, photo, watermark).process();
            }
            finally {
                FileUtils.deleteQuietly((File)image);
            }
        }
    }

    public static synchronized void pasteInternalMedia(FileHandler fileHandler, MediaPK fromPK, InternalMedia media, boolean cut) {
        InternalMedia fromMedia = (InternalMedia)media.getType().newInstance();
        fromMedia.setMediaPK(fromPK);
        fromMedia.setFileName(media.getFileName());
        HandledFile fromDir = MediaUtil.getHandledFile(fileHandler, fromMedia).getParentHandledFile(new String[0]);
        HandledFile toDir = MediaUtil.getHandledFile(fileHandler, media).getParentHandledFile(new String[0]);
        if (fromDir.exists(new String[0])) {
            Collection srcFiles = fromDir.listFiles(FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.prefixFileFilter((String)fromPK.getId()), FileFilterUtils.asFileFilter(file -> file.getName().matches("^img[0-9]+.jpg$"))}), FileFilterUtils.falseFileFilter());
            int substringIndex = fromPK.getId().length();
            for (HandledFile srcFile : srcFiles) {
                String srcFileName = srcFile.getFile().getName();
                String dstFileName = srcFileName.startsWith(fromPK.getId()) ? media.getId() + srcFileName.substring(substringIndex) : srcFileName;
                MediaUtil.pasteFile(srcFile, toDir.getHandledFile(new String[]{dstFileName}), cut);
            }
            MediaUtil.pasteFile(fromDir.getHandledFile(new String[]{media.getFileName()}), toDir.getHandledFile(new String[]{media.getFileName()}), cut);
            if (cut && !fromPK.getInstanceId().equals(media.getInstanceId())) {
                try {
                    fromDir.delete();
                }
                catch (Exception e) {
                    SilverLogger.getLogger(MediaUtil.class).error("Unable to delete source folder : folder path = " + fromDir.getFile().getPath(), (Throwable)e);
                }
            }
        }
    }

    public static void setMetaData(FileHandler fileHandler, Photo photo) throws MediaMetadataException {
        try {
            MediaUtil.setMetaData(fileHandler, photo, MessageManager.getLanguage());
        }
        catch (IOException e) {
            throw new MediaMetadataException(e);
        }
    }

    private static class PhotoProcess
    extends MediaProcess<Photo> {
        private Set<AbstractImageToolOption> watermarkNormalOptions = Collections.emptySet();
        private Set<AbstractImageToolOption> watermarkThumbnailOptions = Collections.emptySet();
        private HandledFile[] thumbnailSrc = new HandledFile[2];
        private List<MetaData> cachedIptcMetadata = null;

        private PhotoProcess(HandledFile handledFile, Photo photo, Watermark watermark) {
            super(handledFile, photo);
            this.computeWatermarks(watermark);
        }

        private static ImageTool getImageTool() {
            return ImageTool.get();
        }

        @Override
        protected void generateFiles() {
            Photo photo = (Photo)this.getMedia();
            if (photo.isPreviewable()) {
                this.registerResolutionData();
                this.createNormals(photo);
                try {
                    this.createThumbnails();
                }
                catch (Exception e) {
                    SilverLogger.getLogger(MediaUtil.class).error("image = " + photo.getTitle() + " (#" + photo.getId() + ")", (Throwable)e);
                }
            }
        }

        private void registerResolutionData() {
            if (((Photo)this.getMedia()).getDefinition().getWidth() != 0 && ((Photo)this.getMedia()).getDefinition().getHeight() != 0) {
                return;
            }
            String[] widthAndHeight = null;
            try {
                widthAndHeight = PhotoProcess.getImageTool().getImageInfo(super.getHandledFile().getFile(), new ImageInfoType[]{ImageInfoType.WIDTH_IN_PIXEL, ImageInfoType.HEIGHT_IN_PIXEL});
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("impossible to read the width and height of file ''{0}''", new Object[]{super.getHandledFile().getFile().getName()}, (Throwable)e);
            }
            int widthAndHeightSize = 2;
            if (widthAndHeight == null || widthAndHeight.length != 2) {
                ((Photo)this.getMedia()).setDefinition(Definition.fromZero());
            } else {
                ((Photo)this.getMedia()).setDefinition(Definition.of((int)Integer.valueOf(widthAndHeight[0]), (int)Integer.valueOf(widthAndHeight[1])));
            }
        }

        private void createThumbnails() throws Exception {
            Photo photo = (Photo)this.getMedia();
            String photoId = photo.getId();
            MediaResolution[] mediaResolutions = new MediaResolution[]{MediaResolution.LARGE, MediaResolution.PREVIEW, MediaResolution.MEDIUM, MediaResolution.SMALL, MediaResolution.TINY};
            HandledFile originalFile = super.getHandledFile();
            HandledFile[] sources = (HandledFile[])Stream.of(this.thumbnailSrc).toArray(HandledFile[]::new);
            String originalFileExt = "." + FilenameUtils.getExtension((String)photo.getFileName());
            for (MediaResolution mediaResolution : mediaResolutions) {
                boolean watermarkApplicable = mediaResolution.isWatermarkApplicable();
                int index = watermarkApplicable && this.thumbnailSrc[1] != null ? 1 : 0;
                HandledFile currentThumbnail = originalFile.getParentHandledFile(new String[0]).getHandledFile(new String[]{photoId + mediaResolution.getThumbnailSuffix() + originalFileExt});
                this.generateThumbnail(this.thumbnailSrc[index], currentThumbnail, mediaResolution);
                if (sources[index] != this.thumbnailSrc[index]) continue;
                this.thumbnailSrc[index] = currentThumbnail;
            }
            if (sources[1] != null) {
                sources[1].delete();
            }
        }

        private void generateThumbnail(HandledFile sourceFile, HandledFile outputFile, MediaResolution mediaResolution) throws Exception {
            boolean resizeToPerform;
            boolean watermarkToApply = mediaResolution.isWatermarkApplicable() && !this.watermarkThumbnailOptions.isEmpty();
            Definition definition = ((Photo)this.getMedia()).getDefinition();
            boolean bl = resizeToPerform = definition.getWidth() > mediaResolution.getWidth() || definition.getHeight() > mediaResolution.getHeight();
            if (!resizeToPerform && !watermarkToApply) {
                sourceFile.copyFile(outputFile);
                return;
            }
            HashSet<Object> options = new HashSet<Object>();
            options.add(OrientationOption.auto());
            if (resizeToPerform) {
                options.add(DimensionOption.widthAndHeight((Integer)mediaResolution.getWidth(), (Integer)mediaResolution.getHeight()));
            }
            PhotoProcess.getImageTool().convert(sourceFile.getFile(), outputFile.getFile(), options, new ImageToolDirective[]{ImageToolDirective.PREVIEW_WORK, ImageToolDirective.GEOMETRY_SHRINK});
        }

        private void computeWatermarks(Watermark watermark) {
            String wText = null;
            File wImage = null;
            String thumbnailWText = null;
            File thumbnailWImage = null;
            Photo photo = (Photo)this.getMedia();
            if (watermark != null && watermark.isEnabled()) {
                try {
                    wText = StringUtil.defaultStringIfNotDefined((String)this.getIptcWatermarkValue(watermark, photo, watermark.getIPTCPropertyForHD()), (String)watermark.getTextForHD());
                    wImage = watermark.getImageForHD();
                    if (watermark.isDefinedForThumbnails()) {
                        thumbnailWText = StringUtil.defaultStringIfNotDefined((String)this.getIptcWatermarkValue(watermark, photo, watermark.getIPTCPropertyForThumbnails()), (String)watermark.getTextForThumbnails());
                        thumbnailWImage = watermark.getImageForThumbnails();
                    }
                }
                catch (MediaMetadataException e) {
                    SilverLogger.getLogger(MediaUtil.class).silent((Throwable)e).error("Bad image file format " + super.getHandledFile().getFile().getPath() + ": " + e.getMessage(), new Object[0]);
                }
                catch (IOException e) {
                    SilverLogger.getLogger(MediaUtil.class).silent((Throwable)e).error("Bad metadata encoding in image " + super.getHandledFile().getFile().getPath() + ": " + e.getMessage(), new Object[0]);
                }
            }
            this.watermarkNormalOptions = this.computeWatermarkOptions(wText, wImage);
            this.watermarkThumbnailOptions = this.computeWatermarkOptions(thumbnailWText, thumbnailWImage);
        }

        private void createNormals(Photo photo) {
            String originalFileExt = "." + FilenameUtils.getExtension((String)photo.getFileName());
            HandledFile normalFile = super.getHandledFile().getParentHandledFile(new String[0]).getHandledFile(new String[]{photo.getId() + "_normal" + originalFileExt});
            PhotoProcess.getImageTool().convert(super.getHandledFile().getFile(), normalFile.getFile(), (AbstractImageToolOption)OrientationOption.auto(), new ImageToolDirective[0]);
            this.thumbnailSrc[0] = normalFile;
            if (!this.watermarkNormalOptions.isEmpty()) {
                HandledFile watermarkFile = super.getHandledFile().getParentHandledFile(new String[0]).getHandledFile(new String[]{photo.getId() + "_watermark" + originalFileExt});
                PhotoProcess.getImageTool().convert(super.getHandledFile().getFile(), watermarkFile.getFile(), this.watermarkNormalOptions, new ImageToolDirective[0]);
            }
            if (!this.watermarkThumbnailOptions.isEmpty()) {
                HandledFile watermarkFileForThumbnails = super.getHandledFile().getParentHandledFile(new String[0]).getHandledFile(new String[]{photo.getId() + "_watermark_for_thumbnails" + originalFileExt});
                PhotoProcess.getImageTool().convert(super.getHandledFile().getFile(), watermarkFileForThumbnails.getFile(), this.watermarkThumbnailOptions, new ImageToolDirective[0]);
                this.thumbnailSrc[1] = watermarkFileForThumbnails;
            }
        }

        private Set<AbstractImageToolOption> computeWatermarkOptions(String textToWatermark, File imageToWatermark) {
            HashSet<AbstractImageToolOption> options = new HashSet<AbstractImageToolOption>();
            if (StringUtil.isDefined((String)textToWatermark)) {
                WatermarkTextOption wText = WatermarkTextOption.text((String)textToWatermark);
                if (imageToWatermark != null) {
                    wText.withAnchoringPosition(AnchoringPosition.SOUTH_WEST);
                }
                options.add((AbstractImageToolOption)wText);
            }
            if (imageToWatermark != null) {
                options.add((AbstractImageToolOption)WatermarkImageOption.image((File)imageToWatermark));
            }
            if (!options.isEmpty()) {
                options.add((AbstractImageToolOption)OrientationOption.auto());
            }
            return options;
        }

        private List<MetaData> getIptcMetaData() throws MediaMetadataException, IOException {
            if (this.cachedIptcMetadata == null) {
                DrewMediaMetadataExtractor extractor = new DrewMediaMetadataExtractor(((Photo)this.getMedia()).getInstanceId());
                this.cachedIptcMetadata = extractor.extractImageIptcMetaData(super.getHandledFile().getFile());
            }
            return this.cachedIptcMetadata;
        }

        private String getIptcWatermarkValue(Watermark watermark, Photo photo, String property) throws MediaMetadataException, IOException {
            String value = null;
            if (watermark.isBasedOnIPTC() && photo.getFileMimeType().isIPTCCompliant()) {
                value = this.getIptcMetaData().stream().filter(i -> property.equalsIgnoreCase(i.getProperty())).map(MetaData::getValue).findFirst().orElse(null);
            }
            return value;
        }
    }

    private static class VideoProcess
    extends MediaProcess<Video> {
        private VideoProcess(HandledFile handledFile, Video media) {
            super(handledFile, media);
        }

        @Override
        protected void generateFiles() {
            VideoThumbnailExtractor vte = VideoThumbnailExtractor.get();
            if (vte.isActivated()) {
                vte.generateThumbnailsFrom(this.getPhysicalFileMetaData(), super.getHandledFile().getFile());
            }
        }
    }

    private static class SoundProcess
    extends MediaProcess<Sound> {
        private SoundProcess(HandledFile handledFile, Sound media) {
            super(handledFile, media);
        }

        @Override
        protected void generateFiles() {
        }
    }

    private static abstract class MediaProcess<M extends InternalMedia> {
        private final HandledFile handledFile;
        private final M media;
        private final Set<MediaMimeType> supportedMimeTypes;
        private MediaMimeType physicalFileMimeType = null;
        private org.silverpeas.core.io.media.MetaData physicalFileMetaData = null;

        private MediaProcess(HandledFile handledFile, M media) {
            this.handledFile = handledFile;
            this.media = media;
            this.supportedMimeTypes = MediaMimeType.getSupportedMimeTypes(((Media)media).getType());
        }

        public void process() throws Exception {
            this.setInternalMetadata();
            this.generateFiles();
        }

        protected abstract void generateFiles();

        private void setInternalMetadata() throws Exception {
            File fileForData = this.getHandledFile().getFile();
            MediaMimeType mediaMimeType = this.getPhysicalFileMimeType();
            if (this.supportedMimeTypes.contains((Object)mediaMimeType)) {
                ((InternalMedia)this.getMedia()).setFileName(fileForData.getName());
                ((InternalMedia)this.getMedia()).setFileMimeType(mediaMimeType);
                ((InternalMedia)this.getMedia()).setFileSize(fileForData.length());
                MediaType mediaType = ((Media)this.getMedia()).getType();
                if (mediaType.isPhoto()) {
                    ((Media)this.getMedia()).getPhoto().setDefinition(this.getPhysicalFileMetaData().getDefinition());
                } else if (mediaType.isVideo()) {
                    ((Media)this.getMedia()).getVideo().setDefinition(this.getPhysicalFileMetaData().getDefinition());
                }
                if (this.getPhysicalFileMetaData().getDuration() != null) {
                    if (mediaType.isVideo()) {
                        ((Media)this.getMedia()).getVideo().setDuration(this.getPhysicalFileMetaData().getDuration().getTimeAsLong());
                    } else if (mediaType.isSound()) {
                        ((Media)this.getMedia()).getSound().setDuration(this.getPhysicalFileMetaData().getDuration().getTimeAsLong());
                    }
                }
                if (StringUtil.isNotDefined((String)((Media)this.getMedia()).getTitle()) && StringUtil.isDefined((String)this.getPhysicalFileMetaData().getTitle())) {
                    ((Media)this.getMedia()).setTitle(this.getPhysicalFileMetaData().getTitle());
                }
            } else {
                ((InternalMedia)this.getMedia()).setFileName(null);
                try {
                    throw new GalleryRuntimeException("Mime-Type of " + fileForData.getName() + " is not supported (" + FileUtil.getMimeType((String)fileForData.getPath()) + ")");
                }
                catch (Throwable throwable) {
                    this.getHandledFile().delete();
                    throw throwable;
                }
            }
        }

        org.silverpeas.core.io.media.MetaData getPhysicalFileMetaData() {
            if (this.physicalFileMetaData == null) {
                this.physicalFileMetaData = MetadataExtractor.get().extractMetadata(this.getHandledFile().getFile());
            }
            return this.physicalFileMetaData;
        }

        private MediaMimeType getPhysicalFileMimeType() {
            if (this.physicalFileMimeType == null) {
                this.physicalFileMimeType = MediaMimeType.fromFile(this.getHandledFile().getFile());
            }
            return this.physicalFileMimeType;
        }

        HandledFile getHandledFile() {
            return this.handledFile;
        }

        public M getMedia() {
            return this.media;
        }
    }
}

