/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.silverpeas.components.formsonline.model.FormDetail;
import org.silverpeas.components.formsonline.model.FormInstance;
import org.silverpeas.components.formsonline.model.FormInstanceValidationType;
import org.silverpeas.components.formsonline.model.FormPK;
import org.silverpeas.components.formsonline.model.FormsOnlineException;
import org.silverpeas.components.formsonline.model.RequestPK;
import org.silverpeas.components.formsonline.model.RequestValidationCriteria;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.util.Pair;
import org.silverpeas.core.util.SilverpeasList;

public interface FormsOnlineDAO {
    public List<FormDetail> findAllForms(String var1, String var2) throws FormsOnlineException;

    public FormDetail getForm(FormPK var1) throws FormsOnlineException;

    public FormDetail createForm(FormDetail var1) throws FormsOnlineException;

    public void updateForm(FormDetail var1) throws FormsOnlineException;

    public FormDetail deleteForm(FormPK var1) throws FormsOnlineException;

    public void updateSenders(FormPK var1, Map<String, Pair<List<String>, List<String>>> var2) throws FormsOnlineException;

    public void updateReceivers(FormPK var1, Map<String, Pair<List<String>, List<String>>> var2) throws FormsOnlineException;

    public List<String> getSendersAsUsers(FormPK var1) throws FormsOnlineException;

    public List<String> getSendersAsGroups(FormPK var1) throws FormsOnlineException;

    public List<String> getReceiversAsUsers(FormPK var1, String var2) throws FormsOnlineException;

    public List<String> getReceiversAsGroups(FormPK var1, String var2) throws FormsOnlineException;

    public List<FormDetail> getUserAvailableForms(Collection<String> var1, String var2, String[] var3, String var4) throws FormsOnlineException;

    public SilverpeasList<FormInstance> getSentFormInstances(FormPK var1, String var2, List<Integer> var3, PaginationPage var4) throws FormsOnlineException;

    public SilverpeasList<FormInstance> getReceivedRequests(FormDetail var1, List<Integer> var2, RequestValidationCriteria var3, PaginationPage var4) throws FormsOnlineException;

    public Map<String, Set<FormInstanceValidationType>> getValidatorFormIdsWithValidationTypes(String var1, String var2, String[] var3, Collection<String> var4) throws FormsOnlineException;

    public Map<String, Set<FormInstanceValidationType>> getPossibleValidationTypesByFormId(Collection<String> var1) throws FormsOnlineException;

    public FormInstance getRequest(RequestPK var1) throws FormsOnlineException;

    public List<FormDetail> getForms(Collection<String> var1) throws FormsOnlineException;

    public FormInstance saveRequest(FormInstance var1) throws FormsOnlineException;

    public void saveRequestState(FormInstance var1) throws FormsOnlineException;

    public void deleteRequest(RequestPK var1) throws FormsOnlineException;

    public Map<Integer, Integer> getNumberOfRequestsByForm(String var1) throws FormsOnlineException;

    public SilverpeasList<FormInstance> getAllRequests(FormPK var1) throws FormsOnlineException;
}

