/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.silverpeas.components.formsonline.model.FormInstance;
import org.silverpeas.components.formsonline.model.FormInstanceValidationType;
import org.silverpeas.core.SilverpeasRuntimeException;
import org.silverpeas.core.contribution.ContributionStatus;
import org.silverpeas.core.test.rule.DbSetupRule;
import org.silverpeas.core.test.rule.DbUnitLoadingRule;
import org.silverpeas.core.test.rule.TestStatisticRule;
import org.silverpeas.core.util.Mutable;
import org.silverpeas.core.util.StringUtil;

public abstract class AbstractFormsOnlineIT {
    @Rule
    public TestStatisticRule testStatisticRule = new TestStatisticRule();
    @Rule
    public DbUnitLoadingRule dbUnitLoadingRule = new DbUnitLoadingRule("create-database.sql", "forms-dataset.xml");
    static final String DYNAMIC_DATA_INSTANCE_ID = "formsOnline26";
    static final String DEFAULT_INSTANCE_ID = "formsOnline100";
    static final String ORDERBY_DEFAULT = "name";
    static final String VALIDATOR_ID_29 = "29";
    static final String VALIDATOR_ID_30 = "30";
    static final String VALIDATOR_ID_31 = "31";
    static final String H_DATE = "2020-01-01 06:54:23.26";
    static final String I_DATE = "2020-02-02 11:55:34.38";
    static final String F_DATE = "2020-03-03 15:08:01.07";
    static final String[] DEFAULT_CREATOR_IDS = new String[]{"1", "2"};
    static final Integer[] DEFAULT_FORM_STATES = new Integer[]{1, 2};
    static final Object[] DEFAULT_VALIDATION_CYCLE = new Object[]{null, new Object[][]{{"29", FormInstanceValidationType.HIERARCHICAL, ContributionStatus.VALIDATED, false, "2020-01-01 06:54:23.26", "OK"}}, new Object[][]{{"29", FormInstanceValidationType.INTERMEDIATE, ContributionStatus.VALIDATED, true, "2020-02-02 11:55:34.38", "Bon d'accord"}}, new Object[][]{{"29", FormInstanceValidationType.FINAL, ContributionStatus.VALIDATED, false, "2020-03-03 15:08:01.07", "Valid\u00e9"}}, new Object[][]{{"29", FormInstanceValidationType.HIERARCHICAL, ContributionStatus.REFUSED, false, "2020-01-01 06:54:23.26", "Ha non"}}, new Object[][]{{"29", FormInstanceValidationType.INTERMEDIATE, ContributionStatus.REFUSED, false, "2020-02-02 11:55:34.38", "non non non"}}, new Object[][]{{"29", FormInstanceValidationType.FINAL, ContributionStatus.REFUSED, false, "2020-03-03 15:08:01.07", ":-("}}, new Object[][]{{"29", FormInstanceValidationType.HIERARCHICAL, ContributionStatus.VALIDATED, false, "2020-01-01 06:54:23.26", "OK"}, {"30", FormInstanceValidationType.INTERMEDIATE, ContributionStatus.VALIDATED, false, "2020-02-02 11:55:34.38", "OK aussi"}}, new Object[][]{{"29", FormInstanceValidationType.HIERARCHICAL, ContributionStatus.VALIDATED, true, "2020-01-01 06:54:23.26", "OK"}, {"30", FormInstanceValidationType.INTERMEDIATE, ContributionStatus.VALIDATED, true, "2020-02-02 11:55:34.38", "OK aussi"}, {"31", FormInstanceValidationType.FINAL, ContributionStatus.VALIDATED, false, "2020-03-03 15:08:01.07", "Bon ben d'accord alors"}}, new Object[][]{{"29", FormInstanceValidationType.HIERARCHICAL, ContributionStatus.VALIDATED, false, "2020-01-01 06:54:23.26", "OK"}, {"31", FormInstanceValidationType.FINAL, ContributionStatus.REFUSED, false, "2020-03-03 15:08:01.07", "En fait non !"}}, new Object[][]{{"30", FormInstanceValidationType.INTERMEDIATE, ContributionStatus.VALIDATED, false, "2020-02-02 11:55:34.38", "OK"}, {"31", FormInstanceValidationType.FINAL, ContributionStatus.VALIDATED, false, "2020-03-03 15:08:01.07", "OK !"}}, new Object[][]{{"29", FormInstanceValidationType.HIERARCHICAL, ContributionStatus.VALIDATED, true, "2020-01-01 06:54:23.26", "OK"}, {"30", FormInstanceValidationType.INTERMEDIATE, ContributionStatus.VALIDATED, true, "2020-02-02 11:55:34.38", "OK aussi"}, {"31", FormInstanceValidationType.FINAL, ContributionStatus.VALIDATED, false, "2020-03-03 15:08:01.07", "Bon ben d'accord alors"}}};

    List<String> createDefaultDynamicContextOfData(int nbForms, int nbRequests) {
        return this.createDynamicContextOfData(nbForms, nbRequests, DEFAULT_CREATOR_IDS, DEFAULT_FORM_STATES, DEFAULT_VALIDATION_CYCLE);
    }

    List<String> createDynamicContextOfData(int nbForms, int nbRequests, String[] creators, Integer[] formStates, Object[] validations) {
        int idOffset = 100001;
        this.testStatisticRule.log("creating " + nbForms + " forms with " + nbRequests + " requests per form...");
        long start = System.currentTimeMillis();
        ArrayList<String> requestIds = new ArrayList<String>(nbForms);
        StringBuilder forms = new StringBuilder();
        StringBuilder requests = new StringBuilder();
        StringBuilder requestValidations = new StringBuilder();
        Mutable formId = Mutable.of((Object)100001);
        Mutable requestId = Mutable.of((Object)100001);
        Mutable validationId = Mutable.of((Object)100001);
        IntStream.rangeClosed(1, nbForms).forEach(f -> {
            Stream.of(forms).filter(b -> b.length() > 0).forEach(b -> b.append(","));
            String formIdAsString = (String)formId.map(String::valueOf).get();
            formId.set((Object)((Integer)formId.get() + 1));
            forms.append(MessageFormat.format("({0}, ''descriptif_salle.xml'', ''R\u00e9f\u00e9rencement des salles'', ''Formulaire de description d'une salle'', ''2020-01-01 12:30:45.78'', 1, ''formsOnline26'', 1 , ''1'', ''Titre de mon formulaire en ligne'')", formIdAsString));
            IntStream.rangeClosed(1, nbRequests).forEach(r -> {
                Stream.of(requests).filter(b -> b.length() > 0).forEach(b -> b.append(","));
                String requestIdAsString = (String)requestId.map(String::valueOf).get();
                requestId.set((Object)((Integer)requestId.get() + 1));
                requestIds.add(requestIdAsString);
                int formStateIndex = (r - 1) % formStates.length;
                int creatorIdIndex = (r - 1) % creators.length;
                requests.append(MessageFormat.format("({0}, {1}, {2}, ''{3}'', ''2020-01-01 08:00:00.0'', ''formsOnline26'')", requestIdAsString, formIdAsString, formStates[formStateIndex], creators[creatorIdIndex]));
                int validationIdIndex = (r - 1) % validations.length;
                Object[][] currentValidations = (Object[][])validations[validationIdIndex];
                if (currentValidations != null) {
                    for (Object[] v : currentValidations) {
                        Stream.of(requestValidations).filter(b -> b.length() > 0).forEach(b -> b.append(","));
                        String validationIdAsString = (String)validationId.map(String::valueOf).get();
                        validationId.set((Object)((Integer)validationId.get() + 1));
                        requestValidations.append(MessageFormat.format("({0}, {1}, ''{2}'', ''{3}'', ''{4}'', {5}, ''{6}'', ''{7}'')", validationIdAsString, requestIdAsString, v[0], v[1], v[2], v[3], v[4], v[5].toString().replace("'", "''")));
                    }
                }
            });
            if ((Integer)requestId.get() % 10000 == 0) {
                this.performQueries(forms, requests, requestValidations);
            }
        });
        this.performQueries(forms, requests, requestValidations);
        this.testStatisticRule.log("ending the creation of " + nbForms + " forms with " + nbRequests + " requests per form", start, System.currentTimeMillis());
        return requestIds;
    }

    private void performQueries(StringBuilder forms, StringBuilder requests, StringBuilder validations) {
        if (forms.length() > 0) {
            forms.insert(0, "id, xmlFormName, name, description, creationDate, state, instanceId, alreadyUsed, creatorId, title) VALUES ");
            forms.insert(0, "INSERT INTO SC_FormsOnline_Forms (");
        }
        if (requests.length() > 0) {
            requests.insert(0, "INSERT INTO sc_formsonline_forminstances (id, formId, state, creatorId, creationDate, instanceId) VALUES ");
        }
        if (validations.length() > 0) {
            validations.insert(0, "INSERT INTO sc_formsonline_forminstvali (id, formInstId, validationBy, validationType, status, follower, validationDate, validationComment) VALUES ");
        }
        this.executePlainQueries(forms.toString(), requests.toString(), validations.toString());
        Stream.of(forms, requests, validations).forEach(b -> b.setLength(0));
    }

    private void executePlainQueries(String ... plainQueries) {
        try (Connection connection = DbSetupRule.getSafeConnection();){
            for (String query : plainQueries) {
                if (StringUtil.isNotDefined((String)query)) continue;
                try (PreparedStatement ps = connection.prepareStatement(query);){
                    this.testStatisticRule.log("registering " + ps.executeUpdate() + " lines");
                }
            }
        }
        catch (SQLException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    void assertContainsIdsWithOffsetAutomaticallyApplied(List<FormInstance> requests, Integer ... ids) {
        MatcherAssert.assertThat(requests.stream().map(FormInstance::getId).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])((String[])Stream.of(ids).map(i -> String.valueOf(i + 100000)).toArray(String[]::new))));
    }
}

