/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.suggestionbox.model;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Vetoed;
import org.silverpeas.components.suggestionbox.model.SuggestionBox;
import org.silverpeas.components.suggestionbox.model.SuggestionCriteriaProcessor;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.ContributionStatus;
import org.silverpeas.core.util.CollectionUtil;

@Vetoed
public class SuggestionCriteria {
    private SuggestionBox suggestionBox;
    private User creator;
    private final List<ContributionStatus> statuses = new ArrayList<ContributionStatus>();
    private final List<JOIN_DATA_APPLY> joinDataApplyList = new ArrayList<JOIN_DATA_APPLY>();
    private final List<QUERY_ORDER_BY> orderByList = new ArrayList<QUERY_ORDER_BY>();
    private final List<String> identifiers = new ArrayList<String>();
    private boolean loadWysiwygContent = false;
    private PaginationPage pagination;

    private SuggestionCriteria() {
    }

    public static SuggestionCriteria from(SuggestionBox suggestionBox) {
        SuggestionCriteria criteria = new SuggestionCriteria();
        criteria.suggestionBox = suggestionBox;
        return criteria;
    }

    public SuggestionCriteria createdBy(User user) {
        this.creator = user;
        return this;
    }

    public SuggestionCriteria paginatedBy(PaginationPage pagination) {
        this.pagination = pagination;
        return this;
    }

    public SuggestionCriteria statusIsOneOf(ContributionStatus ... statuses) {
        CollectionUtil.addAllIgnoreNull(this.statuses, (Object[])statuses);
        return this;
    }

    public SuggestionCriteria applyJoinOnData(JOIN_DATA_APPLY ... joinDataApplies) {
        CollectionUtil.addAllIgnoreNull(this.joinDataApplyList, (Object[])joinDataApplies);
        return this;
    }

    public SuggestionCriteria orderedBy(QUERY_ORDER_BY ... orderBies) {
        CollectionUtil.addAllIgnoreNull(this.orderByList, (Object[])orderBies);
        return this;
    }

    public SuggestionCriteria identifierIsOneOf(String ... identifiers) {
        CollectionUtil.addAllIgnoreNull(this.identifiers, (Object[])identifiers);
        return this;
    }

    public SuggestionCriteria withWysiwygContent() {
        this.loadWysiwygContent = true;
        return this;
    }

    public SuggestionBox getSuggestionBox() {
        return this.suggestionBox;
    }

    private User getCreator() {
        return this.creator;
    }

    private List<ContributionStatus> getStatuses() {
        return this.statuses;
    }

    private List<String> getIdentifiers() {
        return this.identifiers;
    }

    private List<JOIN_DATA_APPLY> getJoinDataApplyList() {
        return this.joinDataApplyList;
    }

    private List<QUERY_ORDER_BY> getOrderByList() {
        return this.orderByList;
    }

    private PaginationPage getPagination() {
        return this.pagination;
    }

    public boolean mustLoadWysiwygContent() {
        return this.loadWysiwygContent;
    }

    public void processWith(SuggestionCriteriaProcessor processor) {
        processor.startProcessing();
        processor.processSuggestionBox(this.getSuggestionBox());
        if (!this.getJoinDataApplyList().isEmpty()) {
            processor.processJoinDataApply(this.getJoinDataApplyList());
        }
        if (!this.getIdentifiers().isEmpty()) {
            processor.then().processIdentifiers(this.getIdentifiers());
        }
        if (this.getCreator() != null) {
            processor.then().processCreator(this.getCreator());
        }
        if (!this.getStatuses().isEmpty()) {
            processor.then().processStatus(this.getStatuses());
        }
        if (!this.getOrderByList().isEmpty()) {
            processor.then().processOrdering(this.getOrderByList());
        }
        if (this.getPagination() != null) {
            processor.then().processPagination(this.getPagination());
        }
        processor.endProcessing();
    }

    public static enum QUERY_ORDER_BY {
        TITLE_ASC(true, "title", true),
        LAST_UPDATE_DATE_ASC(true, "lastUpdateDate", true),
        STATUS_ASC(true, "status", true),
        TITLE_DESC(true, "title", false),
        LAST_UPDATE_DATE_DESC(true, "lastUpdateDate", false),
        VALIDATION_DATE_DESC(true, "validation.validationDate", false),
        COMMENT_COUNT_DESC(false, "commentCount", false);

        private final boolean applicableOnJpaQuery;
        private final String propertyName;
        private final boolean asc;

        public static QUERY_ORDER_BY fromPropertyName(String property) {
            QUERY_ORDER_BY type = null;
            if ("commentCount".equals(property)) {
                type = COMMENT_COUNT_DESC;
            } else if ("validation.validationDate".equals(property)) {
                type = VALIDATION_DATE_DESC;
            } else if ("lastUpdateDate".equals(property)) {
                type = LAST_UPDATE_DATE_DESC;
            } else if ("title".equals(property)) {
                type = TITLE_DESC;
            }
            return type;
        }

        private QUERY_ORDER_BY(boolean applicableOnJpaQuery, String propertyName, boolean asc) {
            this.applicableOnJpaQuery = applicableOnJpaQuery;
            this.propertyName = propertyName;
            this.asc = asc;
        }

        public boolean isApplicableOnJpaQuery() {
            return this.applicableOnJpaQuery;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public boolean isAsc() {
            return this.asc;
        }
    }

    public static enum JOIN_DATA_APPLY {
        COMMENT;

    }
}

