/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.silvercrawler.model;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.silverpeas.components.silvercrawler.model.FileDetail;
import org.silverpeas.core.SilverpeasRuntimeException;
import org.silverpeas.core.index.indexing.IndexFileManager;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.core.util.logging.SilverLogger;

public class FileFolder
implements Serializable {
    private static final long serialVersionUID = 7637795486882013995L;
    private List<FileDetail> files;
    private List<FileDetail> folders;
    private String name;
    private String path;
    private boolean writable;
    private boolean readable;

    public FileFolder(String rootPath, String path) {
        this(rootPath, path, false, "");
    }

    public boolean isWritable() {
        return this.writable;
    }

    public FileFolder(String rootPath, String path, boolean isAdmin, String componentId) {
        this.path = path;
        this.files = new ArrayList<FileDetail>(0);
        this.folders = new ArrayList<FileDetail>(0);
        DirectoryReader reader = null;
        try {
            FileUtil.validateFilename((String)path, (String)rootPath);
            File f = new File(path);
            this.writable = f.canWrite();
            if (f.exists()) {
                FSDirectory indexPath;
                this.name = f.getName();
                this.readable = f.canRead();
                File[] children = f.listFiles();
                boolean isIndexed = false;
                if (isAdmin && DirectoryReader.indexExists((Directory)(indexPath = FSDirectory.open((Path)Paths.get(IndexFileManager.getAbsoluteIndexPath((String)componentId), new String[0]))))) {
                    reader = DirectoryReader.open((Directory)indexPath);
                }
                if (children != null && children.length > 0) {
                    for (File childFile : children) {
                        isIndexed = false;
                        if (isAdmin) {
                            StringBuilder pathIndex = new StringBuilder(componentId).append("|");
                            if (childFile.isDirectory()) {
                                pathIndex.append("LinkedDir").append("|");
                            } else {
                                pathIndex.append("LinkedFile").append("|");
                            }
                            pathIndex.append(FilenameUtils.separatorsToUnix((String)childFile.getPath()));
                            Term term = new Term("key", pathIndex.toString());
                            if (reader != null && reader.docFreq(term) == 1) {
                                isIndexed = true;
                            }
                        }
                        if (childFile.isDirectory()) {
                            this.folders.add(new FileDetail(childFile.getName(), childFile.getPath(), null, childFile.length(), true, isIndexed));
                            continue;
                        }
                        String childPath = FileUtils.getFile((String[])new String[]{childFile.getPath().substring(rootPath.length())}).getPath();
                        this.files.add(new FileDetail(childFile.getName(), childPath, childFile.getPath(), childFile.length(), false, isIndexed));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
        finally {
            if (reader != null && isAdmin) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    SilverLogger.getLogger((Object)this).warn((Throwable)e);
                }
            }
        }
    }

    public Collection<FileDetail> getFiles() {
        return this.files;
    }

    public Collection<FileDetail> getFolders() {
        return this.folders;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void setReadable(boolean readable) {
        this.readable = readable;
    }

    public boolean isReadable() {
        return this.readable;
    }
}

