/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.whitepages.service;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.silverpeas.components.whitepages.service.MixedSearchService;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.index.indexing.model.FieldDescription;
import org.silverpeas.core.index.search.model.QueryDescription;
import org.silverpeas.core.index.search.model.SearchResult;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.core.search.SearchService;
import org.silverpeas.core.util.CollectionUtil;

@Service
public class MixedSearchServiceImpl
implements MixedSearchService {
    @Inject
    private PdcManager pdcManager = null;

    @Override
    public List<SearchResult> search(String componentId, String userId, String queryString, String taxonomyPosition, Map<String, String> xmlFields, String xmlTemplate, List<FieldDescription> fieldsQuery, String language) throws Exception {
        QueryDescription query = new QueryDescription(queryString);
        query.setSearchingUser(userId);
        query.addComponent(componentId);
        if (xmlFields != null && !xmlFields.isEmpty() && xmlTemplate != null) {
            for (Map.Entry<String, String> entry : xmlFields.entrySet()) {
                String value = entry.getValue();
                value = value.trim().replaceAll("##", " AND ");
                query.addFieldQuery(new FieldDescription(xmlTemplate + "$$" + entry.getKey(), value, language));
            }
        }
        if (CollectionUtil.isNotEmpty(fieldsQuery)) {
            query.setFieldQueries(fieldsQuery);
        }
        query.setTaxonomyPosition(taxonomyPosition);
        SearchService searchService = SearchService.get();
        return searchService.search(query);
    }
}

