/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.websites;

import java.io.File;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.component.ComponentInstancePostConstruction;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.SettingBundle;
import org.silverpeas.core.util.file.FileFolderManager;

@Named
public class WebSitesInstancePostConstruction
implements ComponentInstancePostConstruction {
    @Transactional
    public void postConstruct(String componentInstanceId) {
        NodeService nodeService = NodeService.get();
        NodeDetail websites = this.getWebSitesRootNodeFor(componentInstanceId);
        nodeService.createNode(websites);
        this.createAttachmentsAndImagesDirectory(componentInstanceId);
    }

    private NodeDetail getWebSitesRootNodeFor(String componentInstanceId) {
        NodeDetail webSites = new NodeDetail();
        webSites.setNodePK(new NodePK("0", componentInstanceId));
        webSites.setFatherPK(null);
        webSites.setUseId(true);
        webSites.setName("Accueil");
        webSites.setDescription("La Racine");
        webSites.setCreatorId(UserDetail.getCurrentRequester().getId());
        webSites.setLevel(1);
        webSites.setStatus("Visible");
        return webSites;
    }

    private void createAttachmentsAndImagesDirectory(String componentId) {
        SettingBundle uploadSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.webSites.settings.webSiteSettings");
        File uploadFolder = new File(uploadSettings.getString("uploadsPath"));
        if (!uploadFolder.exists()) {
            FileFolderManager.createFolder((File)uploadFolder);
        }
        FileFolderManager.createFolder((File)new File(uploadFolder, componentId));
    }
}

