/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia;

import java.util.HashMap;
import org.silverpeas.components.kmelia.KmeliaPasteDetail;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.component.model.PasteDetail;
import org.silverpeas.core.admin.component.model.PasteDetailFromToPK;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.util.StringUtil;

public class KmeliaCopyDetail
extends PasteDetailFromToPK<NodePK, NodePK> {
    public static final String PUBLICATION_HEADER = "PasteOption_PublicationHeader";
    public static final String PUBLICATION_CONTENT = "PasteOption_PublicationContent";
    public static final String PUBLICATION_FILES = "PasteOption_PublicationFiles";
    public static final String PUBLICATION_PDC = "PasteOption_PublicationPDC";
    public static final String NODE_RIGHTS = "PasteOption_NodeRights";
    public static final String ADMINISTRATIVE_OPERATION = "PasteOption_AdministrativeOperation";
    private String publicationTargetValidatorIds;
    private String publicationStatus;

    public KmeliaCopyDetail(String userId) {
        super(userId);
    }

    public KmeliaCopyDetail(PasteDetail pasteDetail) {
        this.setOptions(pasteDetail.getOptions() != null ? new HashMap(pasteDetail.getOptions()) : null);
        this.setUserId(pasteDetail.getUserId());
        if (pasteDetail instanceof KmeliaCopyDetail) {
            KmeliaCopyDetail copyDetail = (KmeliaCopyDetail)pasteDetail;
            this.setPublicationStatus(copyDetail.getPublicationStatus());
            this.setPublicationTargetValidatorIds(copyDetail.getPublicationValidatorIds());
            this.setFromComponentId(copyDetail.getFromComponentId());
        }
    }

    public static KmeliaCopyDetail fromPasteDetail(KmeliaPasteDetail pasteDetail) {
        KmeliaCopyDetail copyDetail = new KmeliaCopyDetail(pasteDetail.getUserId());
        copyDetail.setToNodePK(pasteDetail.getToPK());
        copyDetail.setPublicationStatus(pasteDetail.getStatus());
        copyDetail.setPublicationTargetValidatorIds(pasteDetail.getTargetValidatorIds());
        return copyDetail;
    }

    public void setFromNodePK(NodePK fromNodePK) {
        this.setFromPK((ResourceReference)fromNodePK);
        this.setFromComponentId(fromNodePK.getInstanceId());
    }

    public NodePK getFromNodePK() {
        return (NodePK)this.getFromPK();
    }

    public void setToNodePK(NodePK toNodePK) {
        this.setToPK((ResourceReference)toNodePK);
    }

    public NodePK getToNodePK() {
        return (NodePK)this.getToPK();
    }

    public String getPublicationValidatorIds() {
        return this.publicationTargetValidatorIds;
    }

    public void setPublicationTargetValidatorIds(String ids) {
        this.publicationTargetValidatorIds = ids;
    }

    public String getPublicationStatus() {
        return this.publicationStatus;
    }

    public void setPublicationStatus(String publicationStatus) {
        this.publicationStatus = publicationStatus;
    }

    public boolean isPublicationHeaderMustBeCopied() {
        return this.getOptions() == null || this.isMustBeCopied(PUBLICATION_HEADER) || this.isPublicationContentMustBeCopied() || this.isPublicationFilesMustBeCopied();
    }

    public boolean isPublicationContentMustBeCopied() {
        return this.isMustBeCopied(PUBLICATION_CONTENT);
    }

    public boolean isPublicationFilesMustBeCopied() {
        return this.isMustBeCopied(PUBLICATION_FILES);
    }

    public boolean isPublicationPositionsMustBeCopied() {
        return this.isMustBeCopied(PUBLICATION_PDC);
    }

    public boolean isNodeRightsMustBeCopied() {
        return this.isMustBeCopied(NODE_RIGHTS);
    }

    private boolean isMustBeCopied(String optionName) {
        return this.getOptions() == null || StringUtil.getBooleanValue((String)((String)this.getOptions().get(optionName)));
    }

    public boolean isAdministrativeOperation() {
        return this.getOptions() != null && StringUtil.getBooleanValue((String)((String)this.getOptions().get(ADMINISTRATIVE_OPERATION)));
    }
}

