/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.scheduleevent.service;

import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.components.scheduleevent.service.ScheduleEventService;
import org.silverpeas.components.scheduleevent.service.model.beans.Contributor;
import org.silverpeas.components.scheduleevent.service.model.beans.ScheduleEvent;
import org.silverpeas.components.scheduleevent.service.model.dao.ScheduleEventDao;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.util.LocalizationBundle;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.SettingBundle;

@Service
@Named(value="scheduledEventService")
public class ScheduleEventServiceImpl
implements ScheduleEventService {
    private static final String MESSAGES_PATH = "org.silverpeas.components.scheduleevent.multilang.ScheduleEventBundle";
    private static final String SETTINGS_PATH = "org.silverpeas.components.scheduleevent.settings.ScheduleEventSettings";
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.components.scheduleevent.settings.ScheduleEventSettings");
    @Inject
    private ScheduleEventDao scheduleEventDao;

    @Override
    public void createScheduleEvent(ScheduleEvent scheduleEvent) {
        this.scheduleEventDao.createScheduleEvent(scheduleEvent);
    }

    @Override
    public void deleteScheduleEvent(ScheduleEvent scheduleEvent) {
        this.scheduleEventDao.deleteScheduleEvent(scheduleEvent);
    }

    @Override
    public ScheduleEvent findScheduleEvent(String scheduleEventId) {
        return this.scheduleEventDao.getScheduleEvent(scheduleEventId);
    }

    @Override
    public Set<ScheduleEvent> listAllScheduleEventsByUserId(String userId) {
        Set<ScheduleEvent> events = this.scheduleEventDao.listScheduleEventsByCreatorId(userId);
        events.addAll(this.scheduleEventDao.listScheduleEventsByContributorId(userId));
        return events;
    }

    @Override
    public void updateScheduleEventStatus(String scheduleEventId, int newStatus) {
        ScheduleEvent event = this.scheduleEventDao.getScheduleEvent(scheduleEventId);
        event.setStatus(newStatus);
        this.scheduleEventDao.updateScheduleEvent(event);
    }

    @Override
    public ScheduleEvent purgeOldResponseForUserId(ScheduleEvent scheduleEvent, int userId) {
        this.scheduleEventDao.purgeResponseScheduleEvent(scheduleEvent, userId);
        return this.scheduleEventDao.getScheduleEvent(scheduleEvent.getId());
    }

    @Override
    public void updateScheduleEvent(ScheduleEvent scheduleEvent) {
        this.scheduleEventDao.updateScheduleEvent(scheduleEvent);
    }

    @Override
    public void setLastVisited(ScheduleEvent event, int userId) {
        Set<Contributor> contributors = event.getContributors();
        Iterator<Contributor> iter = contributors.iterator();
        boolean finish = false;
        while (iter.hasNext() && !finish) {
            Contributor contrib = iter.next();
            if (userId != contrib.getUserId()) continue;
            contrib.setLastVisit(new Date());
            finish = true;
        }
        this.scheduleEventDao.updateScheduleEvent(event);
    }

    @Override
    public Optional<ScheduleEvent> getContributionById(ContributionIdentifier contributionId) {
        return Optional.ofNullable(this.findScheduleEvent(contributionId.getLocalId()));
    }

    public SettingBundle getComponentSettings() {
        return settings;
    }

    public LocalizationBundle getComponentMessages(String language) {
        return ResourceLocator.getLocalizationBundle((String)MESSAGES_PATH, (String)language);
    }

    public boolean isRelatedTo(String instanceId) {
        return instanceId.startsWith("scheduleEvent");
    }
}

