/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.personalorganizer.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.exception.UtilException;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.personalorganizer.model.JournalHeader;
import org.silverpeas.core.personalorganizer.model.SchedulableCount;
import org.silverpeas.core.personalorganizer.service.CalendarException;
import org.silverpeas.core.personalorganizer.socialnetwork.SocialInformationEvent;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.logging.SilverLogger;

@Repository
public class JournalDAO {
    public static final String COLUMNNAMES = "id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, externalId";
    private static final String JOURNALCOLUMNNAMES = "CalendarJournal.id, CalendarJournal.name, CalendarJournal.delegatorId, CalendarJournal.description, CalendarJournal.priority,  CalendarJournal.classification, CalendarJournal.startDay, CalendarJournal.startHour, CalendarJournal.endDay, CalendarJournal.endHour, CalendarJournal.externalId";
    private static final String INSERT_JOURNAL = "INSERT INTO CalendarJournal (id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, externalId) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_JOURNAL = "UPDATE CalendarJournal SET name = ?, delegatorId = ?, description = ?, priority = ?, classification = ?, startDay = ?, startHour = ?, endDay = ?, endHour = ?, externalId = ? WHERE id = ?";
    private static final String DELETE_JOURNAL = "DELETE FROM CalendarJournal WHERE id = ?";
    private static final String SELECT_DISTINCT = "select distinct ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addJournal(Connection con, JournalHeader journal) throws SQLException, UtilException, CalendarException {
        PreparedStatement prepStmt = null;
        int id = 0;
        try {
            prepStmt = con.prepareStatement(INSERT_JOURNAL);
            id = DBUtil.getNextId((String)"CalendarJournal", (String)"id");
            prepStmt.setInt(1, id);
            prepStmt.setString(2, journal.getName());
            prepStmt.setString(3, journal.getDelegatorId());
            prepStmt.setString(4, journal.getDescription());
            prepStmt.setInt(5, journal.getPriority().getValue());
            prepStmt.setString(6, journal.getClassification().getString());
            prepStmt.setString(7, journal.getStartDay());
            prepStmt.setString(8, journal.getStartHour());
            prepStmt.setString(9, journal.getEndDay());
            prepStmt.setString(10, journal.getEndHour());
            prepStmt.setString(11, journal.getExternalId());
            if (prepStmt.executeUpdate() == 0) {
                throw new CalendarException("JournalDAO.Connection con,  addJournal(Connection con, JournalHeader journal)", 4, "calendar.EX_EXCUTE_INSERT_EMPTY");
            }
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
        return String.valueOf(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJournal(Connection con, JournalHeader journal) throws SQLException, CalendarException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(UPDATE_JOURNAL);
            prepStmt.setString(1, journal.getName());
            prepStmt.setString(2, journal.getDelegatorId());
            prepStmt.setString(3, journal.getDescription());
            prepStmt.setInt(4, journal.getPriority().getValue());
            prepStmt.setString(5, journal.getClassification().getString());
            prepStmt.setString(6, journal.getStartDay());
            prepStmt.setString(7, journal.getStartHour());
            prepStmt.setString(8, journal.getEndDay());
            prepStmt.setString(9, journal.getEndHour());
            prepStmt.setString(10, journal.getExternalId());
            prepStmt.setInt(11, Integer.parseInt(journal.getId()));
            if (prepStmt.executeUpdate() == 0) {
                throw new CalendarException("JournalDAO.Connection con,  updateJournal(Connection con, JournalHeader journal)", 4, "calendar.EX_EXCUTE_UPDATE_EMPTY");
            }
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJournal(Connection con, String id) throws SQLException, CalendarException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(DELETE_JOURNAL);
            prepStmt.setInt(1, Integer.parseInt(id));
            if (prepStmt.executeUpdate() == 0) {
                throw new CalendarException("JournalDAO.Connection con,  removeJournal(Connection con, JournalHeader journal)", 4, "calendar.EX_EXCUTE_DELETE_EMPTY");
            }
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    public boolean hasTentativeJournalsForUser(Connection con, String userId) throws SQLException {
        try (PreparedStatement prepStmt = this.getTentativePreparedStatement(con, userId);){
            boolean bl;
            block12: {
                ResultSet rs = prepStmt.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    public Collection<JournalHeader> getTentativeJournalHeadersForUser(Connection con, String userId) throws SQLException, ParseException {
        ArrayList<JournalHeader> list = new ArrayList<JournalHeader>();
        try (PreparedStatement prepStmt = this.getTentativePreparedStatement(con, userId);
             ResultSet rs = prepStmt.executeQuery();){
            while (rs.next()) {
                JournalHeader journal = this.getJournalHeaderFromResultSet(rs);
                list.add(journal);
            }
        }
        return list;
    }

    private PreparedStatement getTentativePreparedStatement(Connection con, String userId) throws SQLException {
        String selectStatement = "select distinct CalendarJournal.id, CalendarJournal.name, CalendarJournal.delegatorId, CalendarJournal.description, CalendarJournal.priority,  CalendarJournal.classification, CalendarJournal.startDay, CalendarJournal.startHour, CalendarJournal.endDay, CalendarJournal.endHour, CalendarJournal.externalId from CalendarJournal, CalendarJournalAttendee  WHERE (CalendarJournal.id = CalendarJournalAttendee.journalId)  and (CalendarJournalAttendee.participationStatus = ?)  and (userId = ?)  order by startDay, startHour";
        PreparedStatement prepStmt = con.prepareStatement("select distinct CalendarJournal.id, CalendarJournal.name, CalendarJournal.delegatorId, CalendarJournal.description, CalendarJournal.priority,  CalendarJournal.classification, CalendarJournal.startDay, CalendarJournal.startHour, CalendarJournal.endDay, CalendarJournal.endHour, CalendarJournal.externalId from CalendarJournal, CalendarJournalAttendee  WHERE (CalendarJournal.id = CalendarJournalAttendee.journalId)  and (CalendarJournalAttendee.participationStatus = ?)  and (userId = ?)  order by startDay, startHour");
        prepStmt.setString(1, "tentative");
        prepStmt.setString(2, userId);
        return prepStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<JournalHeader> getJournalHeadersForUser(Connection con, String day, String userId, String categoryId, String participation, String comparator) throws SQLException, ParseException {
        StringBuilder selectStatement = new StringBuilder();
        selectStatement.append(SELECT_DISTINCT).append(JOURNALCOLUMNNAMES).append(" from CalendarJournal, CalendarJournalAttendee ");
        if (categoryId != null) {
            selectStatement.append(", CalendarJournalCategory ");
        }
        selectStatement.append(" where (CalendarJournal.id = CalendarJournalAttendee.journalId) ");
        selectStatement.append(" and (userId = '").append(userId).append("'");
        selectStatement.append(" and participationStatus = '").append(participation).append("') ");
        if (categoryId != null) {
            selectStatement.append(" and (CalendarJournal.id = CalendarJournalCategory.journalId) ");
            selectStatement.append(" and (CalendarJournalCategory.categoryId = '").append(categoryId).append("') ");
        }
        selectStatement.append(" and ((startDay ").append(comparator).append(" '").append(day).append("') or (startDay <= '").append(day).append("' and endDay >= '").append(day).append("')) ");
        if (participation.equals("accepted")) {
            selectStatement.append("union ").append(SELECT_DISTINCT).append(JOURNALCOLUMNNAMES).append(" from CalendarJournal ");
            if (categoryId != null) {
                selectStatement.append(", CalendarJournalCategory ");
            }
            selectStatement.append(" where (delegatorId = '").append(userId).append("') ");
            if (categoryId != null) {
                selectStatement.append(" and (CalendarJournal.id = CalendarJournalCategory.journalId) ");
                selectStatement.append(" and (CalendarJournalCategory.categoryId = '").append(categoryId).append("') ");
            }
            selectStatement.append(" and ((startDay ").append(comparator).append(" '").append(day).append("') or (startDay <= '").append(day).append("' and endDay >= '").append(day).append("')) ");
        }
        selectStatement.append(" order by 7 , 8 ");
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<JournalHeader> list = null;
        try {
            prepStmt = con.prepareStatement(selectStatement.toString());
            rs = prepStmt.executeQuery();
            list = new ArrayList<JournalHeader>();
            while (rs.next()) {
                JournalHeader journal = this.getJournalHeaderFromResultSet(rs);
                list.add(journal);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return list;
    }

    public Collection<JournalHeader> getDayJournalHeadersForUser(Connection con, String day, String userId, String categoryId, String participation) throws SQLException, ParseException {
        return this.getJournalHeadersForUser(con, day, userId, categoryId, participation, "=");
    }

    public Collection<JournalHeader> getNextJournalHeadersForUser(Connection con, String day, String userId, String categoryId, String participation) throws SQLException, ParseException {
        return this.getJournalHeadersForUser(con, day, userId, categoryId, participation, ">=");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JournalHeader> getNextEventsForUser(Connection con, String day, String userId, String classification, Date begin, Date end) throws SQLException, ParseException {
        Object selectNextEvents = "select distinct CalendarJournal.id, CalendarJournal.name, CalendarJournal.delegatorId, CalendarJournal.description, CalendarJournal.priority,  CalendarJournal.classification, CalendarJournal.startDay, CalendarJournal.startHour, CalendarJournal.endDay, CalendarJournal.endHour, CalendarJournal.externalId from CalendarJournal  where  delegatorId = ? and endDay >= ? ";
        int classificationIndex = 2;
        int limitIndex = 3;
        if (StringUtil.isDefined((String)classification)) {
            selectNextEvents = (String)selectNextEvents + " and classification = ? ";
            ++classificationIndex;
            ++limitIndex;
        }
        selectNextEvents = (String)selectNextEvents + " and CalendarJournal.startDay >= ? and CalendarJournal.startDay <= ?";
        selectNextEvents = (String)selectNextEvents + " order by CalendarJournal.startDay, CalendarJournal.startHour ";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<JournalHeader> list = null;
        try {
            prepStmt = con.prepareStatement((String)selectNextEvents);
            prepStmt.setString(1, userId);
            prepStmt.setString(2, day);
            if (classificationIndex == 3) {
                prepStmt.setString(classificationIndex, classification);
            }
            prepStmt.setString(limitIndex, DateUtil.date2SQLDate((Date)begin));
            prepStmt.setString(limitIndex + 1, DateUtil.date2SQLDate((Date)end));
            rs = prepStmt.executeQuery();
            list = new ArrayList<JournalHeader>();
            while (rs.next()) {
                JournalHeader journal = this.getJournalHeaderFromResultSet(rs);
                list.add(journal);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return list;
    }

    public Collection<SchedulableCount> countMonthJournalsForUser(Connection con, String month, String userId, String categoryId, String participation) throws SQLException {
        StringBuilder selectStatement = new StringBuilder(200);
        Object theDay = "";
        selectStatement.append("select count(distinct CalendarJournal.id), ? from CalendarJournal, CalendarJournalAttendee ");
        if (categoryId != null) {
            selectStatement.append(", CalendarJournalCategory ");
        }
        selectStatement.append("where (CalendarJournal.id = CalendarJournalAttendee.journalId) ");
        selectStatement.append("and (userId = ").append(userId);
        selectStatement.append(" and participationStatus = '").append(participation).append("')");
        selectStatement.append(" and ((startDay = ?) or ((startDay <= ?) and (endDay >= ?))) ");
        if (categoryId != null) {
            selectStatement.append(" and (CalendarJournal.id = CalendarJournalCategory.journalId)");
            selectStatement.append(" and (CalendarJournalCategory.categoryId = '").append(categoryId).append("') ");
        }
        selectStatement.append("group by ?");
        if (participation.equals("accepted")) {
            selectStatement.append("union select count(distinct CalendarJournal.id), ? from CalendarJournal ");
            if (categoryId != null) {
                selectStatement.append(", CalendarJournalCategory ");
            }
            selectStatement.append("where (delegatorId = '").append(userId).append("')");
            selectStatement.append(" and ((startDay = ?) or ((startDay <= ?) and (endDay >= ?)))");
            if (categoryId != null) {
                selectStatement.append(" and (CalendarJournal.id = CalendarJournalCategory.journalId)");
                selectStatement.append(" and (CalendarJournalCategory.categoryId = '").append(categoryId).append("') ");
            }
            selectStatement.append("group by ?");
        }
        ArrayList<SchedulableCount> list = new ArrayList<SchedulableCount>();
        String date = "";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement.toString());){
            for (int day = 1; day == 31; ++day) {
                theDay = day < 10 ? month + "0" + day : month + String.valueOf(day);
                prepStmt.setString(1, (String)theDay);
                prepStmt.setString(2, (String)theDay);
                prepStmt.setString(3, (String)theDay);
                prepStmt.setString(4, (String)theDay);
                prepStmt.setString(5, (String)theDay);
                prepStmt.setString(6, (String)theDay);
                prepStmt.setString(7, (String)theDay);
                prepStmt.setString(8, (String)theDay);
                prepStmt.setString(9, (String)theDay);
                prepStmt.setString(10, (String)theDay);
                try (ResultSet rs = prepStmt.executeQuery();){
                    while (rs.next()) {
                        int number = rs.getInt(1);
                        date = rs.getString(2);
                        SchedulableCount count = new SchedulableCount(number, date);
                        list.add(count);
                    }
                    continue;
                }
            }
        }
        return list;
    }

    public Collection<JournalHeader> getPeriodJournalHeadersForUser(Connection con, String begin, String end, String userId, String categoryId, String participation) throws SQLException, ParseException {
        StringBuilder selectStatement = new StringBuilder(200);
        selectStatement.append(SELECT_DISTINCT).append(COLUMNNAMES).append(" from CalendarJournal, CalendarJournalAttendee ");
        if (categoryId != null) {
            selectStatement.append(", CalendarJournalCategory ");
        }
        selectStatement.append(" where (CalendarJournal.id = CalendarJournalAttendee.journalId) ");
        selectStatement.append(" and (userId = '").append(userId).append("' ");
        selectStatement.append(" and participationStatus = '").append(participation).append("') ");
        if (categoryId != null) {
            selectStatement.append(" and (CalendarJournal.id = CalendarJournalCategory.journalId) ");
            selectStatement.append(" and (categoryId = '").append(categoryId).append("') ");
        }
        selectStatement.append(" and ( (startDay >= '").append(begin).append("' and startDay <= '").append(end).append("')");
        selectStatement.append(" or (endDay >= '").append(begin).append("' and endDay <= '").append(end).append("')");
        selectStatement.append(" or ('").append(begin).append("' >= startDay and '").append(begin).append("' <= endDay) ");
        selectStatement.append(" or ('").append(end).append("' >= startDay and '").append(end).append("' <= endDay) ) ");
        if (participation.equals("accepted")) {
            selectStatement.append(" union select distinct ").append(COLUMNNAMES).append(" from CalendarJournal ");
            if (categoryId != null) {
                selectStatement.append(", CalendarJournalCategory ");
            }
            selectStatement.append("where (delegatorId = '").append(userId).append("') ");
            if (categoryId != null) {
                selectStatement.append(" and (CalendarJournal.id = CalendarJournalCategory.journalId) ");
                selectStatement.append(" and (categoryId = '").append(categoryId).append("') ");
            }
            selectStatement.append(" and ( (startDay >= '").append(begin).append("' and startDay <= '").append(end).append("')");
            selectStatement.append(" or (endDay >= '").append(begin).append("' and endDay <= '").append(end).append("')");
            selectStatement.append(" or ('").append(begin).append("' >= startDay and '").append(begin).append("' <= endDay) ");
            selectStatement.append(" or ('").append(end).append("' >= startDay and '").append(end).append("' <= endDay) ) ");
        }
        selectStatement.append(" order by 7 , 8 ");
        ArrayList<JournalHeader> list = new ArrayList<JournalHeader>();
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement.toString());
             ResultSet rs = prepStmt.executeQuery();){
            while (rs.next()) {
                JournalHeader journal = this.getJournalHeaderFromResultSet(rs);
                list.add(journal);
            }
        }
        return list;
    }

    public JournalHeader getJournalHeaderFromResultSet(ResultSet rs) throws SQLException, ParseException {
        String id = String.valueOf(rs.getInt(1));
        String name = rs.getString(2);
        String delegatorId = rs.getString(3);
        JournalHeader journal = new JournalHeader(id, name, delegatorId);
        journal.setDescription(rs.getString(4));
        try {
            journal.getPriority().setValue(rs.getInt(5));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        journal.getClassification().setString(rs.getString(6));
        journal.setStartDay(rs.getString(7));
        journal.setStartHour(rs.getString(8));
        journal.setEndDay(rs.getString(9));
        journal.setEndHour(rs.getString(10));
        journal.setExternalId(rs.getString(11));
        return journal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JournalHeader getJournalHeader(Connection con, String journalId) throws SQLException, CalendarException, ParseException {
        JournalHeader journalHeader;
        String selectStatement = "select id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, externalId from CalendarJournal where id = ?";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setInt(1, Integer.parseInt(journalId));
            rs = prepStmt.executeQuery();
            if (!rs.next()) {
                throw new CalendarException("JournalDAO.Connection con, String journalId", 4, "calendar.EX_RS_EMPTY", "journalId=" + journalId);
            }
            JournalHeader journal = this.getJournalHeaderFromResultSet(rs);
            journalHeader = journal;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return journalHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<JournalHeader> getOutlookJournalHeadersForUser(Connection con, String userId) throws SQLException, ParseException {
        ArrayList<JournalHeader> arrayList;
        String selectStatement = "select id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, externalId from CalendarJournal where delegatorId = ? and externalId is not null";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setString(1, userId);
            rs = prepStmt.executeQuery();
            ArrayList<JournalHeader> list = new ArrayList<JournalHeader>();
            while (rs.next()) {
                JournalHeader journal = this.getJournalHeaderFromResultSet(rs);
                list.add(journal);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<JournalHeader> getOutlookJournalHeadersForUserAfterDate(Connection con, String userId, Date startDate) throws SQLException, ParseException {
        ArrayList<JournalHeader> arrayList;
        String selectStatement = "select id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, externalId from CalendarJournal where delegatorId = ? and startDay >= ? and externalId is not null";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<JournalHeader> list = null;
        try {
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setString(1, userId);
            prepStmt.setString(2, DateUtil.date2SQLDate((Date)startDate));
            rs = prepStmt.executeQuery();
            list = new ArrayList<JournalHeader>();
            while (rs.next()) {
                JournalHeader journal = this.getJournalHeaderFromResultSet(rs);
                list.add(journal);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<JournalHeader> getJournalHeadersForUserAfterDate(Connection con, String userId, Date startDate, int nbReturned) throws SQLException, ParseException {
        ArrayList<JournalHeader> arrayList;
        String selectStatement = "select id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, externalId from CalendarJournal where delegatorId = ? and ((startDay >= ?) or (startDay <= ? and endDay >= ?)) order by startDay, startHour";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String startDateString = DateUtil.date2SQLDate((Date)startDate);
        try {
            prepStmt = con.prepareStatement(selectStatement);
            prepStmt.setString(1, userId);
            prepStmt.setString(2, startDateString);
            prepStmt.setString(3, startDateString);
            prepStmt.setString(4, startDateString);
            rs = prepStmt.executeQuery();
            ArrayList<JournalHeader> list = new ArrayList<JournalHeader>();
            for (int count = 0; rs.next() && nbReturned != count; ++count) {
                JournalHeader journal = this.getJournalHeaderFromResultSet(rs);
                list.add(journal);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocialInformationEvent> getNextEventsForMyContacts(Connection con, String day, String myId, List<String> myContactsIds, Date begin, Date end) throws SQLException, ParseException {
        ArrayList<SocialInformationEvent> arrayList;
        String selectNextEvents = "select distinct CalendarJournal.id, CalendarJournal.name, CalendarJournal.delegatorId, CalendarJournal.description, CalendarJournal.priority,  CalendarJournal.classification, CalendarJournal.startDay, CalendarJournal.startHour, CalendarJournal.endDay, CalendarJournal.endHour, CalendarJournal.externalId from CalendarJournal  where endDay >= ? and delegatorId in(" + JournalDAO.toSqlString(myContactsIds) + ")  and startDay >= ? and startDay <= ?  order by startDay ASC, startHour ASC";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(selectNextEvents);
            prepStmt.setString(1, day);
            prepStmt.setString(2, DateUtil.date2SQLDate((Date)begin));
            prepStmt.setString(3, DateUtil.date2SQLDate((Date)end));
            rs = prepStmt.executeQuery();
            ArrayList<SocialInformationEvent> list = new ArrayList<SocialInformationEvent>();
            while (rs.next()) {
                JournalHeader journal = this.getJournalHeaderFromResultSet(rs);
                list.add(new SocialInformationEvent(journal, journal.getId().equals(myId)));
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return arrayList;
    }

    private static String toSqlString(List<String> list) {
        StringBuilder result = new StringBuilder(100);
        if (list == null || list.isEmpty()) {
            return "''";
        }
        int i = 0;
        for (String var : list) {
            if (i != 0) {
                result.append(",");
            }
            result.append("'").append(var).append("'");
            ++i;
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocialInformationEvent> getLastEventsForMyContacts(Connection con, String day, String myId, List<String> myContactsIds, Date begin, Date end) throws SQLException, ParseException {
        String selectNextEvents = "select distinct CalendarJournal.id, CalendarJournal.name, CalendarJournal.delegatorId, CalendarJournal.description, CalendarJournal.priority,  CalendarJournal.classification, CalendarJournal.startDay, CalendarJournal.startHour, CalendarJournal.endDay, CalendarJournal.endHour, CalendarJournal.externalId from CalendarJournal  where endDay < ? and delegatorId in(" + JournalDAO.toSqlString(myContactsIds) + ")  and startDay >= ? and startDay <= ?  order by startDay desc, startHour desc";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<SocialInformationEvent> list = null;
        try {
            prepStmt = con.prepareStatement(selectNextEvents);
            prepStmt.setString(1, day);
            prepStmt.setString(2, DateUtil.date2SQLDate((Date)begin));
            prepStmt.setString(3, DateUtil.date2SQLDate((Date)end));
            rs = prepStmt.executeQuery();
            list = new ArrayList<SocialInformationEvent>();
            while (rs.next()) {
                JournalHeader journal = this.getJournalHeaderFromResultSet(rs);
                list.add(new SocialInformationEvent(journal, journal.getId().equals(myId)));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocialInformationEvent> getMyLastEvents(Connection con, String day, String myId, Date begin, Date end) throws SQLException, ParseException {
        String selectNextEvents = "select distinct CalendarJournal.id, CalendarJournal.name, CalendarJournal.delegatorId, CalendarJournal.description, CalendarJournal.priority,  CalendarJournal.classification, CalendarJournal.startDay, CalendarJournal.startHour, CalendarJournal.endDay, CalendarJournal.endHour, CalendarJournal.externalId from CalendarJournal  where endDay < ? and delegatorId = ?  and startDay >= ? and startDay <= ?  order by startDay desc, startHour desc ";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<SocialInformationEvent> list = null;
        try {
            prepStmt = con.prepareStatement(selectNextEvents);
            prepStmt.setString(1, day);
            prepStmt.setString(2, myId);
            prepStmt.setString(3, DateUtil.date2SQLDate((Date)begin));
            prepStmt.setString(4, DateUtil.date2SQLDate((Date)end));
            rs = prepStmt.executeQuery();
            list = new ArrayList<SocialInformationEvent>();
            while (rs.next()) {
                JournalHeader journal = this.getJournalHeaderFromResultSet(rs);
                list.add(new SocialInformationEvent(journal));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocialInformationEvent> getMyLastEventsMSS(Connection con, String day, String myId, Date begin, Date end) throws SQLException, ParseException {
        String selectNextEvents = "select distinct CalendarJournal.id, CalendarJournal.name, CalendarJournal.delegatorId, CalendarJournal.description, CalendarJournal.priority,  CalendarJournal.classification, CalendarJournal.startDay, CalendarJournal.startHour, CalendarJournal.endDay, CalendarJournal.endHour, CalendarJournal.externalId from CalendarJournal  where endDay < ? and delegatorId = ?  and startDay >= ? and startDay <= ?  order by CalendarJournal.startDay desc, CalendarJournal.startHour desc";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<SocialInformationEvent> list = null;
        try {
            prepStmt = con.prepareStatement(selectNextEvents);
            prepStmt.setString(1, day);
            prepStmt.setString(2, myId);
            prepStmt.setString(3, DateUtil.date2SQLDate((Date)begin));
            prepStmt.setString(4, DateUtil.date2SQLDate((Date)end));
            rs = prepStmt.executeQuery();
            list = new ArrayList<SocialInformationEvent>();
            while (rs.next()) {
                JournalHeader journal = this.getJournalHeaderFromResultSet(rs);
                list.add(new SocialInformationEvent(journal));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return list;
    }
}

