/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.datawarning.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.silverpeas.components.datawarning.DataWarningException;
import org.silverpeas.components.datawarning.model.DataWarningQuery;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.exception.SilverpeasException;
import org.silverpeas.core.exception.WithNested;
import org.silverpeas.core.util.logging.SilverLogger;

public class DataWarningQueryResult {
    protected DataWarningQuery queryParent = null;
    protected ArrayList<String> columns = null;
    protected List values = null;
    protected boolean hasError = false;
    protected Exception errEx = null;
    protected String errQuery = "";
    protected String errLowestLevel = "";
    protected String errFullText = "";
    protected HashMap valuesByUser = null;
    protected int persoColumnNumber = 0;
    protected String persoUID = "";

    public DataWarningQueryResult(DataWarningQuery qp, boolean pe, int colNum, String puid) {
        this.queryParent = qp;
        this.columns = new ArrayList();
        this.values = new ArrayList();
        this.hasError = false;
        this.valuesByUser = pe ? new HashMap() : null;
        this.persoColumnNumber = colNum - 1;
        this.persoUID = puid;
    }

    public DataWarningQuery getParent() {
        return this.queryParent;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public String getErrorFullText() {
        return this.errFullText;
    }

    public Exception getErrorException() {
        return this.errEx;
    }

    public void addError(Exception ex, String sqlQuery) {
        StringBuilder sb = new StringBuilder();
        this.hasError = true;
        this.errEx = ex;
        this.errQuery = sqlQuery;
        ArrayList<String> dummyRow = new ArrayList<String>();
        this.columns.clear();
        this.values.clear();
        this.addColumn("!!! ERROR !!! (QUERY)");
        dummyRow.add(sqlQuery);
        sb.append("!!! ERROR !!!\nQUERY :\n").append(sqlQuery);
        this.addColumn("!!! ERROR !!! (HIGH LVL MSG)");
        sb.append("\nMSG HAUT NIVEAU :\n");
        if (ex instanceof SilverpeasException) {
            boolean notTheSame = false;
            this.errLowestLevel = ((SilverpeasException)ex).getMessageLang();
            dummyRow.add(this.errLowestLevel);
            sb.append(this.errLowestLevel);
            Throwable nested = ex;
            while (nested instanceof WithNested && ((WithNested)nested).getNested() != null) {
                nested = ((WithNested)nested).getNested();
                notTheSame = true;
            }
            if (notTheSame) {
                this.addColumn("!!! ERROR !!! (MSG BAS NIVEAU)");
                this.errLowestLevel = nested instanceof SilverpeasException ? ((SilverpeasException)nested).getMessageLang() : nested.getMessage();
                dummyRow.add(this.errLowestLevel);
                sb.append("\nMSG BAS NIVEAU :\n").append(this.errLowestLevel);
            }
        } else {
            this.errLowestLevel = ex.getMessage();
            dummyRow.add(this.errLowestLevel);
            sb.append(this.errLowestLevel);
        }
        this.addRow(dummyRow);
        this.errFullText = sb.toString();
    }

    public void addColumn(String columnName) {
        this.columns.add(columnName);
    }

    public List getColumns() {
        return this.columns;
    }

    public List getValues() {
        return this.values;
    }

    public long returnTriggerValueFromResult() throws DataWarningException {
        try {
            if (this.isPersoEnabled()) {
                long maxVal = 0L;
                int theCol = this.persoColumnNumber > 0 || this.getNbColumns() <= 1 ? 0 : 1;
                for (int i = 0; i < this.getNbRows(); ++i) {
                    long theVal = Long.parseLong(this.getValue(i, theCol));
                    if (i != 0 && !this.queryParent.checkTriggerSatisfied(theVal)) continue;
                    maxVal = theVal;
                }
                return maxVal;
            }
            return Long.parseLong(this.getValue(0, 0));
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningQueryResult.returnTriggerValueFromResult()", 4, "DataWarning.EX_DATA_ACCESS_FAILED", e);
        }
    }

    public void addRow(List row) {
        this.values.add(row);
        if (this.isPersoEnabled()) {
            String userPersoValue = (String)row.get(this.persoColumnNumber);
            ArrayList allUserRows = this.getValues(userPersoValue);
            ArrayList clonedOne = new ArrayList(row);
            if (allUserRows == null) {
                allUserRows = new ArrayList();
            }
            clonedOne.remove(this.persoColumnNumber);
            allUserRows.add(clonedOne);
            this.valuesByUser.put(userPersoValue, allUserRows);
        }
    }

    protected ArrayList getRow(int row) {
        if (this.values.size() > row) {
            return (ArrayList)this.values.get(row);
        }
        return new ArrayList();
    }

    public String getValue(int row, int col) {
        ArrayList al = this.getRow(row);
        if (al.size() > col) {
            return (String)al.get(col);
        }
        return "";
    }

    public int getNbColumns() {
        return this.columns.size();
    }

    public int getNbRows() {
        return this.values.size();
    }

    public boolean isPersoEnabled() {
        return this.valuesByUser != null;
    }

    public long returnTriggerValueFromResult(String userId) throws DataWarningException {
        try {
            if (this.isPersoEnabled()) {
                return Long.parseLong(this.getValue(userId, 0, 0));
            }
            return Long.parseLong(this.getValue(0, 0));
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningQueryResult.returnTriggerValueFromResult()", 4, "DataWarning.EX_DATA_ACCESS_FAILED", "UserId = " + userId, e);
        }
    }

    public List getValues(String userId) {
        if (this.isPersoEnabled()) {
            String userPersoValue = this.returnPersoValue(userId);
            ArrayList<List> valret = new ArrayList<List>();
            for (int i = 0; i < this.values.size(); ++i) {
                List valeur = (List)this.getValues().get(i);
                if (valeur.size() <= 1 || !valeur.get(this.persoColumnNumber).equals(userPersoValue)) continue;
                valret.add(valeur);
            }
            return valret;
        }
        return this.getValues();
    }

    protected ArrayList getRow(String userId, int row) {
        if (this.isPersoEnabled()) {
            List al = this.getValues(userId);
            if (al.size() > row) {
                return (ArrayList)al.get(row);
            }
            return new ArrayList();
        }
        if (this.values.size() > row) {
            return (ArrayList)this.values.get(row);
        }
        return new ArrayList();
    }

    public String getValue(String userId, int row, int col) {
        ArrayList al = this.getRow(userId, row);
        if (al.size() > col) {
            return (String)al.get(col);
        }
        return "";
    }

    public List getPersoColumns() {
        if (this.isPersoEnabled()) {
            ArrayList clo = (ArrayList)this.columns.clone();
            if (clo.size() > this.persoColumnNumber) {
                clo.remove(this.persoColumnNumber);
            }
            return clo;
        }
        return this.columns;
    }

    public int getPersoNbColumns() {
        if (this.isPersoEnabled()) {
            return this.columns.size() - 1;
        }
        return this.columns.size();
    }

    public int getNbRows(String userId) {
        List allUserRows = this.getValues(userId);
        if (allUserRows != null) {
            return allUserRows.size();
        }
        return 0;
    }

    public int getPersoColumnNumber() {
        return this.persoColumnNumber;
    }

    public String returnPersoValue(String userId) {
        try {
            OrganizationController oc = OrganizationControllerProvider.getOrganisationController();
            UserDetail ud = (UserDetail)oc.getUserDetail(userId);
            if (ud == null) {
                return "";
            }
            if ("QUERY_PERSO_UID_ID".equals(this.persoUID)) {
                return ud.getId();
            }
            if ("QUERY_PERSO_UID_LOGIN".equals(this.persoUID)) {
                return ud.getLogin();
            }
            if ("QUERY_PERSO_UID_LASTNAME".equals(this.persoUID)) {
                return ud.getLastName();
            }
            if ("QUERY_PERSO_UID_SPECIFICID".equals(this.persoUID)) {
                return ud.getSpecificId();
            }
            if ("QUERY_PERSO_UID_EMAIL".equals(this.persoUID)) {
                return ud.geteMail();
            }
            UserFull uf = oc.getUserFull(userId);
            return uf.getValue(this.persoUID, "");
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            return "";
        }
    }
}

