/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.process.media;

import java.util.List;
import org.silverpeas.components.gallery.GalleryComponentSettings;
import org.silverpeas.components.gallery.delegate.MediaDataCreateDelegate;
import org.silverpeas.components.gallery.model.AlbumMedia;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.notification.AlbumMediaEventNotifier;
import org.silverpeas.components.gallery.process.AbstractGalleryDataProcess;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.pdc.pdc.model.PdcClassification;
import org.silverpeas.core.pdc.pdc.model.PdcPosition;
import org.silverpeas.core.process.management.ProcessExecutionContext;
import org.silverpeas.core.process.session.ProcessSession;
import org.silverpeas.core.util.CollectionUtil;

public class GalleryCreateMediaDataProcess
extends AbstractGalleryDataProcess {
    private final String albumId;
    private final MediaDataCreateDelegate delegate;

    protected GalleryCreateMediaDataProcess(Media media, String albumId, MediaDataCreateDelegate delegate) {
        super(media);
        this.delegate = delegate;
        this.albumId = albumId;
    }

    public static GalleryCreateMediaDataProcess getInstance(Media media, String albumId, MediaDataCreateDelegate delegate) {
        return new GalleryCreateMediaDataProcess(media, albumId, delegate);
    }

    @Override
    protected void processData(ProcessExecutionContext context, ProcessSession session) throws Exception {
        if (this.delegate.isHeaderData()) {
            this.delegate.updateHeader(this.getMedia());
        }
        this.createMedia(this.albumId, context);
        if (this.delegate.isForm()) {
            String mediaId = this.getMedia().getId();
            PagesContext pageContext = new PagesContext("mediaForm", "0", this.delegate.getLanguage(), false, context.getComponentInstanceId(), context.getUser().getId(), this.albumId);
            pageContext.setEncoding("UTF-8");
            pageContext.setObjectId(mediaId);
            this.delegate.updateForm(mediaId, pageContext);
        }
        if (GalleryComponentSettings.isPdcEnabled(this.getMedia().getComponentInstanceId())) {
            int silverContentId = this.getGalleryContentManager().createSilverContent((Contribution)this.getMedia(), context.getUser().getId());
            this.getMedia().setSilverpeasContentId(Integer.toString(silverContentId));
            this.classifyMediaContent();
        }
    }

    private void classifyMediaContent() {
        List<PdcPosition> pdcPositions;
        if (this.delegate.isHeaderData() && CollectionUtil.isNotEmpty(pdcPositions = this.delegate.getHeaderData().getPdcPositions())) {
            PdcClassification curClassification = PdcClassification.aPdcClassificationOfContent((Contribution)this.getMedia()).withPositions(pdcPositions);
            curClassification.classifyContent((Contribution)this.getMedia());
        }
    }

    public void onSuccessful() throws Exception {
        super.onSuccessful();
        AlbumMediaEventNotifier notifier = AlbumMediaEventNotifier.get();
        notifier.notifyEventOn(ResourceEvent.Type.CREATION, new AlbumMedia[]{new AlbumMedia(this.albumId, this.getMedia())});
    }
}

