/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.stats;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.silverpeas.components.kmelia.model.StatisticActivityVO;
import org.silverpeas.components.kmelia.model.StatsFilterVO;
import org.silverpeas.components.kmelia.stats.StatisticService;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.publication.dao.PublicationCriteria;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.util.Pair;
import org.silverpeas.core.util.logging.SilverLogger;

@Service
public class StatisticServiceImpl
implements StatisticService {
    private static final String PUBLICATION_TYPE = "Publication";
    @Inject
    private PublicationService publicationService;
    @Inject
    private NodeService nodeService;
    @Inject
    private org.silverpeas.core.silverstatistics.access.service.StatisticService statisticService;

    @Override
    public Integer getNbConsultedPublication(StatsFilterVO statFilter) {
        if (statFilter != null) {
            return this.getNumberOfConsultedPublications(statFilter);
        }
        return -1;
    }

    @Override
    public Integer getNbStatisticActivityByPeriod(StatsFilterVO statFilter) {
        if (statFilter != null) {
            List<PublicationDetail> publis = this.getValidApplicationPublications(statFilter);
            if (!publis.isEmpty()) {
                return (int)this.countGlobalPublicationActivity(statFilter, publis);
            }
            return 0;
        }
        return -1;
    }

    private Integer getNumberOfConsultedPublications(StatsFilterVO statFilter) {
        List<PublicationDetail> publis = this.getValidApplicationPublications(statFilter);
        int nbPubli = 0;
        if (!publis.isEmpty()) {
            Integer groupId = statFilter.getGroupId();
            List<ResourceReference> publiPKs = this.getReferencesToPublications(publis);
            if (groupId != null) {
                List<String> userIds = this.getListUserIdsFromGroup(groupId);
                try {
                    nbPubli = this.getStatisticService().getCountByPeriodAndUser(publiPKs, PUBLICATION_TYPE, statFilter.getStartDate(), statFilter.getEndDate(), userIds);
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).error("Error when counting number of access (getCountByPeriodAndUser)", (Throwable)e);
                }
            } else {
                try {
                    nbPubli = this.getStatisticService().getCountByPeriod(publiPKs, 1, PUBLICATION_TYPE, statFilter.getStartDate(), statFilter.getEndDate());
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).error("Error when counting number of access (getCountByPeriod)", (Throwable)e);
                }
            }
        }
        return nbPubli;
    }

    private List<ResourceReference> getReferencesToPublications(List<PublicationDetail> publis) {
        ArrayList<ResourceReference> publiPKs = new ArrayList<ResourceReference>();
        for (PublicationDetail publi : publis) {
            publiPKs.add(new ResourceReference((WAPrimaryKey)publi.getPK()));
        }
        return publiPKs;
    }

    private List<String> getListUserIdsFromGroup(Integer groupId) {
        ArrayList<String> userIds = new ArrayList<String>();
        try {
            GroupDetail selectedGroup = AdministrationServiceProvider.getAdminService().getGroup(Integer.toString(groupId));
            String[] arrayUserIds = selectedGroup.getUserIds();
            Collections.addAll(userIds, arrayUserIds);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error("Error when loading the list of filtered users", (Throwable)e);
        }
        return userIds;
    }

    private List<PublicationDetail> getValidApplicationPublications(StatsFilterVO statFilter) {
        NodePK fatherPK = new NodePK(Integer.toString(statFilter.getTopicId()), statFilter.getInstanceId());
        return this.getPublicationService().getPublicationsByCriteria(PublicationCriteria.onComponentInstanceIds((String[])new String[]{statFilter.getInstanceId()}).onNodes((Collection)this.getNodeService().getSubTree(fatherPK).stream().map(NodeDetail::getId).collect(Collectors.toSet())).ofStatus(new String[]{"Valid"}).visibleAt(OffsetDateTime.now()));
    }

    private long countPublicationActivity(StatsFilterVO statFilter, Collection<PublicationDetail> publis, boolean isCreate, boolean isUpdate) {
        List<String> userIds;
        Date startTime = statFilter.getStartDate();
        Date endTime = statFilter.getEndDate();
        Integer groupId = statFilter.getGroupId();
        long nbPubli = groupId != null ? (!(userIds = this.getListUserIdsFromGroup(groupId)).isEmpty() ? publis.stream().filter(p -> this.isPubliActivityInsideTimeInterval(startTime, endTime, (PublicationDetail)p, isCreate, isUpdate)).flatMap(p -> userIds.stream().map(u -> Pair.of((Object)p, (Object)u))).filter(pu -> this.isUserRelatedWithPubli((PublicationDetail)pu.getFirst(), (String)pu.getSecond())).count() : 0L) : publis.stream().filter(p -> this.isPubliActivityInsideTimeInterval(startTime, endTime, (PublicationDetail)p, isCreate, isUpdate)).count();
        return nbPubli;
    }

    private boolean isUserRelatedWithPubli(PublicationDetail publi, String userId) {
        return userId.equals(publi.getCreatorId()) || userId.equals(publi.getUpdaterId()) || userId.equals(publi.getValidatorId());
    }

    private boolean isPubliActivityInsideTimeInterval(Date startTime, Date endTime, PublicationDetail publi, boolean isCreate, boolean isUpdate) {
        Date createDate = publi.getCreationDate();
        Date updateDate = publi.getLastUpdateDate();
        return isCreate && (createDate.after(startTime) || createDate.equals(startTime)) && createDate.before(endTime) || isUpdate && (updateDate.after(startTime) || updateDate.equals(startTime)) && updateDate.before(endTime);
    }

    private PublicationService getPublicationService() {
        return this.publicationService;
    }

    private NodeService getNodeService() {
        return this.nodeService;
    }

    private org.silverpeas.core.silverstatistics.access.service.StatisticService getStatisticService() {
        return this.statisticService;
    }

    @Override
    public StatisticActivityVO getStatisticActivity(StatsFilterVO statFilter) {
        List<PublicationDetail> publis = this.getValidApplicationPublications(statFilter);
        long nbCreate = this.countCreatePublicationActivity(statFilter, publis);
        long nbUpdate = this.countUpdatePublicationActivity(statFilter, publis);
        return new StatisticActivityVO((int)nbCreate, (int)nbUpdate);
    }

    private long countCreatePublicationActivity(StatsFilterVO statFilter, List<PublicationDetail> publis) {
        return this.countPublicationActivity(statFilter, publis, true, false);
    }

    private long countUpdatePublicationActivity(StatsFilterVO statFilter, List<PublicationDetail> publis) {
        return this.countPublicationActivity(statFilter, publis, false, true);
    }

    private long countGlobalPublicationActivity(StatsFilterVO statFilter, List<PublicationDetail> publis) {
        return this.countPublicationActivity(statFilter, publis, true, true);
    }

    @Override
    public Integer getNumberOfDifferentConsultedPublications(StatsFilterVO statFilter) {
        List<PublicationDetail> publis;
        if (statFilter != null && !(publis = this.getValidApplicationPublications(statFilter)).isEmpty()) {
            return this.countDistinctConsultedPublications(statFilter, publis);
        }
        return -1;
    }

    private Integer countDistinctConsultedPublications(StatsFilterVO statFilter, List<PublicationDetail> publis) {
        int nbPubli = 0;
        List<ResourceReference> publiPKs = this.getReferencesToPublications(publis);
        if (statFilter.getGroupId() != null) {
            List<String> userIds = this.getListUserIdsFromGroup(statFilter.getGroupId());
            try {
                return this.getStatisticService().getDistinctCountByPeriodUser(publiPKs, 1, PUBLICATION_TYPE, statFilter.getStartDate(), statFilter.getEndDate(), userIds);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Error when computing distinct access to publication", (Throwable)e);
            }
        } else {
            try {
                return this.getStatisticService().getDistinctCountByPeriod(publiPKs, 1, PUBLICATION_TYPE, statFilter.getStartDate(), statFilter.getEndDate());
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Error when computing distinct access to publication", (Throwable)e);
            }
        }
        return nbPubli;
    }
}

