/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.hateoas.referenceable;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import edu.psu.swe.commons.jaxrs.hateoas.referenceable.Referenceable;
import edu.psu.swe.commons.jaxrs.hateoas.referenceable.ReferenceableAtomLink;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReferenceableDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReferenceableDeserializer.class);
    protected Class targetClass;

    public Object deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Referenceable r;
        LOG.info("Deserializing referenceable atom links into referenceable");
        String href = null;
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        try {
            r = (Referenceable)this.targetClass.newInstance();
            ReferenceableAtomLink al = new ReferenceableAtomLink();
            al.setId(node.get("id").asText());
            if (node.get("href") != null) {
                href = node.get("href").asText();
            }
            r.loadReferenceableType(al);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error("Error creating referenceable: " + e.getMessage(), (Throwable)e);
            throw new JsonGenerationException(e.getMessage());
        }
        return this.getRestLookUpProxy(r, ctxt, href, this.targetClass);
    }

    public abstract Object getRestLookUpProxy(Referenceable var1, DeserializationContext var2, String var3, Class var4);
}

