/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.comment.socialnetwork;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.comment.service.CommentServiceProvider;
import org.silverpeas.core.comment.socialnetwork.SocialInformationComment;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.security.authorization.PublicationAccessControl;
import org.silverpeas.core.socialnetwork.model.SocialInformation;
import org.silverpeas.core.socialnetwork.provider.SocialPublicationCommentProvider;
import org.silverpeas.core.util.URLUtil;

@Provider
public class SocialPublicationComment
implements SocialPublicationCommentProvider {
    @Inject
    private PublicationService publicationService;

    private List<String> getListResourceType() {
        ArrayList<String> listResourceType = new ArrayList<String>();
        listResourceType.add(PublicationDetail.getResourceType());
        return listResourceType;
    }

    private PublicationService getService() {
        return this.publicationService;
    }

    private List<SocialInformation> decorate(List<SocialInformationComment> listSocialInformation) {
        for (SocialInformationComment socialInformation : listSocialInformation) {
            String resourceId = socialInformation.getComment().getResourceReference().getLocalId();
            String instanceId = socialInformation.getComment().getComponentInstanceId();
            PublicationPK pubPk = new PublicationPK(resourceId, instanceId);
            PublicationDetail pubDetail = this.getService().getDetail(pubPk);
            socialInformation.setUrl(URLUtil.getSimpleURL((int)2, (String)pubDetail.getId(), (String)pubDetail.getInstanceId(), (boolean)false));
            socialInformation.setTitle(pubDetail.getTitle());
        }
        return listSocialInformation;
    }

    public List<SocialInformation> getSocialInformationList(String userId, Date begin, Date end) {
        List<SocialInformationComment> listSocialInformation = CommentServiceProvider.getCommentService().getSocialInformationCommentsListByUserId(this.getListResourceType(), userId, Period.between((Instant)begin.toInstant(), (Instant)end.toInstant()));
        return this.decorate(listSocialInformation);
    }

    public List<SocialInformation> getSocialInformationListOfMyContacts(String myId, List<String> myContactsIds, Date begin, Date end) {
        OrganizationController oc = OrganizationControllerProvider.getOrganisationController();
        ArrayList<String> instanceIds = new ArrayList<String>();
        instanceIds.addAll(Arrays.asList(oc.getComponentIdsForUser(myId, "kmelia")));
        instanceIds.addAll(Arrays.asList(oc.getComponentIdsForUser(myId, "blog")));
        List<SocialInformationComment> socialComments = CommentServiceProvider.getCommentService().getSocialInformationCommentsListOfMyContacts(this.getListResourceType(), myContactsIds, instanceIds, Period.between((Instant)begin.toInstant(), (Instant)end.toInstant()));
        Iterator<SocialInformationComment> socialCommentIt = socialComments.iterator();
        while (socialCommentIt.hasNext()) {
            SocialInformationComment socialComment = socialCommentIt.next();
            String instanceId = socialComment.getComment().getComponentInstanceId();
            if (myId.equals(socialComment.getAuthor()) || !instanceId.startsWith("kmelia") || PublicationAccessControl.get().isUserAuthorized(myId, (Object)new PublicationPK(socialComment.getComment().getResourceReference().getLocalId(), instanceId))) continue;
            socialCommentIt.remove();
        }
        return this.decorate(socialComments);
    }
}

