/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.scheduleevent.service;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.silverpeas.components.scheduleevent.service.model.beans.DateOption;
import org.silverpeas.components.scheduleevent.service.model.beans.Response;
import org.silverpeas.components.scheduleevent.service.model.beans.ScheduleEvent;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.SettingBundle;

public class CalendarEventEncoder {
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.components.scheduleevent.settings.ScheduleEventSettings");

    private static SettingBundle getSettings() {
        return settings;
    }

    public List<CalendarEvent> encode(ScheduleEvent eventDetail, List<DateOption> listDateOption) {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        Set<Response> listResponse = eventDetail.getResponses();
        if (eventDetail.getStatus() == 0 && !listResponse.isEmpty()) {
            TimeZone timeZone = TimeZone.getTimeZone(CalendarEventEncoder.getSettings().getString("scheduleevent.timezone"));
            for (DateOption eventDateOption : listDateOption) {
                int endTime = 12;
                if (eventDateOption.getHour() == 14) {
                    endTime = 18;
                }
                OffsetDateTime startDateTime = LocalDateTime.ofInstant(eventDateOption.getDay().toInstant(), timeZone.toZoneId()).withHour(eventDateOption.getHour()).withMinute(0).atZone(timeZone.toZoneId()).toOffsetDateTime();
                OffsetDateTime endDateTime = LocalDateTime.ofInstant(eventDateOption.getDay().toInstant(), timeZone.toZoneId()).withHour(endTime).withMinute(0).atZone(timeZone.toZoneId()).toOffsetDateTime();
                CalendarEvent calendarEvent = CalendarEvent.on((Period)Period.between((OffsetDateTime)startDateTime, (OffsetDateTime)endDateTime)).identifiedBy(eventDetail.getComponentInstanceId(), eventDetail.getId()).withTitle(eventDetail.getTitle()).withDescription(eventDetail.getDescription());
                events.add(calendarEvent);
            }
        }
        return events;
    }
}

