/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.jdbcconnector.service;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.silverpeas.components.jdbcconnector.model.DataSourceConnectionInfo;
import org.silverpeas.components.jdbcconnector.service.JdbcConnectorException;
import org.silverpeas.components.jdbcconnector.service.JdbcConnectorRuntimeException;
import org.silverpeas.components.jdbcconnector.service.TableRow;
import org.silverpeas.core.util.StringUtil;

public class JdbcRequester {
    private final String instanceId;
    private final DataSourceConnectionInfo currentConnectionInfo;

    public JdbcRequester(String componentInstanceId) {
        this.instanceId = componentInstanceId;
        List<DataSourceConnectionInfo> availableConnectionInfo = DataSourceConnectionInfo.getFromComponentInstance(this.instanceId);
        if (availableConnectionInfo.isEmpty()) {
            this.currentConnectionInfo = new DataSourceConnectionInfo("", this.instanceId).withSqlRequest("");
        } else {
            if (availableConnectionInfo.size() > 1) {
                throw new JdbcConnectorRuntimeException("There is more than one defined data source for the JDBC connector " + this.instanceId + ": " + availableConnectionInfo.size() + " data sources found!");
            }
            this.currentConnectionInfo = availableConnectionInfo.get(0);
        }
    }

    public DataSourceConnectionInfo getCurrentConnectionInfo() {
        return this.currentConnectionInfo;
    }

    public void checkConnection() throws JdbcConnectorException {
        try (Connection connection = this.currentConnectionInfo.openConnection();){
            if (!connection.isValid(0)) {
                throw new JdbcConnectorException("The connexion with the data source " + this.currentConnectionInfo.getDataSourceName() + " is not valid", new String[0]);
            }
        }
        catch (SQLException e) {
            throw new JdbcConnectorException(e);
        }
    }

    public boolean isDataSourceDefined() {
        return this.currentConnectionInfo.isDefined();
    }

    public boolean isSQLRequestDefined() {
        return StringUtil.isNotDefined((String)this.currentConnectionInfo.getSqlRequest());
    }

    public List<String> getTableNames() {
        ArrayList<String> arrayList;
        block9: {
            ArrayList<String> tableNames = new ArrayList<String>();
            Connection connection = this.currentConnectionInfo.openConnection();
            try {
                DatabaseMetaData dbMetaData = connection.getMetaData();
                ResultSet tables = dbMetaData.getTables(null, null, null, new String[]{"TABLE", "VIEW"});
                while (tables.next()) {
                    tableNames.add(tables.getString("TABLE_NAME"));
                }
                arrayList = tableNames;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException | JdbcConnectorException e) {
                    throw new JdbcConnectorRuntimeException((Throwable)e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    public List<String> getColumnNames(String tableName) {
        ArrayList<String> arrayList;
        block9: {
            ArrayList<String> columnNames = new ArrayList<String>();
            Connection connection = this.currentConnectionInfo.openConnection();
            try {
                DatabaseMetaData dbMetaData = connection.getMetaData();
                ResultSet columns = dbMetaData.getColumns(null, null, tableName, null);
                while (columns.next()) {
                    columnNames.add(columns.getString("COLUMN_NAME"));
                }
                arrayList = columnNames;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException | JdbcConnectorException e) {
                    throw new JdbcConnectorRuntimeException((Throwable)e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    public List<TableRow> request() throws JdbcConnectorException {
        if (this.isSQLRequestDefined()) {
            return Collections.emptyList();
        }
        return this.request(this.currentConnectionInfo.getSqlRequest());
    }

    /*
     * Exception decompiling
     */
    public List<TableRow> request(String sqlQuery) throws JdbcConnectorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

