/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.forums.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.silverpeas.components.forums.model.ForumPK;
import org.silverpeas.core.Identifiable;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.i18n.AbstractBean;

public class ForumDetail
extends AbstractBean
implements LocalizedContribution,
Identifiable,
Serializable {
    private static final long serialVersionUID = -5500661559879178630L;
    private static final String TYPE = "Forum";
    private final ForumPK pk;
    private final Date creationDate;
    private final String creatorId;

    public ForumDetail(ForumPK pk, String name, String description, String creatorId, Date creationDate) {
        this.pk = pk;
        this.setName(name);
        this.setDescription(description);
        this.creatorId = creatorId;
        this.creationDate = creationDate;
    }

    public ForumPK getPK() {
        return this.pk;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getLastUpdateDate() {
        return this.getCreationDate();
    }

    public User getCreator() {
        return User.getById((String)this.getCreatorId());
    }

    public User getLastUpdater() {
        return this.getCreator();
    }

    public String toString() {
        Object result = "ForumDetail {\n";
        result = (String)result + "  getPK().getId() = " + this.getPK().getId() + "\n";
        result = (String)result + "  getPK().getComponent() = " + this.getPK().getComponentName() + "\n";
        result = (String)result + "  getName() = " + this.getName() + "\n";
        result = (String)result + "  getDescription() = " + this.getDescription() + "\n";
        result = (String)result + "  getCreatorId() = " + this.getCreatorId() + "\n";
        result = (String)result + "  getCreationDate() = " + this.getCreationDate() + "\n";
        result = (String)result + "}";
        return result;
    }

    public String getId() {
        return this.getPK().getId();
    }

    public String getInstanceId() {
        return this.getPK().getComponentName();
    }

    public ContributionIdentifier getIdentifier() {
        return ContributionIdentifier.from((String)this.getInstanceId(), (String)this.getId(), (String)this.getContributionType());
    }

    public String getTitle() {
        return this.getName();
    }

    public String getContributionType() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForumDetail that = (ForumDetail)o;
        return Objects.equals((Object)this.pk, (Object)that.pk) && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.creatorId, that.creatorId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pk, this.creationDate, this.creatorId});
    }
}

