/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.config.ImportConfig;
import org.apache.jackrabbit.core.config.PersistenceManagerConfig;
import org.apache.jackrabbit.core.config.WorkspaceSecurityConfig;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemFactory;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.QueryHandlerFactory;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ISMLockingFactory;

public class WorkspaceConfig
implements FileSystemFactory,
ISMLockingFactory,
QueryHandlerFactory {
    private final String home;
    private final String name;
    private final boolean clustered;
    private FileSystemFactory fsf;
    private PersistenceManagerConfig pmc;
    private QueryHandlerFactory qhf;
    private ISMLockingFactory ismLockingFactory;
    private final WorkspaceSecurityConfig workspaceSecurityConfig;
    private final ImportConfig importConfig;
    private final long defaultLockTimeout;

    public WorkspaceConfig(String home, String name, boolean clustered, FileSystemFactory fsf, PersistenceManagerConfig pmc, QueryHandlerFactory qhf, ISMLockingFactory ismLockingFactory, WorkspaceSecurityConfig workspaceSecurityConfig) {
        this(home, name, clustered, fsf, pmc, qhf, ismLockingFactory, workspaceSecurityConfig, null, Long.MAX_VALUE);
    }

    public WorkspaceConfig(String home, String name, boolean clustered, FileSystemFactory fsf, PersistenceManagerConfig pmc, QueryHandlerFactory qhf, ISMLockingFactory ismLockingFactory, WorkspaceSecurityConfig workspaceSecurityConfig, ImportConfig importConfig) {
        this(home, name, clustered, fsf, pmc, qhf, ismLockingFactory, workspaceSecurityConfig, importConfig, Long.MAX_VALUE);
    }

    public WorkspaceConfig(String home, String name, boolean clustered, FileSystemFactory fsf, PersistenceManagerConfig pmc, QueryHandlerFactory qhf, ISMLockingFactory ismLockingFactory, WorkspaceSecurityConfig workspaceSecurityConfig, ImportConfig importConfig, long defaultLockTimeout) {
        this.home = home;
        this.name = name;
        this.clustered = clustered;
        this.fsf = fsf;
        this.pmc = pmc;
        this.qhf = qhf;
        this.ismLockingFactory = ismLockingFactory;
        this.workspaceSecurityConfig = workspaceSecurityConfig;
        this.importConfig = importConfig;
        this.defaultLockTimeout = defaultLockTimeout;
    }

    public String getHomeDir() {
        return this.home;
    }

    public String getName() {
        return this.name;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public long getDefaultLockTimeout() {
        return this.defaultLockTimeout;
    }

    @Override
    public ISMLocking getISMLocking() throws RepositoryException {
        return this.ismLockingFactory.getISMLocking();
    }

    public FileSystem getFileSystem() throws RepositoryException {
        return this.fsf.getFileSystem();
    }

    public PersistenceManagerConfig getPersistenceManagerConfig() {
        return this.pmc;
    }

    public boolean isSearchEnabled() {
        return this.qhf != null;
    }

    @Override
    public QueryHandler getQueryHandler(QueryHandlerContext context) throws RepositoryException {
        if (this.qhf != null) {
            return this.qhf.getQueryHandler(context);
        }
        return null;
    }

    public WorkspaceSecurityConfig getSecurityConfig() {
        return this.workspaceSecurityConfig;
    }

    public ImportConfig getImportConfig() {
        return this.importConfig;
    }
}

