/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.directory;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.directory.DirectoryRequest;
import com.google.api.services.directory.DirectoryRequestInitializer;
import com.google.api.services.directory.model.Alias;
import com.google.api.services.directory.model.Aliases;
import com.google.api.services.directory.model.Asp;
import com.google.api.services.directory.model.BatchCreatePrintersRequest;
import com.google.api.services.directory.model.BatchCreatePrintersResponse;
import com.google.api.services.directory.model.BatchDeletePrintersRequest;
import com.google.api.services.directory.model.BatchDeletePrintersResponse;
import com.google.api.services.directory.model.Building;
import com.google.api.services.directory.model.Buildings;
import com.google.api.services.directory.model.CalendarResource;
import com.google.api.services.directory.model.CalendarResources;
import com.google.api.services.directory.model.Channel;
import com.google.api.services.directory.model.ChromeOsDevice;
import com.google.api.services.directory.model.ChromeOsDeviceAction;
import com.google.api.services.directory.model.ChromeOsDevices;
import com.google.api.services.directory.model.ChromeOsMoveDevicesToOu;
import com.google.api.services.directory.model.DirectoryChromeosdevicesCommand;
import com.google.api.services.directory.model.DirectoryChromeosdevicesIssueCommandRequest;
import com.google.api.services.directory.model.DirectoryChromeosdevicesIssueCommandResponse;
import com.google.api.services.directory.model.DomainAlias;
import com.google.api.services.directory.model.Domains2;
import com.google.api.services.directory.model.Empty;
import com.google.api.services.directory.model.Feature;
import com.google.api.services.directory.model.FeatureRename;
import com.google.api.services.directory.model.Features;
import com.google.api.services.directory.model.Group;
import com.google.api.services.directory.model.ListPrinterModelsResponse;
import com.google.api.services.directory.model.ListPrintersResponse;
import com.google.api.services.directory.model.Member;
import com.google.api.services.directory.model.MembersHasMember;
import com.google.api.services.directory.model.MobileDevice;
import com.google.api.services.directory.model.MobileDeviceAction;
import com.google.api.services.directory.model.MobileDevices;
import com.google.api.services.directory.model.OrgUnit;
import com.google.api.services.directory.model.OrgUnits;
import com.google.api.services.directory.model.Printer;
import com.google.api.services.directory.model.Role;
import com.google.api.services.directory.model.RoleAssignment;
import com.google.api.services.directory.model.Schema;
import com.google.api.services.directory.model.Token;
import com.google.api.services.directory.model.User;
import com.google.api.services.directory.model.UserMakeAdmin;
import com.google.api.services.directory.model.UserPhoto;
import com.google.api.services.directory.model.UserUndelete;
import java.io.IOException;
import java.util.regex.Pattern;

public class Directory
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://admin.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://admin.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://admin.googleapis.com/";

    public Directory(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Directory(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Asps asps() {
        return new Asps();
    }

    public Channels channels() {
        return new Channels();
    }

    public Chromeosdevices chromeosdevices() {
        return new Chromeosdevices();
    }

    public Customer customer() {
        return new Customer();
    }

    public Customers customers() {
        return new Customers();
    }

    public DomainAliases domainAliases() {
        return new DomainAliases();
    }

    public Domains domains() {
        return new Domains();
    }

    public Groups groups() {
        return new Groups();
    }

    public Members members() {
        return new Members();
    }

    public Mobiledevices mobiledevices() {
        return new Mobiledevices();
    }

    public Orgunits orgunits() {
        return new Orgunits();
    }

    public Privileges privileges() {
        return new Privileges();
    }

    public Resources resources() {
        return new Resources();
    }

    public RoleAssignments roleAssignments() {
        return new RoleAssignments();
    }

    public Roles roles() {
        return new Roles();
    }

    public Schemas schemas() {
        return new Schemas();
    }

    public Tokens tokens() {
        return new Tokens();
    }

    public TwoStepVerification twoStepVerification() {
        return new TwoStepVerification();
    }

    public Users users() {
        return new Users();
    }

    public VerificationCodes verificationCodes() {
        return new VerificationCodes();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.32.1 of the Admin SDK API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Directory.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://admin.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Directory.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Directory.DEFAULT_BATCH_PATH);
        }

        public Directory build() {
            return new Directory(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDirectoryRequestInitializer(DirectoryRequestInitializer directoryRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)directoryRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class VerificationCodes {
        public Generate generate(String userKey) throws IOException {
            Generate result = new Generate(userKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Invalidate invalidate(String userKey) throws IOException {
            Invalidate result = new Invalidate(userKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String userKey) throws IOException {
            List result = new List(userKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DirectoryRequest<com.google.api.services.directory.model.VerificationCodes> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}/verificationCodes";
            @Key
            private String userKey;

            protected List(String userKey) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.VerificationCodes.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public List setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Invalidate
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}/verificationCodes/invalidate";
            @Key
            private String userKey;

            protected Invalidate(String userKey) {
                super(Directory.this, "POST", REST_PATH, null, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
            }

            public Invalidate set$Xgafv(String $Xgafv) {
                return (Invalidate)super.set$Xgafv($Xgafv);
            }

            public Invalidate setAccessToken(String accessToken) {
                return (Invalidate)super.setAccessToken(accessToken);
            }

            public Invalidate setAlt(String alt) {
                return (Invalidate)super.setAlt(alt);
            }

            public Invalidate setCallback(String callback) {
                return (Invalidate)super.setCallback(callback);
            }

            public Invalidate setFields(String fields) {
                return (Invalidate)super.setFields(fields);
            }

            public Invalidate setKey(String key) {
                return (Invalidate)super.setKey(key);
            }

            public Invalidate setOauthToken(String oauthToken) {
                return (Invalidate)super.setOauthToken(oauthToken);
            }

            public Invalidate setPrettyPrint(Boolean prettyPrint) {
                return (Invalidate)super.setPrettyPrint(prettyPrint);
            }

            public Invalidate setQuotaUser(String quotaUser) {
                return (Invalidate)super.setQuotaUser(quotaUser);
            }

            public Invalidate setUploadType(String uploadType) {
                return (Invalidate)super.setUploadType(uploadType);
            }

            public Invalidate setUploadProtocol(String uploadProtocol) {
                return (Invalidate)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Invalidate setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            @Override
            public Invalidate set(String parameterName, Object value) {
                return (Invalidate)super.set(parameterName, value);
            }
        }

        public class Generate
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}/verificationCodes/generate";
            @Key
            private String userKey;

            protected Generate(String userKey) {
                super(Directory.this, "POST", REST_PATH, null, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
            }

            public Generate set$Xgafv(String $Xgafv) {
                return (Generate)super.set$Xgafv($Xgafv);
            }

            public Generate setAccessToken(String accessToken) {
                return (Generate)super.setAccessToken(accessToken);
            }

            public Generate setAlt(String alt) {
                return (Generate)super.setAlt(alt);
            }

            public Generate setCallback(String callback) {
                return (Generate)super.setCallback(callback);
            }

            public Generate setFields(String fields) {
                return (Generate)super.setFields(fields);
            }

            public Generate setKey(String key) {
                return (Generate)super.setKey(key);
            }

            public Generate setOauthToken(String oauthToken) {
                return (Generate)super.setOauthToken(oauthToken);
            }

            public Generate setPrettyPrint(Boolean prettyPrint) {
                return (Generate)super.setPrettyPrint(prettyPrint);
            }

            public Generate setQuotaUser(String quotaUser) {
                return (Generate)super.setQuotaUser(quotaUser);
            }

            public Generate setUploadType(String uploadType) {
                return (Generate)super.setUploadType(uploadType);
            }

            public Generate setUploadProtocol(String uploadProtocol) {
                return (Generate)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Generate setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            @Override
            public Generate set(String parameterName, Object value) {
                return (Generate)super.set(parameterName, value);
            }
        }
    }

    public class Users {
        public Delete delete(String userKey) throws IOException {
            Delete result = new Delete(userKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String userKey) throws IOException {
            Get result = new Get(userKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(User content) throws IOException {
            Insert result = new Insert(content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public MakeAdmin makeAdmin(String userKey, UserMakeAdmin content) throws IOException {
            MakeAdmin result = new MakeAdmin(userKey, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String userKey, User content) throws IOException {
            Patch result = new Patch(userKey, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SignOut signOut(String userKey) throws IOException {
            SignOut result = new SignOut(userKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Undelete undelete(String userKey, UserUndelete content) throws IOException {
            Undelete result = new Undelete(userKey, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String userKey, User content) throws IOException {
            Update result = new Update(userKey, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Watch watch(Channel content) throws IOException {
            Watch result = new Watch(content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Aliases aliases() {
            return new Aliases();
        }

        public Photos photos() {
            return new Photos();
        }

        public class Photos {
            public Delete delete(String userKey) throws IOException {
                Delete result = new Delete(userKey);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String userKey) throws IOException {
                Get result = new Get(userKey);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String userKey, UserPhoto content) throws IOException {
                Patch result = new Patch(userKey, content);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String userKey, UserPhoto content) throws IOException {
                Update result = new Update(userKey, content);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends DirectoryRequest<UserPhoto> {
                private static final String REST_PATH = "admin/directory/v1/users/{userKey}/photos/thumbnail";
                @Key
                private String userKey;

                protected Update(String userKey, UserPhoto content) {
                    super(Directory.this, "PUT", REST_PATH, (Object)content, UserPhoto.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getPhotoData(), "UserPhoto.getPhotoData()");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Update setUserKey(String userKey) {
                    this.userKey = userKey;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends DirectoryRequest<UserPhoto> {
                private static final String REST_PATH = "admin/directory/v1/users/{userKey}/photos/thumbnail";
                @Key
                private String userKey;

                protected Patch(String userKey, UserPhoto content) {
                    super(Directory.this, "PATCH", REST_PATH, (Object)content, UserPhoto.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Patch setUserKey(String userKey) {
                    this.userKey = userKey;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class Get
            extends DirectoryRequest<UserPhoto> {
                private static final String REST_PATH = "admin/directory/v1/users/{userKey}/photos/thumbnail";
                @Key
                private String userKey;

                protected Get(String userKey) {
                    super(Directory.this, "GET", REST_PATH, null, UserPhoto.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Get setUserKey(String userKey) {
                    this.userKey = userKey;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "admin/directory/v1/users/{userKey}/photos/thumbnail";
                @Key
                private String userKey;

                protected Delete(String userKey) {
                    super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Delete setUserKey(String userKey) {
                    this.userKey = userKey;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Aliases {
            public Delete delete(String userKey, String alias) throws IOException {
                Delete result = new Delete(userKey, alias);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String userKey, Alias content) throws IOException {
                Insert result = new Insert(userKey, content);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String userKey) throws IOException {
                List result = new List(userKey);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Watch watch(String userKey, Channel content) throws IOException {
                Watch result = new Watch(userKey, content);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Watch
            extends DirectoryRequest<Channel> {
                private static final String REST_PATH = "admin/directory/v1/users/{userKey}/aliases/watch";
                @Key
                private String userKey;
                @Key
                private String event;

                protected Watch(String userKey, Channel content) {
                    super(Directory.this, "POST", REST_PATH, (Object)content, Channel.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
                }

                public Watch set$Xgafv(String $Xgafv) {
                    return (Watch)super.set$Xgafv($Xgafv);
                }

                public Watch setAccessToken(String accessToken) {
                    return (Watch)super.setAccessToken(accessToken);
                }

                public Watch setAlt(String alt) {
                    return (Watch)super.setAlt(alt);
                }

                public Watch setCallback(String callback) {
                    return (Watch)super.setCallback(callback);
                }

                public Watch setFields(String fields) {
                    return (Watch)super.setFields(fields);
                }

                public Watch setKey(String key) {
                    return (Watch)super.setKey(key);
                }

                public Watch setOauthToken(String oauthToken) {
                    return (Watch)super.setOauthToken(oauthToken);
                }

                public Watch setPrettyPrint(Boolean prettyPrint) {
                    return (Watch)super.setPrettyPrint(prettyPrint);
                }

                public Watch setQuotaUser(String quotaUser) {
                    return (Watch)super.setQuotaUser(quotaUser);
                }

                public Watch setUploadType(String uploadType) {
                    return (Watch)super.setUploadType(uploadType);
                }

                public Watch setUploadProtocol(String uploadProtocol) {
                    return (Watch)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Watch setUserKey(String userKey) {
                    this.userKey = userKey;
                    return this;
                }

                public String getEvent() {
                    return this.event;
                }

                public Watch setEvent(String event) {
                    this.event = event;
                    return this;
                }

                @Override
                public Watch set(String parameterName, Object value) {
                    return (Watch)super.set(parameterName, value);
                }
            }

            public class List
            extends DirectoryRequest<com.google.api.services.directory.model.Aliases> {
                private static final String REST_PATH = "admin/directory/v1/users/{userKey}/aliases";
                @Key
                private String userKey;
                @Key
                private String event;

                protected List(String userKey) {
                    super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.Aliases.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public List setUserKey(String userKey) {
                    this.userKey = userKey;
                    return this;
                }

                public String getEvent() {
                    return this.event;
                }

                public List setEvent(String event) {
                    this.event = event;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends DirectoryRequest<Alias> {
                private static final String REST_PATH = "admin/directory/v1/users/{userKey}/aliases";
                @Key
                private String userKey;

                protected Insert(String userKey, Alias content) {
                    super(Directory.this, "POST", REST_PATH, (Object)content, Alias.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
                }

                public Insert set$Xgafv(String $Xgafv) {
                    return (Insert)super.set$Xgafv($Xgafv);
                }

                public Insert setAccessToken(String accessToken) {
                    return (Insert)super.setAccessToken(accessToken);
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setCallback(String callback) {
                    return (Insert)super.setCallback(callback);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUploadType(String uploadType) {
                    return (Insert)super.setUploadType(uploadType);
                }

                public Insert setUploadProtocol(String uploadProtocol) {
                    return (Insert)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Insert setUserKey(String userKey) {
                    this.userKey = userKey;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Delete
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "admin/directory/v1/users/{userKey}/aliases/{alias}";
                @Key
                private String userKey;
                @Key
                private String alias;

                protected Delete(String userKey, String alias) {
                    super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
                    this.alias = (String)Preconditions.checkNotNull((Object)alias, (Object)"Required parameter alias must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Delete setUserKey(String userKey) {
                    this.userKey = userKey;
                    return this;
                }

                public String getAlias() {
                    return this.alias;
                }

                public Delete setAlias(String alias) {
                    this.alias = alias;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Watch
        extends DirectoryRequest<Channel> {
            private static final String REST_PATH = "admin/directory/v1/users/watch";
            @Key
            private String customFieldMask;
            @Key
            private String customer;
            @Key
            private String domain;
            @Key
            private String event;
            @Key
            private Integer maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private String projection;
            @Key
            private String query;
            @Key
            private String showDeleted;
            @Key
            private String sortOrder;
            @Key
            private String viewType;

            protected Watch(Channel content) {
                super(Directory.this, "POST", REST_PATH, (Object)content, Channel.class);
            }

            public Watch set$Xgafv(String $Xgafv) {
                return (Watch)super.set$Xgafv($Xgafv);
            }

            public Watch setAccessToken(String accessToken) {
                return (Watch)super.setAccessToken(accessToken);
            }

            public Watch setAlt(String alt) {
                return (Watch)super.setAlt(alt);
            }

            public Watch setCallback(String callback) {
                return (Watch)super.setCallback(callback);
            }

            public Watch setFields(String fields) {
                return (Watch)super.setFields(fields);
            }

            public Watch setKey(String key) {
                return (Watch)super.setKey(key);
            }

            public Watch setOauthToken(String oauthToken) {
                return (Watch)super.setOauthToken(oauthToken);
            }

            public Watch setPrettyPrint(Boolean prettyPrint) {
                return (Watch)super.setPrettyPrint(prettyPrint);
            }

            public Watch setQuotaUser(String quotaUser) {
                return (Watch)super.setQuotaUser(quotaUser);
            }

            public Watch setUploadType(String uploadType) {
                return (Watch)super.setUploadType(uploadType);
            }

            public Watch setUploadProtocol(String uploadProtocol) {
                return (Watch)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomFieldMask() {
                return this.customFieldMask;
            }

            public Watch setCustomFieldMask(String customFieldMask) {
                this.customFieldMask = customFieldMask;
                return this;
            }

            public String getCustomer() {
                return this.customer;
            }

            public Watch setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public String getDomain() {
                return this.domain;
            }

            public Watch setDomain(String domain) {
                this.domain = domain;
                return this;
            }

            public String getEvent() {
                return this.event;
            }

            public Watch setEvent(String event) {
                this.event = event;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Watch setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public Watch setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Watch setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Watch setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public Watch setQuery(String query) {
                this.query = query;
                return this;
            }

            public String getShowDeleted() {
                return this.showDeleted;
            }

            public Watch setShowDeleted(String showDeleted) {
                this.showDeleted = showDeleted;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public Watch setSortOrder(String sortOrder) {
                this.sortOrder = sortOrder;
                return this;
            }

            public String getViewType() {
                return this.viewType;
            }

            public Watch setViewType(String viewType) {
                this.viewType = viewType;
                return this;
            }

            @Override
            public Watch set(String parameterName, Object value) {
                return (Watch)super.set(parameterName, value);
            }
        }

        public class Update
        extends DirectoryRequest<User> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}";
            @Key
            private String userKey;

            protected Update(String userKey, User content) {
                super(Directory.this, "PUT", REST_PATH, (Object)content, User.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Update setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Undelete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}/undelete";
            @Key
            private String userKey;

            protected Undelete(String userKey, UserUndelete content) {
                super(Directory.this, "POST", REST_PATH, (Object)content, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
            }

            public Undelete set$Xgafv(String $Xgafv) {
                return (Undelete)super.set$Xgafv($Xgafv);
            }

            public Undelete setAccessToken(String accessToken) {
                return (Undelete)super.setAccessToken(accessToken);
            }

            public Undelete setAlt(String alt) {
                return (Undelete)super.setAlt(alt);
            }

            public Undelete setCallback(String callback) {
                return (Undelete)super.setCallback(callback);
            }

            public Undelete setFields(String fields) {
                return (Undelete)super.setFields(fields);
            }

            public Undelete setKey(String key) {
                return (Undelete)super.setKey(key);
            }

            public Undelete setOauthToken(String oauthToken) {
                return (Undelete)super.setOauthToken(oauthToken);
            }

            public Undelete setPrettyPrint(Boolean prettyPrint) {
                return (Undelete)super.setPrettyPrint(prettyPrint);
            }

            public Undelete setQuotaUser(String quotaUser) {
                return (Undelete)super.setQuotaUser(quotaUser);
            }

            public Undelete setUploadType(String uploadType) {
                return (Undelete)super.setUploadType(uploadType);
            }

            public Undelete setUploadProtocol(String uploadProtocol) {
                return (Undelete)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Undelete setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            @Override
            public Undelete set(String parameterName, Object value) {
                return (Undelete)super.set(parameterName, value);
            }
        }

        public class SignOut
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}/signOut";
            @Key
            private String userKey;

            protected SignOut(String userKey) {
                super(Directory.this, "POST", REST_PATH, null, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
            }

            public SignOut set$Xgafv(String $Xgafv) {
                return (SignOut)super.set$Xgafv($Xgafv);
            }

            public SignOut setAccessToken(String accessToken) {
                return (SignOut)super.setAccessToken(accessToken);
            }

            public SignOut setAlt(String alt) {
                return (SignOut)super.setAlt(alt);
            }

            public SignOut setCallback(String callback) {
                return (SignOut)super.setCallback(callback);
            }

            public SignOut setFields(String fields) {
                return (SignOut)super.setFields(fields);
            }

            public SignOut setKey(String key) {
                return (SignOut)super.setKey(key);
            }

            public SignOut setOauthToken(String oauthToken) {
                return (SignOut)super.setOauthToken(oauthToken);
            }

            public SignOut setPrettyPrint(Boolean prettyPrint) {
                return (SignOut)super.setPrettyPrint(prettyPrint);
            }

            public SignOut setQuotaUser(String quotaUser) {
                return (SignOut)super.setQuotaUser(quotaUser);
            }

            public SignOut setUploadType(String uploadType) {
                return (SignOut)super.setUploadType(uploadType);
            }

            public SignOut setUploadProtocol(String uploadProtocol) {
                return (SignOut)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public SignOut setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            @Override
            public SignOut set(String parameterName, Object value) {
                return (SignOut)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DirectoryRequest<User> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}";
            @Key
            private String userKey;

            protected Patch(String userKey, User content) {
                super(Directory.this, "PATCH", REST_PATH, (Object)content, User.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Patch setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class MakeAdmin
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}/makeAdmin";
            @Key
            private String userKey;

            protected MakeAdmin(String userKey, UserMakeAdmin content) {
                super(Directory.this, "POST", REST_PATH, (Object)content, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
            }

            public MakeAdmin set$Xgafv(String $Xgafv) {
                return (MakeAdmin)super.set$Xgafv($Xgafv);
            }

            public MakeAdmin setAccessToken(String accessToken) {
                return (MakeAdmin)super.setAccessToken(accessToken);
            }

            public MakeAdmin setAlt(String alt) {
                return (MakeAdmin)super.setAlt(alt);
            }

            public MakeAdmin setCallback(String callback) {
                return (MakeAdmin)super.setCallback(callback);
            }

            public MakeAdmin setFields(String fields) {
                return (MakeAdmin)super.setFields(fields);
            }

            public MakeAdmin setKey(String key) {
                return (MakeAdmin)super.setKey(key);
            }

            public MakeAdmin setOauthToken(String oauthToken) {
                return (MakeAdmin)super.setOauthToken(oauthToken);
            }

            public MakeAdmin setPrettyPrint(Boolean prettyPrint) {
                return (MakeAdmin)super.setPrettyPrint(prettyPrint);
            }

            public MakeAdmin setQuotaUser(String quotaUser) {
                return (MakeAdmin)super.setQuotaUser(quotaUser);
            }

            public MakeAdmin setUploadType(String uploadType) {
                return (MakeAdmin)super.setUploadType(uploadType);
            }

            public MakeAdmin setUploadProtocol(String uploadProtocol) {
                return (MakeAdmin)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public MakeAdmin setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            @Override
            public MakeAdmin set(String parameterName, Object value) {
                return (MakeAdmin)super.set(parameterName, value);
            }
        }

        public class List
        extends DirectoryRequest<com.google.api.services.directory.model.Users> {
            private static final String REST_PATH = "admin/directory/v1/users";
            @Key
            private String customFieldMask;
            @Key
            private String customer;
            @Key
            private String domain;
            @Key
            private String event;
            @Key
            private Integer maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private String projection;
            @Key
            private String query;
            @Key
            private String showDeleted;
            @Key
            private String sortOrder;
            @Key
            private String viewType;

            protected List() {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.Users.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomFieldMask() {
                return this.customFieldMask;
            }

            public List setCustomFieldMask(String customFieldMask) {
                this.customFieldMask = customFieldMask;
                return this;
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public String getDomain() {
                return this.domain;
            }

            public List setDomain(String domain) {
                this.domain = domain;
                return this;
            }

            public String getEvent() {
                return this.event;
            }

            public List setEvent(String event) {
                this.event = event;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public List setQuery(String query) {
                this.query = query;
                return this;
            }

            public String getShowDeleted() {
                return this.showDeleted;
            }

            public List setShowDeleted(String showDeleted) {
                this.showDeleted = showDeleted;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String sortOrder) {
                this.sortOrder = sortOrder;
                return this;
            }

            public String getViewType() {
                return this.viewType;
            }

            public List setViewType(String viewType) {
                this.viewType = viewType;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DirectoryRequest<User> {
            private static final String REST_PATH = "admin/directory/v1/users";

            protected Insert(User content) {
                super(Directory.this, "POST", REST_PATH, (Object)content, User.class);
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getPassword(), "User.getPassword()");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getPrimaryEmail(), "User.getPrimaryEmail()");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends DirectoryRequest<User> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}";
            @Key
            private String userKey;
            @Key
            private String customFieldMask;
            @Key
            private String projection;
            @Key
            private String viewType;

            protected Get(String userKey) {
                super(Directory.this, "GET", REST_PATH, null, User.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Get setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            public String getCustomFieldMask() {
                return this.customFieldMask;
            }

            public Get setCustomFieldMask(String customFieldMask) {
                this.customFieldMask = customFieldMask;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public String getViewType() {
                return this.viewType;
            }

            public Get setViewType(String viewType) {
                this.viewType = viewType;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}";
            @Key
            private String userKey;

            protected Delete(String userKey) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Delete setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class TwoStepVerification {
        public TurnOff turnOff(String userKey) throws IOException {
            TurnOff result = new TurnOff(userKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TurnOff
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}/twoStepVerification/turnOff";
            @Key
            private String userKey;

            protected TurnOff(String userKey) {
                super(Directory.this, "POST", REST_PATH, null, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
            }

            public TurnOff set$Xgafv(String $Xgafv) {
                return (TurnOff)super.set$Xgafv($Xgafv);
            }

            public TurnOff setAccessToken(String accessToken) {
                return (TurnOff)super.setAccessToken(accessToken);
            }

            public TurnOff setAlt(String alt) {
                return (TurnOff)super.setAlt(alt);
            }

            public TurnOff setCallback(String callback) {
                return (TurnOff)super.setCallback(callback);
            }

            public TurnOff setFields(String fields) {
                return (TurnOff)super.setFields(fields);
            }

            public TurnOff setKey(String key) {
                return (TurnOff)super.setKey(key);
            }

            public TurnOff setOauthToken(String oauthToken) {
                return (TurnOff)super.setOauthToken(oauthToken);
            }

            public TurnOff setPrettyPrint(Boolean prettyPrint) {
                return (TurnOff)super.setPrettyPrint(prettyPrint);
            }

            public TurnOff setQuotaUser(String quotaUser) {
                return (TurnOff)super.setQuotaUser(quotaUser);
            }

            public TurnOff setUploadType(String uploadType) {
                return (TurnOff)super.setUploadType(uploadType);
            }

            public TurnOff setUploadProtocol(String uploadProtocol) {
                return (TurnOff)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public TurnOff setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            @Override
            public TurnOff set(String parameterName, Object value) {
                return (TurnOff)super.set(parameterName, value);
            }
        }
    }

    public class Tokens {
        public Delete delete(String userKey, String clientId) throws IOException {
            Delete result = new Delete(userKey, clientId);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String userKey, String clientId) throws IOException {
            Get result = new Get(userKey, clientId);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String userKey) throws IOException {
            List result = new List(userKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DirectoryRequest<com.google.api.services.directory.model.Tokens> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}/tokens";
            @Key
            private String userKey;

            protected List(String userKey) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.Tokens.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public List setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DirectoryRequest<Token> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}/tokens/{clientId}";
            @Key
            private String userKey;
            @Key
            private String clientId;

            protected Get(String userKey, String clientId) {
                super(Directory.this, "GET", REST_PATH, null, Token.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
                this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)"Required parameter clientId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Get setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            public String getClientId() {
                return this.clientId;
            }

            public Get setClientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}/tokens/{clientId}";
            @Key
            private String userKey;
            @Key
            private String clientId;

            protected Delete(String userKey, String clientId) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
                this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)"Required parameter clientId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Delete setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            public String getClientId() {
                return this.clientId;
            }

            public Delete setClientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Schemas {
        public Delete delete(String customerId, String schemaKey) throws IOException {
            Delete result = new Delete(customerId, schemaKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String customerId, String schemaKey) throws IOException {
            Get result = new Get(customerId, schemaKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String customerId, Schema content) throws IOException {
            Insert result = new Insert(customerId, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String customerId) throws IOException {
            List result = new List(customerId);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String customerId, String schemaKey, Schema content) throws IOException {
            Patch result = new Patch(customerId, schemaKey, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String customerId, String schemaKey, Schema content) throws IOException {
            Update result = new Update(customerId, schemaKey, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DirectoryRequest<Schema> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/schemas/{schemaKey}";
            @Key
            private String customerId;
            @Key
            private String schemaKey;

            protected Update(String customerId, String schemaKey, Schema content) {
                super(Directory.this, "PUT", REST_PATH, (Object)content, Schema.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.schemaKey = (String)Preconditions.checkNotNull((Object)schemaKey, (Object)"Required parameter schemaKey must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Update setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getSchemaKey() {
                return this.schemaKey;
            }

            public Update setSchemaKey(String schemaKey) {
                this.schemaKey = schemaKey;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DirectoryRequest<Schema> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/schemas/{schemaKey}";
            @Key
            private String customerId;
            @Key
            private String schemaKey;

            protected Patch(String customerId, String schemaKey, Schema content) {
                super(Directory.this, "PATCH", REST_PATH, (Object)content, Schema.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.schemaKey = (String)Preconditions.checkNotNull((Object)schemaKey, (Object)"Required parameter schemaKey must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Patch setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getSchemaKey() {
                return this.schemaKey;
            }

            public Patch setSchemaKey(String schemaKey) {
                this.schemaKey = schemaKey;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DirectoryRequest<com.google.api.services.directory.model.Schemas> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/schemas";
            @Key
            private String customerId;

            protected List(String customerId) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.Schemas.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public List setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DirectoryRequest<Schema> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/schemas";
            @Key
            private String customerId;

            protected Insert(String customerId, Schema content) {
                super(Directory.this, "POST", REST_PATH, (Object)content, Schema.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getDisplayName(), "Schema.getDisplayName()");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getSchemaName(), "Schema.getSchemaName()");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Insert setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends DirectoryRequest<Schema> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/schemas/{schemaKey}";
            @Key
            private String customerId;
            @Key
            private String schemaKey;

            protected Get(String customerId, String schemaKey) {
                super(Directory.this, "GET", REST_PATH, null, Schema.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.schemaKey = (String)Preconditions.checkNotNull((Object)schemaKey, (Object)"Required parameter schemaKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Get setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getSchemaKey() {
                return this.schemaKey;
            }

            public Get setSchemaKey(String schemaKey) {
                this.schemaKey = schemaKey;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/schemas/{schemaKey}";
            @Key
            private String customerId;
            @Key
            private String schemaKey;

            protected Delete(String customerId, String schemaKey) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.schemaKey = (String)Preconditions.checkNotNull((Object)schemaKey, (Object)"Required parameter schemaKey must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Delete setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getSchemaKey() {
                return this.schemaKey;
            }

            public Delete setSchemaKey(String schemaKey) {
                this.schemaKey = schemaKey;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Roles {
        public Delete delete(String customer, String roleId) throws IOException {
            Delete result = new Delete(customer, roleId);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String customer, String roleId) throws IOException {
            Get result = new Get(customer, roleId);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String customer, Role content) throws IOException {
            Insert result = new Insert(customer, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String customer) throws IOException {
            List result = new List(customer);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String customer, String roleId, Role content) throws IOException {
            Patch result = new Patch(customer, roleId, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String customer, String roleId, Role content) throws IOException {
            Update result = new Update(customer, roleId, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DirectoryRequest<Role> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/roles/{roleId}";
            @Key
            private String customer;
            @Key
            private String roleId;

            protected Update(String customer, String roleId, Role content) {
                super(Directory.this, "PUT", REST_PATH, (Object)content, Role.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                this.roleId = (String)Preconditions.checkNotNull((Object)roleId, (Object)"Required parameter roleId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Update setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public String getRoleId() {
                return this.roleId;
            }

            public Update setRoleId(String roleId) {
                this.roleId = roleId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DirectoryRequest<Role> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/roles/{roleId}";
            @Key
            private String customer;
            @Key
            private String roleId;

            protected Patch(String customer, String roleId, Role content) {
                super(Directory.this, "PATCH", REST_PATH, (Object)content, Role.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                this.roleId = (String)Preconditions.checkNotNull((Object)roleId, (Object)"Required parameter roleId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Patch setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public String getRoleId() {
                return this.roleId;
            }

            public Patch setRoleId(String roleId) {
                this.roleId = roleId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DirectoryRequest<com.google.api.services.directory.model.Roles> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/roles";
            @Key
            private String customer;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List(String customer) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.Roles.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DirectoryRequest<Role> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/roles";
            @Key
            private String customer;

            protected Insert(String customer, Role content) {
                super(Directory.this, "POST", REST_PATH, (Object)content, Role.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getRoleName(), "Role.getRoleName()");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Insert setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends DirectoryRequest<Role> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/roles/{roleId}";
            @Key
            private String customer;
            @Key
            private String roleId;

            protected Get(String customer, String roleId) {
                super(Directory.this, "GET", REST_PATH, null, Role.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                this.roleId = (String)Preconditions.checkNotNull((Object)roleId, (Object)"Required parameter roleId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Get setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public String getRoleId() {
                return this.roleId;
            }

            public Get setRoleId(String roleId) {
                this.roleId = roleId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/roles/{roleId}";
            @Key
            private String customer;
            @Key
            private String roleId;

            protected Delete(String customer, String roleId) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                this.roleId = (String)Preconditions.checkNotNull((Object)roleId, (Object)"Required parameter roleId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Delete setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public String getRoleId() {
                return this.roleId;
            }

            public Delete setRoleId(String roleId) {
                this.roleId = roleId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class RoleAssignments {
        public Delete delete(String customer, String roleAssignmentId) throws IOException {
            Delete result = new Delete(customer, roleAssignmentId);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String customer, String roleAssignmentId) throws IOException {
            Get result = new Get(customer, roleAssignmentId);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String customer, RoleAssignment content) throws IOException {
            Insert result = new Insert(customer, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String customer) throws IOException {
            List result = new List(customer);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DirectoryRequest<com.google.api.services.directory.model.RoleAssignments> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/roleassignments";
            @Key
            private String customer;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String roleId;
            @Key
            private String userKey;

            protected List(String customer) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.RoleAssignments.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getRoleId() {
                return this.roleId;
            }

            public List setRoleId(String roleId) {
                this.roleId = roleId;
                return this;
            }

            public String getUserKey() {
                return this.userKey;
            }

            public List setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DirectoryRequest<RoleAssignment> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/roleassignments";
            @Key
            private String customer;

            protected Insert(String customer, RoleAssignment content) {
                super(Directory.this, "POST", REST_PATH, (Object)content, RoleAssignment.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Insert setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends DirectoryRequest<RoleAssignment> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/roleassignments/{roleAssignmentId}";
            @Key
            private String customer;
            @Key
            private String roleAssignmentId;

            protected Get(String customer, String roleAssignmentId) {
                super(Directory.this, "GET", REST_PATH, null, RoleAssignment.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                this.roleAssignmentId = (String)Preconditions.checkNotNull((Object)roleAssignmentId, (Object)"Required parameter roleAssignmentId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Get setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public String getRoleAssignmentId() {
                return this.roleAssignmentId;
            }

            public Get setRoleAssignmentId(String roleAssignmentId) {
                this.roleAssignmentId = roleAssignmentId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/roleassignments/{roleAssignmentId}";
            @Key
            private String customer;
            @Key
            private String roleAssignmentId;

            protected Delete(String customer, String roleAssignmentId) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                this.roleAssignmentId = (String)Preconditions.checkNotNull((Object)roleAssignmentId, (Object)"Required parameter roleAssignmentId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Delete setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public String getRoleAssignmentId() {
                return this.roleAssignmentId;
            }

            public Delete setRoleAssignmentId(String roleAssignmentId) {
                this.roleAssignmentId = roleAssignmentId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Resources {
        public Buildings buildings() {
            return new Buildings();
        }

        public Calendars calendars() {
            return new Calendars();
        }

        public Features features() {
            return new Features();
        }

        public class Features {
            public Delete delete(String customer, String featureKey) throws IOException {
                Delete result = new Delete(customer, featureKey);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String customer, String featureKey) throws IOException {
                Get result = new Get(customer, featureKey);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String customer, Feature content) throws IOException {
                Insert result = new Insert(customer, content);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String customer) throws IOException {
                List result = new List(customer);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String customer, String featureKey, Feature content) throws IOException {
                Patch result = new Patch(customer, featureKey, content);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Rename rename(String customer, String oldName, FeatureRename content) throws IOException {
                Rename result = new Rename(customer, oldName, content);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String customer, String featureKey, Feature content) throws IOException {
                Update result = new Update(customer, featureKey, content);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends DirectoryRequest<Feature> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/features/{featureKey}";
                @Key
                private String customer;
                @Key
                private String featureKey;

                protected Update(String customer, String featureKey, Feature content) {
                    super(Directory.this, "PUT", REST_PATH, (Object)content, Feature.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                    this.featureKey = (String)Preconditions.checkNotNull((Object)featureKey, (Object)"Required parameter featureKey must be specified.");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Update setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public String getFeatureKey() {
                    return this.featureKey;
                }

                public Update setFeatureKey(String featureKey) {
                    this.featureKey = featureKey;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Rename
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/features/{oldName}/rename";
                @Key
                private String customer;
                @Key
                private String oldName;

                protected Rename(String customer, String oldName, FeatureRename content) {
                    super(Directory.this, "POST", REST_PATH, (Object)content, Void.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                    this.oldName = (String)Preconditions.checkNotNull((Object)oldName, (Object)"Required parameter oldName must be specified.");
                }

                public Rename set$Xgafv(String $Xgafv) {
                    return (Rename)super.set$Xgafv($Xgafv);
                }

                public Rename setAccessToken(String accessToken) {
                    return (Rename)super.setAccessToken(accessToken);
                }

                public Rename setAlt(String alt) {
                    return (Rename)super.setAlt(alt);
                }

                public Rename setCallback(String callback) {
                    return (Rename)super.setCallback(callback);
                }

                public Rename setFields(String fields) {
                    return (Rename)super.setFields(fields);
                }

                public Rename setKey(String key) {
                    return (Rename)super.setKey(key);
                }

                public Rename setOauthToken(String oauthToken) {
                    return (Rename)super.setOauthToken(oauthToken);
                }

                public Rename setPrettyPrint(Boolean prettyPrint) {
                    return (Rename)super.setPrettyPrint(prettyPrint);
                }

                public Rename setQuotaUser(String quotaUser) {
                    return (Rename)super.setQuotaUser(quotaUser);
                }

                public Rename setUploadType(String uploadType) {
                    return (Rename)super.setUploadType(uploadType);
                }

                public Rename setUploadProtocol(String uploadProtocol) {
                    return (Rename)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Rename setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public String getOldName() {
                    return this.oldName;
                }

                public Rename setOldName(String oldName) {
                    this.oldName = oldName;
                    return this;
                }

                @Override
                public Rename set(String parameterName, Object value) {
                    return (Rename)super.set(parameterName, value);
                }
            }

            public class Patch
            extends DirectoryRequest<Feature> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/features/{featureKey}";
                @Key
                private String customer;
                @Key
                private String featureKey;

                protected Patch(String customer, String featureKey, Feature content) {
                    super(Directory.this, "PATCH", REST_PATH, (Object)content, Feature.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                    this.featureKey = (String)Preconditions.checkNotNull((Object)featureKey, (Object)"Required parameter featureKey must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Patch setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public String getFeatureKey() {
                    return this.featureKey;
                }

                public Patch setFeatureKey(String featureKey) {
                    this.featureKey = featureKey;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends DirectoryRequest<com.google.api.services.directory.model.Features> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/features";
                @Key
                private String customer;
                @Key
                private Integer maxResults;
                @Key
                private String pageToken;

                protected List(String customer) {
                    super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.Features.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public List setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends DirectoryRequest<Feature> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/features";
                @Key
                private String customer;

                protected Insert(String customer, Feature content) {
                    super(Directory.this, "POST", REST_PATH, (Object)content, Feature.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getName(), "Feature.getName()");
                }

                public Insert set$Xgafv(String $Xgafv) {
                    return (Insert)super.set$Xgafv($Xgafv);
                }

                public Insert setAccessToken(String accessToken) {
                    return (Insert)super.setAccessToken(accessToken);
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setCallback(String callback) {
                    return (Insert)super.setCallback(callback);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUploadType(String uploadType) {
                    return (Insert)super.setUploadType(uploadType);
                }

                public Insert setUploadProtocol(String uploadProtocol) {
                    return (Insert)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Insert setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Get
            extends DirectoryRequest<Feature> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/features/{featureKey}";
                @Key
                private String customer;
                @Key
                private String featureKey;

                protected Get(String customer, String featureKey) {
                    super(Directory.this, "GET", REST_PATH, null, Feature.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                    this.featureKey = (String)Preconditions.checkNotNull((Object)featureKey, (Object)"Required parameter featureKey must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Get setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public String getFeatureKey() {
                    return this.featureKey;
                }

                public Get setFeatureKey(String featureKey) {
                    this.featureKey = featureKey;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/features/{featureKey}";
                @Key
                private String customer;
                @Key
                private String featureKey;

                protected Delete(String customer, String featureKey) {
                    super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                    this.featureKey = (String)Preconditions.checkNotNull((Object)featureKey, (Object)"Required parameter featureKey must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Delete setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public String getFeatureKey() {
                    return this.featureKey;
                }

                public Delete setFeatureKey(String featureKey) {
                    this.featureKey = featureKey;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Calendars {
            public Delete delete(String customer, String calendarResourceId) throws IOException {
                Delete result = new Delete(customer, calendarResourceId);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String customer, String calendarResourceId) throws IOException {
                Get result = new Get(customer, calendarResourceId);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String customer, CalendarResource content) throws IOException {
                Insert result = new Insert(customer, content);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String customer) throws IOException {
                List result = new List(customer);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String customer, String calendarResourceId, CalendarResource content) throws IOException {
                Patch result = new Patch(customer, calendarResourceId, content);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String customer, String calendarResourceId, CalendarResource content) throws IOException {
                Update result = new Update(customer, calendarResourceId, content);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends DirectoryRequest<CalendarResource> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/calendars/{calendarResourceId}";
                @Key
                private String customer;
                @Key
                private String calendarResourceId;

                protected Update(String customer, String calendarResourceId, CalendarResource content) {
                    super(Directory.this, "PUT", REST_PATH, (Object)content, CalendarResource.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                    this.calendarResourceId = (String)Preconditions.checkNotNull((Object)calendarResourceId, (Object)"Required parameter calendarResourceId must be specified.");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Update setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public String getCalendarResourceId() {
                    return this.calendarResourceId;
                }

                public Update setCalendarResourceId(String calendarResourceId) {
                    this.calendarResourceId = calendarResourceId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends DirectoryRequest<CalendarResource> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/calendars/{calendarResourceId}";
                @Key
                private String customer;
                @Key
                private String calendarResourceId;

                protected Patch(String customer, String calendarResourceId, CalendarResource content) {
                    super(Directory.this, "PATCH", REST_PATH, (Object)content, CalendarResource.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                    this.calendarResourceId = (String)Preconditions.checkNotNull((Object)calendarResourceId, (Object)"Required parameter calendarResourceId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Patch setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public String getCalendarResourceId() {
                    return this.calendarResourceId;
                }

                public Patch setCalendarResourceId(String calendarResourceId) {
                    this.calendarResourceId = calendarResourceId;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends DirectoryRequest<CalendarResources> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/calendars";
                @Key
                private String customer;
                @Key
                private Integer maxResults;
                @Key
                private String orderBy;
                @Key
                private String pageToken;
                @Key
                private String query;

                protected List(String customer) {
                    super(Directory.this, "GET", REST_PATH, null, CalendarResources.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public List setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getQuery() {
                    return this.query;
                }

                public List setQuery(String query) {
                    this.query = query;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends DirectoryRequest<CalendarResource> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/calendars";
                @Key
                private String customer;

                protected Insert(String customer, CalendarResource content) {
                    super(Directory.this, "POST", REST_PATH, (Object)content, CalendarResource.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getResourceId(), "CalendarResource.getResourceId()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getResourceName(), "CalendarResource.getResourceName()");
                }

                public Insert set$Xgafv(String $Xgafv) {
                    return (Insert)super.set$Xgafv($Xgafv);
                }

                public Insert setAccessToken(String accessToken) {
                    return (Insert)super.setAccessToken(accessToken);
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setCallback(String callback) {
                    return (Insert)super.setCallback(callback);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUploadType(String uploadType) {
                    return (Insert)super.setUploadType(uploadType);
                }

                public Insert setUploadProtocol(String uploadProtocol) {
                    return (Insert)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Insert setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Get
            extends DirectoryRequest<CalendarResource> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/calendars/{calendarResourceId}";
                @Key
                private String customer;
                @Key
                private String calendarResourceId;

                protected Get(String customer, String calendarResourceId) {
                    super(Directory.this, "GET", REST_PATH, null, CalendarResource.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                    this.calendarResourceId = (String)Preconditions.checkNotNull((Object)calendarResourceId, (Object)"Required parameter calendarResourceId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Get setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public String getCalendarResourceId() {
                    return this.calendarResourceId;
                }

                public Get setCalendarResourceId(String calendarResourceId) {
                    this.calendarResourceId = calendarResourceId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/calendars/{calendarResourceId}";
                @Key
                private String customer;
                @Key
                private String calendarResourceId;

                protected Delete(String customer, String calendarResourceId) {
                    super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                    this.calendarResourceId = (String)Preconditions.checkNotNull((Object)calendarResourceId, (Object)"Required parameter calendarResourceId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Delete setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public String getCalendarResourceId() {
                    return this.calendarResourceId;
                }

                public Delete setCalendarResourceId(String calendarResourceId) {
                    this.calendarResourceId = calendarResourceId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Buildings {
            public Delete delete(String customer, String buildingId) throws IOException {
                Delete result = new Delete(customer, buildingId);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String customer, String buildingId) throws IOException {
                Get result = new Get(customer, buildingId);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String customer, Building content) throws IOException {
                Insert result = new Insert(customer, content);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String customer) throws IOException {
                List result = new List(customer);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String customer, String buildingId, Building content) throws IOException {
                Patch result = new Patch(customer, buildingId, content);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String customer, String buildingId, Building content) throws IOException {
                Update result = new Update(customer, buildingId, content);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends DirectoryRequest<Building> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/buildings/{buildingId}";
                @Key
                private String customer;
                @Key
                private String buildingId;
                @Key
                private String coordinatesSource;

                protected Update(String customer, String buildingId, Building content) {
                    super(Directory.this, "PUT", REST_PATH, (Object)content, Building.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                    this.buildingId = (String)Preconditions.checkNotNull((Object)buildingId, (Object)"Required parameter buildingId must be specified.");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Update setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public String getBuildingId() {
                    return this.buildingId;
                }

                public Update setBuildingId(String buildingId) {
                    this.buildingId = buildingId;
                    return this;
                }

                public String getCoordinatesSource() {
                    return this.coordinatesSource;
                }

                public Update setCoordinatesSource(String coordinatesSource) {
                    this.coordinatesSource = coordinatesSource;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends DirectoryRequest<Building> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/buildings/{buildingId}";
                @Key
                private String customer;
                @Key
                private String buildingId;
                @Key
                private String coordinatesSource;

                protected Patch(String customer, String buildingId, Building content) {
                    super(Directory.this, "PATCH", REST_PATH, (Object)content, Building.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                    this.buildingId = (String)Preconditions.checkNotNull((Object)buildingId, (Object)"Required parameter buildingId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Patch setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public String getBuildingId() {
                    return this.buildingId;
                }

                public Patch setBuildingId(String buildingId) {
                    this.buildingId = buildingId;
                    return this;
                }

                public String getCoordinatesSource() {
                    return this.coordinatesSource;
                }

                public Patch setCoordinatesSource(String coordinatesSource) {
                    this.coordinatesSource = coordinatesSource;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends DirectoryRequest<com.google.api.services.directory.model.Buildings> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/buildings";
                @Key
                private String customer;
                @Key
                private Integer maxResults;
                @Key
                private String pageToken;

                protected List(String customer) {
                    super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.Buildings.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public List setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends DirectoryRequest<Building> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/buildings";
                @Key
                private String customer;
                @Key
                private String coordinatesSource;

                protected Insert(String customer, Building content) {
                    super(Directory.this, "POST", REST_PATH, (Object)content, Building.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                }

                public Insert set$Xgafv(String $Xgafv) {
                    return (Insert)super.set$Xgafv($Xgafv);
                }

                public Insert setAccessToken(String accessToken) {
                    return (Insert)super.setAccessToken(accessToken);
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setCallback(String callback) {
                    return (Insert)super.setCallback(callback);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUploadType(String uploadType) {
                    return (Insert)super.setUploadType(uploadType);
                }

                public Insert setUploadProtocol(String uploadProtocol) {
                    return (Insert)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Insert setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public String getCoordinatesSource() {
                    return this.coordinatesSource;
                }

                public Insert setCoordinatesSource(String coordinatesSource) {
                    this.coordinatesSource = coordinatesSource;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Get
            extends DirectoryRequest<Building> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/buildings/{buildingId}";
                @Key
                private String customer;
                @Key
                private String buildingId;

                protected Get(String customer, String buildingId) {
                    super(Directory.this, "GET", REST_PATH, null, Building.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                    this.buildingId = (String)Preconditions.checkNotNull((Object)buildingId, (Object)"Required parameter buildingId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Get setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public String getBuildingId() {
                    return this.buildingId;
                }

                public Get setBuildingId(String buildingId) {
                    this.buildingId = buildingId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "admin/directory/v1/customer/{customer}/resources/buildings/{buildingId}";
                @Key
                private String customer;
                @Key
                private String buildingId;

                protected Delete(String customer, String buildingId) {
                    super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                    this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                    this.buildingId = (String)Preconditions.checkNotNull((Object)buildingId, (Object)"Required parameter buildingId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getCustomer() {
                    return this.customer;
                }

                public Delete setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public String getBuildingId() {
                    return this.buildingId;
                }

                public Delete setBuildingId(String buildingId) {
                    this.buildingId = buildingId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }
    }

    public class Privileges {
        public List list(String customer) throws IOException {
            List result = new List(customer);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DirectoryRequest<com.google.api.services.directory.model.Privileges> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/roles/ALL/privileges";
            @Key
            private String customer;

            protected List(String customer) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.Privileges.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Orgunits {
        public Delete delete(String customerId, String orgUnitPath) throws IOException {
            Delete result = new Delete(customerId, orgUnitPath);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String customerId, String orgUnitPath) throws IOException {
            Get result = new Get(customerId, orgUnitPath);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String customerId, OrgUnit content) throws IOException {
            Insert result = new Insert(customerId, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String customerId) throws IOException {
            List result = new List(customerId);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String customerId, String orgUnitPath, OrgUnit content) throws IOException {
            Patch result = new Patch(customerId, orgUnitPath, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String customerId, String orgUnitPath, OrgUnit content) throws IOException {
            Update result = new Update(customerId, orgUnitPath, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DirectoryRequest<OrgUnit> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/orgunits/{+orgUnitPath}";
            private final Pattern ORG_UNIT_PATH_PATTERN;
            @Key
            private String customerId;
            @Key
            private String orgUnitPath;

            protected Update(String customerId, String orgUnitPath, OrgUnit content) {
                super(Directory.this, "PUT", REST_PATH, (Object)content, OrgUnit.class);
                this.ORG_UNIT_PATH_PATTERN = Pattern.compile("^.*$");
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.orgUnitPath = (String)Preconditions.checkNotNull((Object)orgUnitPath, (Object)"Required parameter orgUnitPath must be specified.");
                if (!Directory.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ORG_UNIT_PATH_PATTERN.matcher(orgUnitPath).matches(), (Object)"Parameter orgUnitPath must conform to the pattern ^.*$");
                }
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Update setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public Update setOrgUnitPath(String orgUnitPath) {
                if (!Directory.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ORG_UNIT_PATH_PATTERN.matcher(orgUnitPath).matches(), (Object)"Parameter orgUnitPath must conform to the pattern ^.*$");
                }
                this.orgUnitPath = orgUnitPath;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DirectoryRequest<OrgUnit> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/orgunits/{+orgUnitPath}";
            private final Pattern ORG_UNIT_PATH_PATTERN;
            @Key
            private String customerId;
            @Key
            private String orgUnitPath;

            protected Patch(String customerId, String orgUnitPath, OrgUnit content) {
                super(Directory.this, "PATCH", REST_PATH, (Object)content, OrgUnit.class);
                this.ORG_UNIT_PATH_PATTERN = Pattern.compile("^.*$");
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.orgUnitPath = (String)Preconditions.checkNotNull((Object)orgUnitPath, (Object)"Required parameter orgUnitPath must be specified.");
                if (!Directory.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ORG_UNIT_PATH_PATTERN.matcher(orgUnitPath).matches(), (Object)"Parameter orgUnitPath must conform to the pattern ^.*$");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Patch setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public Patch setOrgUnitPath(String orgUnitPath) {
                if (!Directory.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ORG_UNIT_PATH_PATTERN.matcher(orgUnitPath).matches(), (Object)"Parameter orgUnitPath must conform to the pattern ^.*$");
                }
                this.orgUnitPath = orgUnitPath;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DirectoryRequest<OrgUnits> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/orgunits";
            @Key
            private String customerId;
            @Key
            private String orgUnitPath;
            @Key
            private String type;

            protected List(String customerId) {
                super(Directory.this, "GET", REST_PATH, null, OrgUnits.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public List setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public List setOrgUnitPath(String orgUnitPath) {
                this.orgUnitPath = orgUnitPath;
                return this;
            }

            public String getType() {
                return this.type;
            }

            public List setType(String type) {
                this.type = type;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DirectoryRequest<OrgUnit> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/orgunits";
            @Key
            private String customerId;

            protected Insert(String customerId, OrgUnit content) {
                super(Directory.this, "POST", REST_PATH, (Object)content, OrgUnit.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getName(), "OrgUnit.getName()");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Insert setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends DirectoryRequest<OrgUnit> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/orgunits/{+orgUnitPath}";
            private final Pattern ORG_UNIT_PATH_PATTERN;
            @Key
            private String customerId;
            @Key
            private String orgUnitPath;

            protected Get(String customerId, String orgUnitPath) {
                super(Directory.this, "GET", REST_PATH, null, OrgUnit.class);
                this.ORG_UNIT_PATH_PATTERN = Pattern.compile("^.*$");
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.orgUnitPath = (String)Preconditions.checkNotNull((Object)orgUnitPath, (Object)"Required parameter orgUnitPath must be specified.");
                if (!Directory.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ORG_UNIT_PATH_PATTERN.matcher(orgUnitPath).matches(), (Object)"Parameter orgUnitPath must conform to the pattern ^.*$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Get setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public Get setOrgUnitPath(String orgUnitPath) {
                if (!Directory.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ORG_UNIT_PATH_PATTERN.matcher(orgUnitPath).matches(), (Object)"Parameter orgUnitPath must conform to the pattern ^.*$");
                }
                this.orgUnitPath = orgUnitPath;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/orgunits/{+orgUnitPath}";
            private final Pattern ORG_UNIT_PATH_PATTERN;
            @Key
            private String customerId;
            @Key
            private String orgUnitPath;

            protected Delete(String customerId, String orgUnitPath) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.ORG_UNIT_PATH_PATTERN = Pattern.compile("^.*$");
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.orgUnitPath = (String)Preconditions.checkNotNull((Object)orgUnitPath, (Object)"Required parameter orgUnitPath must be specified.");
                if (!Directory.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ORG_UNIT_PATH_PATTERN.matcher(orgUnitPath).matches(), (Object)"Parameter orgUnitPath must conform to the pattern ^.*$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Delete setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public Delete setOrgUnitPath(String orgUnitPath) {
                if (!Directory.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ORG_UNIT_PATH_PATTERN.matcher(orgUnitPath).matches(), (Object)"Parameter orgUnitPath must conform to the pattern ^.*$");
                }
                this.orgUnitPath = orgUnitPath;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Mobiledevices {
        public Action action(String customerId, String resourceId, MobileDeviceAction content) throws IOException {
            Action result = new Action(customerId, resourceId, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String customerId, String resourceId) throws IOException {
            Delete result = new Delete(customerId, resourceId);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String customerId, String resourceId) throws IOException {
            Get result = new Get(customerId, resourceId);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String customerId) throws IOException {
            List result = new List(customerId);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DirectoryRequest<MobileDevices> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/devices/mobile";
            @Key
            private String customerId;
            @Key
            private Integer maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private String projection;
            @Key
            private String query;
            @Key
            private String sortOrder;

            protected List(String customerId) {
                super(Directory.this, "GET", REST_PATH, null, MobileDevices.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public List setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public List setQuery(String query) {
                this.query = query;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String sortOrder) {
                this.sortOrder = sortOrder;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DirectoryRequest<MobileDevice> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/devices/mobile/{resourceId}";
            @Key
            private String customerId;
            @Key
            private String resourceId;
            @Key
            private String projection;

            protected Get(String customerId, String resourceId) {
                super(Directory.this, "GET", REST_PATH, null, MobileDevice.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.resourceId = (String)Preconditions.checkNotNull((Object)resourceId, (Object)"Required parameter resourceId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Get setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getResourceId() {
                return this.resourceId;
            }

            public Get setResourceId(String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/devices/mobile/{resourceId}";
            @Key
            private String customerId;
            @Key
            private String resourceId;

            protected Delete(String customerId, String resourceId) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.resourceId = (String)Preconditions.checkNotNull((Object)resourceId, (Object)"Required parameter resourceId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Delete setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getResourceId() {
                return this.resourceId;
            }

            public Delete setResourceId(String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Action
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/devices/mobile/{resourceId}/action";
            @Key
            private String customerId;
            @Key
            private String resourceId;

            protected Action(String customerId, String resourceId, MobileDeviceAction content) {
                super(Directory.this, "POST", REST_PATH, (Object)content, Void.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.resourceId = (String)Preconditions.checkNotNull((Object)resourceId, (Object)"Required parameter resourceId must be specified.");
            }

            public Action set$Xgafv(String $Xgafv) {
                return (Action)super.set$Xgafv($Xgafv);
            }

            public Action setAccessToken(String accessToken) {
                return (Action)super.setAccessToken(accessToken);
            }

            public Action setAlt(String alt) {
                return (Action)super.setAlt(alt);
            }

            public Action setCallback(String callback) {
                return (Action)super.setCallback(callback);
            }

            public Action setFields(String fields) {
                return (Action)super.setFields(fields);
            }

            public Action setKey(String key) {
                return (Action)super.setKey(key);
            }

            public Action setOauthToken(String oauthToken) {
                return (Action)super.setOauthToken(oauthToken);
            }

            public Action setPrettyPrint(Boolean prettyPrint) {
                return (Action)super.setPrettyPrint(prettyPrint);
            }

            public Action setQuotaUser(String quotaUser) {
                return (Action)super.setQuotaUser(quotaUser);
            }

            public Action setUploadType(String uploadType) {
                return (Action)super.setUploadType(uploadType);
            }

            public Action setUploadProtocol(String uploadProtocol) {
                return (Action)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Action setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getResourceId() {
                return this.resourceId;
            }

            public Action setResourceId(String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            @Override
            public Action set(String parameterName, Object value) {
                return (Action)super.set(parameterName, value);
            }
        }
    }

    public class Members {
        public Delete delete(String groupKey, String memberKey) throws IOException {
            Delete result = new Delete(groupKey, memberKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String groupKey, String memberKey) throws IOException {
            Get result = new Get(groupKey, memberKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public HasMember hasMember(String groupKey, String memberKey) throws IOException {
            HasMember result = new HasMember(groupKey, memberKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String groupKey, Member content) throws IOException {
            Insert result = new Insert(groupKey, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String groupKey) throws IOException {
            List result = new List(groupKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String groupKey, String memberKey, Member content) throws IOException {
            Patch result = new Patch(groupKey, memberKey, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String groupKey, String memberKey, Member content) throws IOException {
            Update result = new Update(groupKey, memberKey, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DirectoryRequest<Member> {
            private static final String REST_PATH = "admin/directory/v1/groups/{groupKey}/members/{memberKey}";
            @Key
            private String groupKey;
            @Key
            private String memberKey;

            protected Update(String groupKey, String memberKey, Member content) {
                super(Directory.this, "PUT", REST_PATH, (Object)content, Member.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)groupKey, (Object)"Required parameter groupKey must be specified.");
                this.memberKey = (String)Preconditions.checkNotNull((Object)memberKey, (Object)"Required parameter memberKey must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Update setGroupKey(String groupKey) {
                this.groupKey = groupKey;
                return this;
            }

            public String getMemberKey() {
                return this.memberKey;
            }

            public Update setMemberKey(String memberKey) {
                this.memberKey = memberKey;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DirectoryRequest<Member> {
            private static final String REST_PATH = "admin/directory/v1/groups/{groupKey}/members/{memberKey}";
            @Key
            private String groupKey;
            @Key
            private String memberKey;

            protected Patch(String groupKey, String memberKey, Member content) {
                super(Directory.this, "PATCH", REST_PATH, (Object)content, Member.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)groupKey, (Object)"Required parameter groupKey must be specified.");
                this.memberKey = (String)Preconditions.checkNotNull((Object)memberKey, (Object)"Required parameter memberKey must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Patch setGroupKey(String groupKey) {
                this.groupKey = groupKey;
                return this;
            }

            public String getMemberKey() {
                return this.memberKey;
            }

            public Patch setMemberKey(String memberKey) {
                this.memberKey = memberKey;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DirectoryRequest<com.google.api.services.directory.model.Members> {
            private static final String REST_PATH = "admin/directory/v1/groups/{groupKey}/members";
            @Key
            private String groupKey;
            @Key
            private Boolean includeDerivedMembership;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String roles;

            protected List(String groupKey) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.Members.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)groupKey, (Object)"Required parameter groupKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public List setGroupKey(String groupKey) {
                this.groupKey = groupKey;
                return this;
            }

            public Boolean getIncludeDerivedMembership() {
                return this.includeDerivedMembership;
            }

            public List setIncludeDerivedMembership(Boolean includeDerivedMembership) {
                this.includeDerivedMembership = includeDerivedMembership;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getRoles() {
                return this.roles;
            }

            public List setRoles(String roles) {
                this.roles = roles;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DirectoryRequest<Member> {
            private static final String REST_PATH = "admin/directory/v1/groups/{groupKey}/members";
            @Key
            private String groupKey;

            protected Insert(String groupKey, Member content) {
                super(Directory.this, "POST", REST_PATH, (Object)content, Member.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)groupKey, (Object)"Required parameter groupKey must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Insert setGroupKey(String groupKey) {
                this.groupKey = groupKey;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class HasMember
        extends DirectoryRequest<MembersHasMember> {
            private static final String REST_PATH = "admin/directory/v1/groups/{groupKey}/hasMember/{memberKey}";
            @Key
            private String groupKey;
            @Key
            private String memberKey;

            protected HasMember(String groupKey, String memberKey) {
                super(Directory.this, "GET", REST_PATH, null, MembersHasMember.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)groupKey, (Object)"Required parameter groupKey must be specified.");
                this.memberKey = (String)Preconditions.checkNotNull((Object)memberKey, (Object)"Required parameter memberKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public HasMember set$Xgafv(String $Xgafv) {
                return (HasMember)super.set$Xgafv($Xgafv);
            }

            public HasMember setAccessToken(String accessToken) {
                return (HasMember)super.setAccessToken(accessToken);
            }

            public HasMember setAlt(String alt) {
                return (HasMember)super.setAlt(alt);
            }

            public HasMember setCallback(String callback) {
                return (HasMember)super.setCallback(callback);
            }

            public HasMember setFields(String fields) {
                return (HasMember)super.setFields(fields);
            }

            public HasMember setKey(String key) {
                return (HasMember)super.setKey(key);
            }

            public HasMember setOauthToken(String oauthToken) {
                return (HasMember)super.setOauthToken(oauthToken);
            }

            public HasMember setPrettyPrint(Boolean prettyPrint) {
                return (HasMember)super.setPrettyPrint(prettyPrint);
            }

            public HasMember setQuotaUser(String quotaUser) {
                return (HasMember)super.setQuotaUser(quotaUser);
            }

            public HasMember setUploadType(String uploadType) {
                return (HasMember)super.setUploadType(uploadType);
            }

            public HasMember setUploadProtocol(String uploadProtocol) {
                return (HasMember)super.setUploadProtocol(uploadProtocol);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public HasMember setGroupKey(String groupKey) {
                this.groupKey = groupKey;
                return this;
            }

            public String getMemberKey() {
                return this.memberKey;
            }

            public HasMember setMemberKey(String memberKey) {
                this.memberKey = memberKey;
                return this;
            }

            @Override
            public HasMember set(String parameterName, Object value) {
                return (HasMember)super.set(parameterName, value);
            }
        }

        public class Get
        extends DirectoryRequest<Member> {
            private static final String REST_PATH = "admin/directory/v1/groups/{groupKey}/members/{memberKey}";
            @Key
            private String groupKey;
            @Key
            private String memberKey;

            protected Get(String groupKey, String memberKey) {
                super(Directory.this, "GET", REST_PATH, null, Member.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)groupKey, (Object)"Required parameter groupKey must be specified.");
                this.memberKey = (String)Preconditions.checkNotNull((Object)memberKey, (Object)"Required parameter memberKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Get setGroupKey(String groupKey) {
                this.groupKey = groupKey;
                return this;
            }

            public String getMemberKey() {
                return this.memberKey;
            }

            public Get setMemberKey(String memberKey) {
                this.memberKey = memberKey;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/groups/{groupKey}/members/{memberKey}";
            @Key
            private String groupKey;
            @Key
            private String memberKey;

            protected Delete(String groupKey, String memberKey) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)groupKey, (Object)"Required parameter groupKey must be specified.");
                this.memberKey = (String)Preconditions.checkNotNull((Object)memberKey, (Object)"Required parameter memberKey must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Delete setGroupKey(String groupKey) {
                this.groupKey = groupKey;
                return this;
            }

            public String getMemberKey() {
                return this.memberKey;
            }

            public Delete setMemberKey(String memberKey) {
                this.memberKey = memberKey;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Groups {
        public Delete delete(String groupKey) throws IOException {
            Delete result = new Delete(groupKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String groupKey) throws IOException {
            Get result = new Get(groupKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(Group content) throws IOException {
            Insert result = new Insert(content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String groupKey, Group content) throws IOException {
            Patch result = new Patch(groupKey, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String groupKey, Group content) throws IOException {
            Update result = new Update(groupKey, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Aliases aliases() {
            return new Aliases();
        }

        public class Aliases {
            public Delete delete(String groupKey, String alias) throws IOException {
                Delete result = new Delete(groupKey, alias);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String groupKey, Alias content) throws IOException {
                Insert result = new Insert(groupKey, content);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String groupKey) throws IOException {
                List result = new List(groupKey);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends DirectoryRequest<com.google.api.services.directory.model.Aliases> {
                private static final String REST_PATH = "admin/directory/v1/groups/{groupKey}/aliases";
                @Key
                private String groupKey;

                protected List(String groupKey) {
                    super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.Aliases.class);
                    this.groupKey = (String)Preconditions.checkNotNull((Object)groupKey, (Object)"Required parameter groupKey must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getGroupKey() {
                    return this.groupKey;
                }

                public List setGroupKey(String groupKey) {
                    this.groupKey = groupKey;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends DirectoryRequest<Alias> {
                private static final String REST_PATH = "admin/directory/v1/groups/{groupKey}/aliases";
                @Key
                private String groupKey;

                protected Insert(String groupKey, Alias content) {
                    super(Directory.this, "POST", REST_PATH, (Object)content, Alias.class);
                    this.groupKey = (String)Preconditions.checkNotNull((Object)groupKey, (Object)"Required parameter groupKey must be specified.");
                }

                public Insert set$Xgafv(String $Xgafv) {
                    return (Insert)super.set$Xgafv($Xgafv);
                }

                public Insert setAccessToken(String accessToken) {
                    return (Insert)super.setAccessToken(accessToken);
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setCallback(String callback) {
                    return (Insert)super.setCallback(callback);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUploadType(String uploadType) {
                    return (Insert)super.setUploadType(uploadType);
                }

                public Insert setUploadProtocol(String uploadProtocol) {
                    return (Insert)super.setUploadProtocol(uploadProtocol);
                }

                public String getGroupKey() {
                    return this.groupKey;
                }

                public Insert setGroupKey(String groupKey) {
                    this.groupKey = groupKey;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Delete
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "admin/directory/v1/groups/{groupKey}/aliases/{alias}";
                @Key
                private String groupKey;
                @Key
                private String alias;

                protected Delete(String groupKey, String alias) {
                    super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                    this.groupKey = (String)Preconditions.checkNotNull((Object)groupKey, (Object)"Required parameter groupKey must be specified.");
                    this.alias = (String)Preconditions.checkNotNull((Object)alias, (Object)"Required parameter alias must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getGroupKey() {
                    return this.groupKey;
                }

                public Delete setGroupKey(String groupKey) {
                    this.groupKey = groupKey;
                    return this;
                }

                public String getAlias() {
                    return this.alias;
                }

                public Delete setAlias(String alias) {
                    this.alias = alias;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Update
        extends DirectoryRequest<Group> {
            private static final String REST_PATH = "admin/directory/v1/groups/{groupKey}";
            @Key
            private String groupKey;

            protected Update(String groupKey, Group content) {
                super(Directory.this, "PUT", REST_PATH, (Object)content, Group.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)groupKey, (Object)"Required parameter groupKey must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Update setGroupKey(String groupKey) {
                this.groupKey = groupKey;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DirectoryRequest<Group> {
            private static final String REST_PATH = "admin/directory/v1/groups/{groupKey}";
            @Key
            private String groupKey;

            protected Patch(String groupKey, Group content) {
                super(Directory.this, "PATCH", REST_PATH, (Object)content, Group.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)groupKey, (Object)"Required parameter groupKey must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Patch setGroupKey(String groupKey) {
                this.groupKey = groupKey;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DirectoryRequest<com.google.api.services.directory.model.Groups> {
            private static final String REST_PATH = "admin/directory/v1/groups";
            @Key
            private String customer;
            @Key
            private String domain;
            @Key
            private Integer maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private String query;
            @Key
            private String sortOrder;
            @Key
            private String userKey;

            protected List() {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.Groups.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public String getDomain() {
                return this.domain;
            }

            public List setDomain(String domain) {
                this.domain = domain;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public List setQuery(String query) {
                this.query = query;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String sortOrder) {
                this.sortOrder = sortOrder;
                return this;
            }

            public String getUserKey() {
                return this.userKey;
            }

            public List setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DirectoryRequest<Group> {
            private static final String REST_PATH = "admin/directory/v1/groups";

            protected Insert(Group content) {
                super(Directory.this, "POST", REST_PATH, (Object)content, Group.class);
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getEmail(), "Group.getEmail()");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends DirectoryRequest<Group> {
            private static final String REST_PATH = "admin/directory/v1/groups/{groupKey}";
            @Key
            private String groupKey;

            protected Get(String groupKey) {
                super(Directory.this, "GET", REST_PATH, null, Group.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)groupKey, (Object)"Required parameter groupKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Get setGroupKey(String groupKey) {
                this.groupKey = groupKey;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/groups/{groupKey}";
            @Key
            private String groupKey;

            protected Delete(String groupKey) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)groupKey, (Object)"Required parameter groupKey must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Delete setGroupKey(String groupKey) {
                this.groupKey = groupKey;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Domains {
        public Delete delete(String customer, String domainName) throws IOException {
            Delete result = new Delete(customer, domainName);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String customer, String domainName) throws IOException {
            Get result = new Get(customer, domainName);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String customer, com.google.api.services.directory.model.Domains content) throws IOException {
            Insert result = new Insert(customer, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String customer) throws IOException {
            List result = new List(customer);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DirectoryRequest<Domains2> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/domains";
            @Key
            private String customer;

            protected List(String customer) {
                super(Directory.this, "GET", REST_PATH, null, Domains2.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DirectoryRequest<com.google.api.services.directory.model.Domains> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/domains";
            @Key
            private String customer;

            protected Insert(String customer, com.google.api.services.directory.model.Domains content) {
                super(Directory.this, "POST", REST_PATH, (Object)content, com.google.api.services.directory.model.Domains.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getDomainName(), "Domains.getDomainName()");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Insert setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends DirectoryRequest<com.google.api.services.directory.model.Domains> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/domains/{domainName}";
            @Key
            private String customer;
            @Key
            private String domainName;

            protected Get(String customer, String domainName) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.Domains.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                this.domainName = (String)Preconditions.checkNotNull((Object)domainName, (Object)"Required parameter domainName must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Get setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public String getDomainName() {
                return this.domainName;
            }

            public Get setDomainName(String domainName) {
                this.domainName = domainName;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/domains/{domainName}";
            @Key
            private String customer;
            @Key
            private String domainName;

            protected Delete(String customer, String domainName) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                this.domainName = (String)Preconditions.checkNotNull((Object)domainName, (Object)"Required parameter domainName must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Delete setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public String getDomainName() {
                return this.domainName;
            }

            public Delete setDomainName(String domainName) {
                this.domainName = domainName;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class DomainAliases {
        public Delete delete(String customer, String domainAliasName) throws IOException {
            Delete result = new Delete(customer, domainAliasName);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String customer, String domainAliasName) throws IOException {
            Get result = new Get(customer, domainAliasName);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String customer, DomainAlias content) throws IOException {
            Insert result = new Insert(customer, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String customer) throws IOException {
            List result = new List(customer);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DirectoryRequest<com.google.api.services.directory.model.DomainAliases> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/domainaliases";
            @Key
            private String customer;
            @Key
            private String parentDomainName;

            protected List(String customer) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.DomainAliases.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public String getParentDomainName() {
                return this.parentDomainName;
            }

            public List setParentDomainName(String parentDomainName) {
                this.parentDomainName = parentDomainName;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DirectoryRequest<DomainAlias> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/domainaliases";
            @Key
            private String customer;

            protected Insert(String customer, DomainAlias content) {
                super(Directory.this, "POST", REST_PATH, (Object)content, DomainAlias.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Insert setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends DirectoryRequest<DomainAlias> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/domainaliases/{domainAliasName}";
            @Key
            private String customer;
            @Key
            private String domainAliasName;

            protected Get(String customer, String domainAliasName) {
                super(Directory.this, "GET", REST_PATH, null, DomainAlias.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                this.domainAliasName = (String)Preconditions.checkNotNull((Object)domainAliasName, (Object)"Required parameter domainAliasName must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Get setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public String getDomainAliasName() {
                return this.domainAliasName;
            }

            public Get setDomainAliasName(String domainAliasName) {
                this.domainAliasName = domainAliasName;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customer}/domainaliases/{domainAliasName}";
            @Key
            private String customer;
            @Key
            private String domainAliasName;

            protected Delete(String customer, String domainAliasName) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.customer = (String)Preconditions.checkNotNull((Object)customer, (Object)"Required parameter customer must be specified.");
                this.domainAliasName = (String)Preconditions.checkNotNull((Object)domainAliasName, (Object)"Required parameter domainAliasName must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomer() {
                return this.customer;
            }

            public Delete setCustomer(String customer) {
                this.customer = customer;
                return this;
            }

            public String getDomainAliasName() {
                return this.domainAliasName;
            }

            public Delete setDomainAliasName(String domainAliasName) {
                this.domainAliasName = domainAliasName;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Customers {
        public Get get(String customerKey) throws IOException {
            Get result = new Get(customerKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String customerKey, com.google.api.services.directory.model.Customer content) throws IOException {
            Patch result = new Patch(customerKey, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String customerKey, com.google.api.services.directory.model.Customer content) throws IOException {
            Update result = new Update(customerKey, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Chrome chrome() {
            return new Chrome();
        }

        public class Chrome {
            public Printers printers() {
                return new Printers();
            }

            public class Printers {
                public BatchCreatePrinters batchCreatePrinters(String parent, BatchCreatePrintersRequest content) throws IOException {
                    BatchCreatePrinters result = new BatchCreatePrinters(parent, content);
                    Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public BatchDeletePrinters batchDeletePrinters(String parent, BatchDeletePrintersRequest content) throws IOException {
                    BatchDeletePrinters result = new BatchDeletePrinters(parent, content);
                    Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Create create(String parent, Printer content) throws IOException {
                    Create result = new Create(parent, content);
                    Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public ListPrinterModels listPrinterModels(String parent) throws IOException {
                    ListPrinterModels result = new ListPrinterModels(parent);
                    Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, Printer content) throws IOException {
                    Patch result = new Patch(name, content);
                    Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Patch
                extends DirectoryRequest<Printer> {
                    private static final String REST_PATH = "admin/directory/v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String clearMask;
                    @Key
                    private String updateMask;

                    protected Patch(String name, Printer content) {
                        super(Directory.this, "PATCH", REST_PATH, (Object)content, Printer.class);
                        this.NAME_PATTERN = Pattern.compile("^customers/[^/]+/chrome/printers/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Directory.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^customers/[^/]+/chrome/printers/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!Directory.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^customers/[^/]+/chrome/printers/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getClearMask() {
                        return this.clearMask;
                    }

                    public Patch setClearMask(String clearMask) {
                        this.clearMask = clearMask;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class ListPrinterModels
                extends DirectoryRequest<ListPrinterModelsResponse> {
                    private static final String REST_PATH = "admin/directory/v1/{+parent}/chrome/printers:listPrinterModels";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected ListPrinterModels(String parent) {
                        super(Directory.this, "GET", REST_PATH, null, ListPrinterModelsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^customers/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Directory.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^customers/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public ListPrinterModels set$Xgafv(String $Xgafv) {
                        return (ListPrinterModels)super.set$Xgafv($Xgafv);
                    }

                    public ListPrinterModels setAccessToken(String accessToken) {
                        return (ListPrinterModels)super.setAccessToken(accessToken);
                    }

                    public ListPrinterModels setAlt(String alt) {
                        return (ListPrinterModels)super.setAlt(alt);
                    }

                    public ListPrinterModels setCallback(String callback) {
                        return (ListPrinterModels)super.setCallback(callback);
                    }

                    public ListPrinterModels setFields(String fields) {
                        return (ListPrinterModels)super.setFields(fields);
                    }

                    public ListPrinterModels setKey(String key) {
                        return (ListPrinterModels)super.setKey(key);
                    }

                    public ListPrinterModels setOauthToken(String oauthToken) {
                        return (ListPrinterModels)super.setOauthToken(oauthToken);
                    }

                    public ListPrinterModels setPrettyPrint(Boolean prettyPrint) {
                        return (ListPrinterModels)super.setPrettyPrint(prettyPrint);
                    }

                    public ListPrinterModels setQuotaUser(String quotaUser) {
                        return (ListPrinterModels)super.setQuotaUser(quotaUser);
                    }

                    public ListPrinterModels setUploadType(String uploadType) {
                        return (ListPrinterModels)super.setUploadType(uploadType);
                    }

                    public ListPrinterModels setUploadProtocol(String uploadProtocol) {
                        return (ListPrinterModels)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public ListPrinterModels setParent(String parent) {
                        if (!Directory.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^customers/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public ListPrinterModels setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public ListPrinterModels setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public ListPrinterModels setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public ListPrinterModels set(String parameterName, Object value) {
                        return (ListPrinterModels)super.set(parameterName, value);
                    }
                }

                public class List
                extends DirectoryRequest<ListPrintersResponse> {
                    private static final String REST_PATH = "admin/directory/v1/{+parent}/chrome/printers";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private String orgUnitId;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Directory.this, "GET", REST_PATH, null, ListPrintersResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^customers/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Directory.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^customers/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Directory.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^customers/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrgUnitId() {
                        return this.orgUnitId;
                    }

                    public List setOrgUnitId(String orgUnitId) {
                        this.orgUnitId = orgUnitId;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends DirectoryRequest<Printer> {
                    private static final String REST_PATH = "admin/directory/v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Directory.this, "GET", REST_PATH, null, Printer.class);
                        this.NAME_PATTERN = Pattern.compile("^customers/[^/]+/chrome/printers/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Directory.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^customers/[^/]+/chrome/printers/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Directory.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^customers/[^/]+/chrome/printers/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends DirectoryRequest<Empty> {
                    private static final String REST_PATH = "admin/directory/v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Directory.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^customers/[^/]+/chrome/printers/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Directory.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^customers/[^/]+/chrome/printers/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Directory.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^customers/[^/]+/chrome/printers/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends DirectoryRequest<Printer> {
                    private static final String REST_PATH = "admin/directory/v1/{+parent}/chrome/printers";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, Printer content) {
                        super(Directory.this, "POST", REST_PATH, (Object)content, Printer.class);
                        this.PARENT_PATTERN = Pattern.compile("^customers/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Directory.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^customers/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Directory.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^customers/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }

                public class BatchDeletePrinters
                extends DirectoryRequest<BatchDeletePrintersResponse> {
                    private static final String REST_PATH = "admin/directory/v1/{+parent}/chrome/printers:batchDeletePrinters";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected BatchDeletePrinters(String parent, BatchDeletePrintersRequest content) {
                        super(Directory.this, "POST", REST_PATH, (Object)content, BatchDeletePrintersResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^customers/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Directory.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^customers/[^/]+$");
                        }
                    }

                    public BatchDeletePrinters set$Xgafv(String $Xgafv) {
                        return (BatchDeletePrinters)super.set$Xgafv($Xgafv);
                    }

                    public BatchDeletePrinters setAccessToken(String accessToken) {
                        return (BatchDeletePrinters)super.setAccessToken(accessToken);
                    }

                    public BatchDeletePrinters setAlt(String alt) {
                        return (BatchDeletePrinters)super.setAlt(alt);
                    }

                    public BatchDeletePrinters setCallback(String callback) {
                        return (BatchDeletePrinters)super.setCallback(callback);
                    }

                    public BatchDeletePrinters setFields(String fields) {
                        return (BatchDeletePrinters)super.setFields(fields);
                    }

                    public BatchDeletePrinters setKey(String key) {
                        return (BatchDeletePrinters)super.setKey(key);
                    }

                    public BatchDeletePrinters setOauthToken(String oauthToken) {
                        return (BatchDeletePrinters)super.setOauthToken(oauthToken);
                    }

                    public BatchDeletePrinters setPrettyPrint(Boolean prettyPrint) {
                        return (BatchDeletePrinters)super.setPrettyPrint(prettyPrint);
                    }

                    public BatchDeletePrinters setQuotaUser(String quotaUser) {
                        return (BatchDeletePrinters)super.setQuotaUser(quotaUser);
                    }

                    public BatchDeletePrinters setUploadType(String uploadType) {
                        return (BatchDeletePrinters)super.setUploadType(uploadType);
                    }

                    public BatchDeletePrinters setUploadProtocol(String uploadProtocol) {
                        return (BatchDeletePrinters)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public BatchDeletePrinters setParent(String parent) {
                        if (!Directory.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^customers/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public BatchDeletePrinters set(String parameterName, Object value) {
                        return (BatchDeletePrinters)super.set(parameterName, value);
                    }
                }

                public class BatchCreatePrinters
                extends DirectoryRequest<BatchCreatePrintersResponse> {
                    private static final String REST_PATH = "admin/directory/v1/{+parent}/chrome/printers:batchCreatePrinters";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected BatchCreatePrinters(String parent, BatchCreatePrintersRequest content) {
                        super(Directory.this, "POST", REST_PATH, (Object)content, BatchCreatePrintersResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^customers/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Directory.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^customers/[^/]+$");
                        }
                    }

                    public BatchCreatePrinters set$Xgafv(String $Xgafv) {
                        return (BatchCreatePrinters)super.set$Xgafv($Xgafv);
                    }

                    public BatchCreatePrinters setAccessToken(String accessToken) {
                        return (BatchCreatePrinters)super.setAccessToken(accessToken);
                    }

                    public BatchCreatePrinters setAlt(String alt) {
                        return (BatchCreatePrinters)super.setAlt(alt);
                    }

                    public BatchCreatePrinters setCallback(String callback) {
                        return (BatchCreatePrinters)super.setCallback(callback);
                    }

                    public BatchCreatePrinters setFields(String fields) {
                        return (BatchCreatePrinters)super.setFields(fields);
                    }

                    public BatchCreatePrinters setKey(String key) {
                        return (BatchCreatePrinters)super.setKey(key);
                    }

                    public BatchCreatePrinters setOauthToken(String oauthToken) {
                        return (BatchCreatePrinters)super.setOauthToken(oauthToken);
                    }

                    public BatchCreatePrinters setPrettyPrint(Boolean prettyPrint) {
                        return (BatchCreatePrinters)super.setPrettyPrint(prettyPrint);
                    }

                    public BatchCreatePrinters setQuotaUser(String quotaUser) {
                        return (BatchCreatePrinters)super.setQuotaUser(quotaUser);
                    }

                    public BatchCreatePrinters setUploadType(String uploadType) {
                        return (BatchCreatePrinters)super.setUploadType(uploadType);
                    }

                    public BatchCreatePrinters setUploadProtocol(String uploadProtocol) {
                        return (BatchCreatePrinters)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public BatchCreatePrinters setParent(String parent) {
                        if (!Directory.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^customers/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public BatchCreatePrinters set(String parameterName, Object value) {
                        return (BatchCreatePrinters)super.set(parameterName, value);
                    }
                }
            }
        }

        public class Update
        extends DirectoryRequest<com.google.api.services.directory.model.Customer> {
            private static final String REST_PATH = "admin/directory/v1/customers/{customerKey}";
            @Key
            private String customerKey;

            protected Update(String customerKey, com.google.api.services.directory.model.Customer content) {
                super(Directory.this, "PUT", REST_PATH, (Object)content, com.google.api.services.directory.model.Customer.class);
                this.customerKey = (String)Preconditions.checkNotNull((Object)customerKey, (Object)"Required parameter customerKey must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerKey() {
                return this.customerKey;
            }

            public Update setCustomerKey(String customerKey) {
                this.customerKey = customerKey;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DirectoryRequest<com.google.api.services.directory.model.Customer> {
            private static final String REST_PATH = "admin/directory/v1/customers/{customerKey}";
            @Key
            private String customerKey;

            protected Patch(String customerKey, com.google.api.services.directory.model.Customer content) {
                super(Directory.this, "PATCH", REST_PATH, (Object)content, com.google.api.services.directory.model.Customer.class);
                this.customerKey = (String)Preconditions.checkNotNull((Object)customerKey, (Object)"Required parameter customerKey must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerKey() {
                return this.customerKey;
            }

            public Patch setCustomerKey(String customerKey) {
                this.customerKey = customerKey;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class Get
        extends DirectoryRequest<com.google.api.services.directory.model.Customer> {
            private static final String REST_PATH = "admin/directory/v1/customers/{customerKey}";
            @Key
            private String customerKey;

            protected Get(String customerKey) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.Customer.class);
                this.customerKey = (String)Preconditions.checkNotNull((Object)customerKey, (Object)"Required parameter customerKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerKey() {
                return this.customerKey;
            }

            public Get setCustomerKey(String customerKey) {
                this.customerKey = customerKey;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Customer {
        public Devices devices() {
            return new Devices();
        }

        public class Devices {
            public Chromeos chromeos() {
                return new Chromeos();
            }

            public class Chromeos {
                public IssueCommand issueCommand(String customerId, String deviceId, DirectoryChromeosdevicesIssueCommandRequest content) throws IOException {
                    IssueCommand result = new IssueCommand(customerId, deviceId, content);
                    Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Commands commands() {
                    return new Commands();
                }

                public class Commands {
                    public Get get(String customerId, String deviceId, Long commandId) throws IOException {
                        Get result = new Get(customerId, deviceId, commandId);
                        Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class Get
                    extends DirectoryRequest<DirectoryChromeosdevicesCommand> {
                        private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/devices/chromeos/{deviceId}/commands/{commandId}";
                        @Key
                        private String customerId;
                        @Key
                        private String deviceId;
                        @Key
                        private Long commandId;

                        protected Get(String customerId, String deviceId, Long commandId) {
                            super(Directory.this, "GET", REST_PATH, null, DirectoryChromeosdevicesCommand.class);
                            this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                            this.deviceId = (String)Preconditions.checkNotNull((Object)deviceId, (Object)"Required parameter deviceId must be specified.");
                            this.commandId = (Long)Preconditions.checkNotNull((Object)commandId, (Object)"Required parameter commandId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getCustomerId() {
                            return this.customerId;
                        }

                        public Get setCustomerId(String customerId) {
                            this.customerId = customerId;
                            return this;
                        }

                        public String getDeviceId() {
                            return this.deviceId;
                        }

                        public Get setDeviceId(String deviceId) {
                            this.deviceId = deviceId;
                            return this;
                        }

                        public Long getCommandId() {
                            return this.commandId;
                        }

                        public Get setCommandId(Long commandId) {
                            this.commandId = commandId;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }
                }

                public class IssueCommand
                extends DirectoryRequest<DirectoryChromeosdevicesIssueCommandResponse> {
                    private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/devices/chromeos/{deviceId}:issueCommand";
                    @Key
                    private String customerId;
                    @Key
                    private String deviceId;

                    protected IssueCommand(String customerId, String deviceId, DirectoryChromeosdevicesIssueCommandRequest content) {
                        super(Directory.this, "POST", REST_PATH, (Object)content, DirectoryChromeosdevicesIssueCommandResponse.class);
                        this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                        this.deviceId = (String)Preconditions.checkNotNull((Object)deviceId, (Object)"Required parameter deviceId must be specified.");
                    }

                    public IssueCommand set$Xgafv(String $Xgafv) {
                        return (IssueCommand)super.set$Xgafv($Xgafv);
                    }

                    public IssueCommand setAccessToken(String accessToken) {
                        return (IssueCommand)super.setAccessToken(accessToken);
                    }

                    public IssueCommand setAlt(String alt) {
                        return (IssueCommand)super.setAlt(alt);
                    }

                    public IssueCommand setCallback(String callback) {
                        return (IssueCommand)super.setCallback(callback);
                    }

                    public IssueCommand setFields(String fields) {
                        return (IssueCommand)super.setFields(fields);
                    }

                    public IssueCommand setKey(String key) {
                        return (IssueCommand)super.setKey(key);
                    }

                    public IssueCommand setOauthToken(String oauthToken) {
                        return (IssueCommand)super.setOauthToken(oauthToken);
                    }

                    public IssueCommand setPrettyPrint(Boolean prettyPrint) {
                        return (IssueCommand)super.setPrettyPrint(prettyPrint);
                    }

                    public IssueCommand setQuotaUser(String quotaUser) {
                        return (IssueCommand)super.setQuotaUser(quotaUser);
                    }

                    public IssueCommand setUploadType(String uploadType) {
                        return (IssueCommand)super.setUploadType(uploadType);
                    }

                    public IssueCommand setUploadProtocol(String uploadProtocol) {
                        return (IssueCommand)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getCustomerId() {
                        return this.customerId;
                    }

                    public IssueCommand setCustomerId(String customerId) {
                        this.customerId = customerId;
                        return this;
                    }

                    public String getDeviceId() {
                        return this.deviceId;
                    }

                    public IssueCommand setDeviceId(String deviceId) {
                        this.deviceId = deviceId;
                        return this;
                    }

                    @Override
                    public IssueCommand set(String parameterName, Object value) {
                        return (IssueCommand)super.set(parameterName, value);
                    }
                }
            }
        }
    }

    public class Chromeosdevices {
        public Action action(String customerId, String resourceId, ChromeOsDeviceAction content) throws IOException {
            Action result = new Action(customerId, resourceId, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String customerId, String deviceId) throws IOException {
            Get result = new Get(customerId, deviceId);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String customerId) throws IOException {
            List result = new List(customerId);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public MoveDevicesToOu moveDevicesToOu(String customerId, String orgUnitPath, ChromeOsMoveDevicesToOu content) throws IOException {
            MoveDevicesToOu result = new MoveDevicesToOu(customerId, orgUnitPath, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String customerId, String deviceId, ChromeOsDevice content) throws IOException {
            Patch result = new Patch(customerId, deviceId, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String customerId, String deviceId, ChromeOsDevice content) throws IOException {
            Update result = new Update(customerId, deviceId, content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DirectoryRequest<ChromeOsDevice> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/devices/chromeos/{deviceId}";
            @Key
            private String customerId;
            @Key
            private String deviceId;
            @Key
            private String projection;

            protected Update(String customerId, String deviceId, ChromeOsDevice content) {
                super(Directory.this, "PUT", REST_PATH, (Object)content, ChromeOsDevice.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.deviceId = (String)Preconditions.checkNotNull((Object)deviceId, (Object)"Required parameter deviceId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Update setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getDeviceId() {
                return this.deviceId;
            }

            public Update setDeviceId(String deviceId) {
                this.deviceId = deviceId;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Update setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DirectoryRequest<ChromeOsDevice> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/devices/chromeos/{deviceId}";
            @Key
            private String customerId;
            @Key
            private String deviceId;
            @Key
            private String projection;

            protected Patch(String customerId, String deviceId, ChromeOsDevice content) {
                super(Directory.this, "PATCH", REST_PATH, (Object)content, ChromeOsDevice.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.deviceId = (String)Preconditions.checkNotNull((Object)deviceId, (Object)"Required parameter deviceId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Patch setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getDeviceId() {
                return this.deviceId;
            }

            public Patch setDeviceId(String deviceId) {
                this.deviceId = deviceId;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Patch setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class MoveDevicesToOu
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/devices/chromeos/moveDevicesToOu";
            @Key
            private String customerId;
            @Key
            private String orgUnitPath;

            protected MoveDevicesToOu(String customerId, String orgUnitPath, ChromeOsMoveDevicesToOu content) {
                super(Directory.this, "POST", REST_PATH, (Object)content, Void.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.orgUnitPath = (String)Preconditions.checkNotNull((Object)orgUnitPath, (Object)"Required parameter orgUnitPath must be specified.");
            }

            public MoveDevicesToOu set$Xgafv(String $Xgafv) {
                return (MoveDevicesToOu)super.set$Xgafv($Xgafv);
            }

            public MoveDevicesToOu setAccessToken(String accessToken) {
                return (MoveDevicesToOu)super.setAccessToken(accessToken);
            }

            public MoveDevicesToOu setAlt(String alt) {
                return (MoveDevicesToOu)super.setAlt(alt);
            }

            public MoveDevicesToOu setCallback(String callback) {
                return (MoveDevicesToOu)super.setCallback(callback);
            }

            public MoveDevicesToOu setFields(String fields) {
                return (MoveDevicesToOu)super.setFields(fields);
            }

            public MoveDevicesToOu setKey(String key) {
                return (MoveDevicesToOu)super.setKey(key);
            }

            public MoveDevicesToOu setOauthToken(String oauthToken) {
                return (MoveDevicesToOu)super.setOauthToken(oauthToken);
            }

            public MoveDevicesToOu setPrettyPrint(Boolean prettyPrint) {
                return (MoveDevicesToOu)super.setPrettyPrint(prettyPrint);
            }

            public MoveDevicesToOu setQuotaUser(String quotaUser) {
                return (MoveDevicesToOu)super.setQuotaUser(quotaUser);
            }

            public MoveDevicesToOu setUploadType(String uploadType) {
                return (MoveDevicesToOu)super.setUploadType(uploadType);
            }

            public MoveDevicesToOu setUploadProtocol(String uploadProtocol) {
                return (MoveDevicesToOu)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public MoveDevicesToOu setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public MoveDevicesToOu setOrgUnitPath(String orgUnitPath) {
                this.orgUnitPath = orgUnitPath;
                return this;
            }

            @Override
            public MoveDevicesToOu set(String parameterName, Object value) {
                return (MoveDevicesToOu)super.set(parameterName, value);
            }
        }

        public class List
        extends DirectoryRequest<ChromeOsDevices> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/devices/chromeos";
            @Key
            private String customerId;
            @Key
            private Boolean includeChildOrgunits;
            @Key
            private Integer maxResults;
            @Key
            private String orderBy;
            @Key
            private String orgUnitPath;
            @Key
            private String pageToken;
            @Key
            private String projection;
            @Key
            private String query;
            @Key
            private String sortOrder;

            protected List(String customerId) {
                super(Directory.this, "GET", REST_PATH, null, ChromeOsDevices.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public List setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public Boolean getIncludeChildOrgunits() {
                return this.includeChildOrgunits;
            }

            public List setIncludeChildOrgunits(Boolean includeChildOrgunits) {
                this.includeChildOrgunits = includeChildOrgunits;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public List setOrgUnitPath(String orgUnitPath) {
                this.orgUnitPath = orgUnitPath;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public List setQuery(String query) {
                this.query = query;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String sortOrder) {
                this.sortOrder = sortOrder;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DirectoryRequest<ChromeOsDevice> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/devices/chromeos/{deviceId}";
            @Key
            private String customerId;
            @Key
            private String deviceId;
            @Key
            private String projection;

            protected Get(String customerId, String deviceId) {
                super(Directory.this, "GET", REST_PATH, null, ChromeOsDevice.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.deviceId = (String)Preconditions.checkNotNull((Object)deviceId, (Object)"Required parameter deviceId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Get setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getDeviceId() {
                return this.deviceId;
            }

            public Get setDeviceId(String deviceId) {
                this.deviceId = deviceId;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Action
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/customer/{customerId}/devices/chromeos/{resourceId}/action";
            @Key
            private String customerId;
            @Key
            private String resourceId;

            protected Action(String customerId, String resourceId, ChromeOsDeviceAction content) {
                super(Directory.this, "POST", REST_PATH, (Object)content, Void.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)customerId, (Object)"Required parameter customerId must be specified.");
                this.resourceId = (String)Preconditions.checkNotNull((Object)resourceId, (Object)"Required parameter resourceId must be specified.");
            }

            public Action set$Xgafv(String $Xgafv) {
                return (Action)super.set$Xgafv($Xgafv);
            }

            public Action setAccessToken(String accessToken) {
                return (Action)super.setAccessToken(accessToken);
            }

            public Action setAlt(String alt) {
                return (Action)super.setAlt(alt);
            }

            public Action setCallback(String callback) {
                return (Action)super.setCallback(callback);
            }

            public Action setFields(String fields) {
                return (Action)super.setFields(fields);
            }

            public Action setKey(String key) {
                return (Action)super.setKey(key);
            }

            public Action setOauthToken(String oauthToken) {
                return (Action)super.setOauthToken(oauthToken);
            }

            public Action setPrettyPrint(Boolean prettyPrint) {
                return (Action)super.setPrettyPrint(prettyPrint);
            }

            public Action setQuotaUser(String quotaUser) {
                return (Action)super.setQuotaUser(quotaUser);
            }

            public Action setUploadType(String uploadType) {
                return (Action)super.setUploadType(uploadType);
            }

            public Action setUploadProtocol(String uploadProtocol) {
                return (Action)super.setUploadProtocol(uploadProtocol);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Action setCustomerId(String customerId) {
                this.customerId = customerId;
                return this;
            }

            public String getResourceId() {
                return this.resourceId;
            }

            public Action setResourceId(String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            @Override
            public Action set(String parameterName, Object value) {
                return (Action)super.set(parameterName, value);
            }
        }
    }

    public class Channels {
        public Stop stop(Channel content) throws IOException {
            Stop result = new Stop(content);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Stop
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory_v1/channels/stop";

            protected Stop(Channel content) {
                super(Directory.this, "POST", REST_PATH, (Object)content, Void.class);
            }

            public Stop set$Xgafv(String $Xgafv) {
                return (Stop)super.set$Xgafv($Xgafv);
            }

            public Stop setAccessToken(String accessToken) {
                return (Stop)super.setAccessToken(accessToken);
            }

            public Stop setAlt(String alt) {
                return (Stop)super.setAlt(alt);
            }

            public Stop setCallback(String callback) {
                return (Stop)super.setCallback(callback);
            }

            public Stop setFields(String fields) {
                return (Stop)super.setFields(fields);
            }

            public Stop setKey(String key) {
                return (Stop)super.setKey(key);
            }

            public Stop setOauthToken(String oauthToken) {
                return (Stop)super.setOauthToken(oauthToken);
            }

            public Stop setPrettyPrint(Boolean prettyPrint) {
                return (Stop)super.setPrettyPrint(prettyPrint);
            }

            public Stop setQuotaUser(String quotaUser) {
                return (Stop)super.setQuotaUser(quotaUser);
            }

            public Stop setUploadType(String uploadType) {
                return (Stop)super.setUploadType(uploadType);
            }

            public Stop setUploadProtocol(String uploadProtocol) {
                return (Stop)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Stop set(String parameterName, Object value) {
                return (Stop)super.set(parameterName, value);
            }
        }
    }

    public class Asps {
        public Delete delete(String userKey, Integer codeId) throws IOException {
            Delete result = new Delete(userKey, codeId);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String userKey, Integer codeId) throws IOException {
            Get result = new Get(userKey, codeId);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String userKey) throws IOException {
            List result = new List(userKey);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DirectoryRequest<com.google.api.services.directory.model.Asps> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}/asps";
            @Key
            private String userKey;

            protected List(String userKey) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.directory.model.Asps.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public List setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DirectoryRequest<Asp> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}/asps/{codeId}";
            @Key
            private String userKey;
            @Key
            private Integer codeId;

            protected Get(String userKey, Integer codeId) {
                super(Directory.this, "GET", REST_PATH, null, Asp.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
                this.codeId = (Integer)Preconditions.checkNotNull((Object)codeId, (Object)"Required parameter codeId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Get setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            public Integer getCodeId() {
                return this.codeId;
            }

            public Get setCodeId(Integer codeId) {
                this.codeId = codeId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "admin/directory/v1/users/{userKey}/asps/{codeId}";
            @Key
            private String userKey;
            @Key
            private Integer codeId;

            protected Delete(String userKey, Integer codeId) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)userKey, (Object)"Required parameter userKey must be specified.");
                this.codeId = (Integer)Preconditions.checkNotNull((Object)codeId, (Object)"Required parameter codeId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Delete setUserKey(String userKey) {
                this.userKey = userKey;
                return this;
            }

            public Integer getCodeId() {
                return this.codeId;
            }

            public Delete setCodeId(Integer codeId) {
                this.codeId = codeId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }
}

