/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.process.media;

import java.sql.SQLException;
import java.util.Collection;
import org.silverpeas.components.gallery.dao.MediaDAO;
import org.silverpeas.components.gallery.model.AlbumMedia;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.MediaPK;
import org.silverpeas.components.gallery.notification.AlbumMediaEventNotifier;
import org.silverpeas.components.gallery.process.AbstractGalleryDataProcess;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.comment.service.CommentServiceProvider;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.form.record.GenericRecordSet;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.pdc.PdcServiceProvider;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.process.management.ProcessExecutionContext;
import org.silverpeas.core.process.session.ProcessSession;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.logging.SilverLogger;

public class GalleryPasteMediaDataProcess
extends AbstractGalleryDataProcess {
    private final String albumId;
    private Collection<String> albumIdsForDeletion;
    private final MediaPK fromMediaPk;
    private final boolean isCutted;
    private boolean isSameComponentInstanceDestination = true;
    private ResourceReference fromResourceReference = null;
    private ResourceReference toResourceReference = null;
    private MediaPK toMediaPK = null;
    private final Media mediaBeforeChanges;

    protected GalleryPasteMediaDataProcess(Media media, String albumId, MediaPK fromMediaPk, boolean isCutted) {
        super(media);
        this.albumId = albumId;
        this.fromMediaPk = fromMediaPk;
        this.isCutted = isCutted;
        this.mediaBeforeChanges = media.getCopy();
    }

    public static GalleryPasteMediaDataProcess getInstance(Media media, String albumId, MediaPK fromMediaPk, boolean isCutted) {
        return new GalleryPasteMediaDataProcess(media, albumId, fromMediaPk, isCutted);
    }

    @Override
    protected void processData(ProcessExecutionContext context, ProcessSession session) throws Exception {
        this.albumIdsForDeletion = MediaDAO.getAlbumIdsOf(this.mediaBeforeChanges);
        this.albumIdsForDeletion.remove(this.albumId);
        this.isSameComponentInstanceDestination = this.fromMediaPk.getInstanceId().equals(context.getComponentInstanceId());
        this.fromResourceReference = new ResourceReference(this.getMedia().getId(), this.fromMediaPk.getInstanceId());
        if (!this.isSameComponentInstanceDestination) {
            this.getMedia().getMediaPK().setComponentName(context.getComponentInstanceId());
        }
        if (!this.isCutted) {
            this.createMedia(this.albumId, context);
        } else {
            this.updateMedia(true, context);
            if (this.isSameComponentInstanceDestination) {
                this.moveMediaPath(context.getComponentInstanceId(), this.albumId, context);
            } else {
                this.moveMediaPath(this.fromMediaPk.getInstanceId(), this.albumId, context);
            }
        }
        this.toResourceReference = new ResourceReference(this.getMedia().getId(), context.getComponentInstanceId());
        this.toMediaPK = new MediaPK(this.getMedia().getId(), context.getComponentInstanceId());
        this.processPasteCommons(context);
    }

    private void moveMediaPath(String fromComponentInstanceId, String albumId, ProcessExecutionContext context) throws SQLException {
        this.getMedia().setComponentInstanceId(fromComponentInstanceId);
        MediaDAO.deleteAllMediaPath(this.getMedia());
        this.getMedia().setComponentInstanceId(context.getComponentInstanceId());
        MediaDAO.saveMediaPath(this.getMedia(), albumId);
    }

    private void processPasteCommons(ProcessExecutionContext context) throws PdcException, FormException {
        if (!this.isCutted || !this.isSameComponentInstanceDestination) {
            int fromSilverObjectId = this.getGalleryBm().getSilverObjectId(this.fromMediaPk);
            int toSilverObjectId = this.getGalleryBm().getSilverObjectId(this.toMediaPK);
            PdcServiceProvider.getPdcManager().copyPositions(fromSilverObjectId, this.fromMediaPk.getInstanceId(), toSilverObjectId, context.getComponentInstanceId());
            CommentServiceProvider.getCommentService().moveAndReindexComments(this.getMedia().getContributionType(), this.fromResourceReference, this.toResourceReference);
            this.pasteXmlForm(context);
        }
    }

    private void pasteXmlForm(ProcessExecutionContext context) throws FormException {
        if (!this.isCutted || !this.isSameComponentInstanceDestination) {
            try {
                String xmlFormName = this.getXMLFormName(context);
                if (StringUtil.isDefined((String)xmlFormName)) {
                    String xmlFormShortName = xmlFormName.substring(xmlFormName.indexOf("/") + 1, xmlFormName.indexOf("."));
                    if (StringUtil.isNotDefined((String)xmlFormShortName) && "0".equals(xmlFormShortName)) {
                        return;
                    }
                    GenericRecordSet toRecordset = this.getPublicationTemplateManager().addDynamicPublicationTemplate(this.toResourceReference.getInstanceId() + ":" + xmlFormShortName, xmlFormShortName + ".xml");
                    PublicationTemplate pubTemplate = this.getPublicationTemplateManager().getPublicationTemplate(this.fromMediaPk.getInstanceId() + ":" + xmlFormShortName);
                    RecordSet set = pubTemplate.getRecordSet();
                    if (!this.isCutted) {
                        set.copy(this.fromResourceReference, this.toResourceReference, toRecordset.getRecordTemplate(), null);
                    } else {
                        set.move(this.fromResourceReference, this.toResourceReference, toRecordset.getRecordTemplate());
                    }
                }
            }
            catch (PublicationTemplateException e) {
                SilverLogger.getLogger((Object)((Object)this)).warn((Throwable)e);
            }
        }
    }

    public void onSuccessful() throws Exception {
        super.onSuccessful();
        AlbumMediaEventNotifier notifier = AlbumMediaEventNotifier.get();
        if (this.isCutted) {
            for (String albumIdForDeletion : this.albumIdsForDeletion) {
                notifier.notifyEventOn(ResourceEvent.Type.DELETION, new AlbumMedia[]{new AlbumMedia(albumIdForDeletion, this.mediaBeforeChanges)});
            }
        }
        notifier.notifyEventOn(ResourceEvent.Type.CREATION, new AlbumMedia[]{new AlbumMedia(this.albumId, this.getMedia())});
    }
}

