/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.scheduleevent.notification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.Set;
import org.silverpeas.components.scheduleevent.notification.AbstractScheduleEventUserNotification;
import org.silverpeas.components.scheduleevent.service.model.beans.Contributor;
import org.silverpeas.components.scheduleevent.service.model.beans.ScheduleEvent;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.DateUtil;

public class ScheduleEventUserNotification
extends AbstractScheduleEventUserNotification {
    public ScheduleEventUserNotification(ScheduleEvent resource, UserDetail senderUserDetail) {
        super(resource, senderUserDetail);
    }

    protected String getTemplateFileName() {
        return "new";
    }

    protected Collection<String> getUserIdsToNotify() {
        Set<Contributor> contributors = ((ScheduleEvent)this.getResource()).getContributors();
        ArrayList<String> userIds = new ArrayList<String>(contributors.size());
        for (Contributor contributor : contributors) {
            userIds.add(Integer.toString(contributor.getUserId()));
        }
        return userIds;
    }

    protected void performTemplateData(String language, ScheduleEvent resource, SilverpeasTemplate template) {
        String title;
        try {
            title = this.getBundle(language).getString(this.getBundleSubjectKey());
        }
        catch (MissingResourceException ex) {
            title = this.getTitle();
        }
        this.getNotificationMetaData().addLanguage(language, title, "");
        template.setAttribute("eventName", (Object)resource.getTitle());
        template.setAttribute("eventDescription", (Object)resource.getDescription());
        template.setAttribute("eventCreationDate", (Object)DateUtil.getOutputDate((Date)resource.getCreationDate(), (String)language));
        template.setAttribute("event", (Object)resource);
        template.setAttribute("senderName", (Object)this.getSenderUserDetail().getDisplayedName());
    }

    protected void performNotificationResource(String language, ScheduleEvent resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(resource.getTitle());
        notificationResourceData.setResourceDescription(resource.getDescription());
    }
}

