/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery;

import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.component.ComponentInstancePostConstruction;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;

@Named
public class GalleryInstancePostConstruction
implements ComponentInstancePostConstruction {
    @Transactional
    public void postConstruct(String componentInstanceId) {
        NodeService nodeService = NodeService.get();
        NodeDetail rootGallery = this.getGalleryRootNodeFor(componentInstanceId);
        NodeDetail homeGallery = this.getHomeGalleryNodeFor(componentInstanceId, rootGallery);
        nodeService.createNode(rootGallery);
        nodeService.createNode(homeGallery);
    }

    private NodeDetail getGalleryRootNodeFor(String componentInstanceId) {
        NodeDetail rootCategory = new NodeDetail();
        rootCategory.setNodePK(new NodePK("0", componentInstanceId));
        rootCategory.setFatherPK(null);
        rootCategory.setUseId(true);
        rootCategory.setName("Accueil");
        rootCategory.setDescription("La Racine");
        rootCategory.setCreatorId(UserDetail.getCurrentRequester().getId());
        rootCategory.setLevel(1);
        rootCategory.setStatus("Visible");
        return rootCategory;
    }

    private NodeDetail getHomeGalleryNodeFor(String componentInstanceId, NodeDetail inRootNode) {
        NodeDetail rootArchive = new NodeDetail();
        rootArchive.setNodePK(new NodePK("1", componentInstanceId));
        rootArchive.setFatherPK(null);
        rootArchive.setName("Mon album");
        rootArchive.setDescription("Racine Archives");
        rootArchive.setCreatorId(UserDetail.getCurrentRequester().getId());
        rootArchive.setLevel(2);
        rootArchive.setFatherPK(inRootNode.getNodePK());
        rootArchive.setStatus("Invisible");
        return rootArchive;
    }
}

