/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.components.formsonline.model.DefaultFormsOnlineService;
import org.silverpeas.components.formsonline.model.FormInstance;
import org.silverpeas.components.formsonline.model.FormInstanceValidationType;
import org.silverpeas.components.formsonline.model.FormPK;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.MemoizedSupplier;
import org.silverpeas.core.util.StringUtil;

public class FormDetail {
    public static final int STATE_NOT_YET_PUBLISHED = 0;
    public static final int STATE_PUBLISHED = 1;
    public static final int STATE_UNPUBLISHED = 2;
    public static final int VALIDATOR_OK = 0;
    public static final int VALIDATOR_UNDEFINED = 1;
    public static final int VALIDATOR_NOT_ALLOWED = 2;
    public static final String SENDERS_TYPE = "S";
    public static final String RECEIVERS_TYPE_INTERMEDIATE = "I";
    public static final String RECEIVERS_TYPE_FINAL = "R";
    public static final List<String> ALL_RIGHT_TYPES = Collections.unmodifiableList(Arrays.asList("S", "I", "R"));
    public static final List<String> ALL_RECEIVER_TYPES = Collections.unmodifiableList(Arrays.asList("I", "R"));
    private int id = -1;
    private String xmlFormName = null;
    private String name = "";
    private String description = "";
    private String title = "";
    private String creatorId = null;
    private Date creationDate = new Date();
    private String instanceId = null;
    private int state = 0;
    private boolean hierarchicalValidation = false;
    private String requestExchangeReceiver = null;
    private boolean deleteAfterRequestExchange = false;
    private boolean sendable = true;
    private int nbRequests = 0;
    private String hierarchicalValidatorOfCurrentUser;
    private Map<FormInstanceValidationType, Function<FormInstance, Supplier<List<User>>>> possibleValidationTypes;
    private DefaultFormsOnlineService.HierarchicalValidatorCacheManager hvManager;
    private List<User> sendersAsUsers;
    private List<Group> sendersAsGroups;
    private List<User> intermediateReceiversAsUsers;
    private List<Group> intermediateReceiversAsGroups;
    private List<User> receiversAsUsers;
    private List<Group> receiversAsGroups;

    public int getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public Date getCreationDate() {
        return this.creationDate != null ? (Date)this.creationDate.clone() : null;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate != null ? (Date)creationDate.clone() : null;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getXmlFormName() {
        return this.xmlFormName;
    }

    public void setXmlFormName(String xmlFormName) {
        this.xmlFormName = xmlFormName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public boolean isHierarchicalValidation() {
        return this.hierarchicalValidation;
    }

    public void setHierarchicalValidation(boolean hierarchicalValidation) {
        this.hierarchicalValidation = hierarchicalValidation;
    }

    public Optional<String> getRequestExchangeReceiver() {
        return Optional.ofNullable(this.requestExchangeReceiver);
    }

    public void setRequestExchangeReceiver(String requestExchangeReceiver) {
        this.requestExchangeReceiver = StringUtil.defaultStringIfNotDefined((String)requestExchangeReceiver, null);
    }

    public boolean isDeleteAfterRequestExchange() {
        return this.getRequestExchangeReceiver().map(r -> this.deleteAfterRequestExchange).orElse(false);
    }

    public void setDeleteAfterRequestExchange(boolean deleteAfterRequestExchange) {
        this.deleteAfterRequestExchange = deleteAfterRequestExchange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormDetail that = (FormDetail)o;
        return new EqualsBuilder().append(this.id, that.id).append(this.state, that.state).append(this.hierarchicalValidation, that.hierarchicalValidation).append(this.deleteAfterRequestExchange, that.deleteAfterRequestExchange).append((Object)this.xmlFormName, (Object)that.xmlFormName).append((Object)this.name, (Object)that.name).append((Object)this.description, (Object)that.description).append((Object)this.title, (Object)that.title).append((Object)this.creatorId, (Object)that.creatorId).append((Object)this.creationDate, (Object)that.creationDate).append((Object)this.instanceId, (Object)that.instanceId).append((Object)this.requestExchangeReceiver, (Object)that.requestExchangeReceiver).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.id).append((Object)this.xmlFormName).append((Object)this.name).append((Object)this.description).append((Object)this.title).append((Object)this.creatorId).append((Object)this.creationDate).append((Object)this.instanceId).append(this.state).append(this.hierarchicalValidation).append((Object)this.requestExchangeReceiver).append(this.deleteAfterRequestExchange).toHashCode();
    }

    public boolean isPublished() {
        return this.getState() == 1;
    }

    public boolean isUnpublished() {
        return this.getState() == 2;
    }

    public boolean isNotYetPublished() {
        return this.getState() == 0;
    }

    public void setSendable(boolean sendable) {
        this.sendable = sendable;
    }

    public boolean isSendable() {
        return this.sendable;
    }

    private boolean isSender(String userId) {
        return this.isInList(userId, this.getAllSenders());
    }

    public boolean isValidator(String userId) {
        return this.isInList(userId, this.getAllReceivers());
    }

    public FormPK getPK() {
        return new FormPK(Integer.toString(this.getId()), this.getInstanceId());
    }

    private boolean isInList(String userId, List<User> users) {
        for (User user : users) {
            if (!user.getId().equals(userId)) continue;
            return true;
        }
        return false;
    }

    private List<User> getAllSenders() {
        List<User> senders = this.getSendersAsUsers();
        senders.addAll(this.getUsers(this.getSendersAsGroups()));
        return senders;
    }

    private List<User> getAllReceivers() {
        return Stream.concat(this.getReceiversAsUsers().stream(), Stream.concat(this.getUsers(this.getReceiversAsGroups()).stream(), Stream.concat(this.getIntermediateReceiversAsUsers().stream(), this.getUsers(this.getIntermediateReceiversAsGroups()).stream()))).distinct().collect(Collectors.toList());
    }

    private List<User> getUsers(List<Group> groups) {
        return groups.stream().flatMap(g -> g.getAllUsers().stream()).distinct().collect(Collectors.toList());
    }

    public List<User> getSendersAsUsers() {
        if (this.sendersAsUsers == null) {
            return new ArrayList<User>();
        }
        return this.sendersAsUsers;
    }

    public void setSendersAsUsers(List<User> sendersAsUsers) {
        this.sendersAsUsers = sendersAsUsers;
    }

    public List<Group> getSendersAsGroups() {
        if (this.sendersAsGroups == null) {
            return new ArrayList<Group>();
        }
        return this.sendersAsGroups;
    }

    public void setSendersAsGroups(List<Group> sendersAsGroups) {
        this.sendersAsGroups = sendersAsGroups;
    }

    public List<User> getReceiversAsUsers() {
        if (this.receiversAsUsers == null) {
            return new ArrayList<User>();
        }
        return this.receiversAsUsers;
    }

    public void setReceiversAsUsers(List<User> receiversAsUsers) {
        this.receiversAsUsers = receiversAsUsers;
    }

    public List<Group> getReceiversAsGroups() {
        if (this.receiversAsGroups == null) {
            return new ArrayList<Group>();
        }
        return this.receiversAsGroups;
    }

    public void setReceiversAsGroups(List<Group> receiversAsGroups) {
        this.receiversAsGroups = receiversAsGroups;
    }

    protected List<User> getAllFinalReceivers() {
        return Stream.concat(this.getReceiversAsUsers().stream(), this.getUsers(this.getReceiversAsGroups()).stream()).distinct().collect(Collectors.toList());
    }

    public List<User> getIntermediateReceiversAsUsers() {
        if (this.intermediateReceiversAsUsers == null) {
            return new ArrayList<User>();
        }
        return this.intermediateReceiversAsUsers;
    }

    public void setIntermediateReceiversAsUsers(List<User> receiversAsUsers) {
        this.intermediateReceiversAsUsers = receiversAsUsers;
    }

    public List<Group> getIntermediateReceiversAsGroups() {
        if (this.intermediateReceiversAsGroups == null) {
            return new ArrayList<Group>();
        }
        return this.intermediateReceiversAsGroups;
    }

    public void setIntermediateReceiversAsGroups(List<Group> receiversAsGroups) {
        this.intermediateReceiversAsGroups = receiversAsGroups;
    }

    protected List<User> getAllIntermediateReceivers() {
        return Stream.concat(this.getIntermediateReceiversAsUsers().stream(), this.getUsers(this.getIntermediateReceiversAsGroups()).stream()).distinct().collect(Collectors.toList());
    }

    public boolean isIntermediateValidator(String userId) {
        return this.isInList(userId, this.getAllIntermediateReceivers());
    }

    public boolean isFinalValidator(String userId) {
        return this.isInList(userId, this.getAllFinalReceivers());
    }

    public boolean isFinalValidation() {
        return CollectionUtil.isNotEmpty(this.getReceiversAsUsers()) || CollectionUtil.isNotEmpty(this.getReceiversAsGroups());
    }

    public boolean isIntermediateValidation() {
        return CollectionUtil.isNotEmpty(this.getIntermediateReceiversAsUsers()) || CollectionUtil.isNotEmpty(this.getIntermediateReceiversAsGroups());
    }

    public int getNbRequests() {
        return this.nbRequests;
    }

    public void setNbRequests(int nbRequests) {
        this.nbRequests = nbRequests;
    }

    public String getHierarchicalValidatorOfCurrentUser() {
        if (this.hierarchicalValidatorOfCurrentUser == null) {
            this.hierarchicalValidatorOfCurrentUser = this.isHierarchicalValidation() ? this.getHvManager().getHierarchicalValidatorOf(User.getCurrentRequester().getId()) : "";
        }
        return this.hierarchicalValidatorOfCurrentUser;
    }

    DefaultFormsOnlineService.HierarchicalValidatorCacheManager getHvManager() {
        if (this.hvManager == null) {
            this.hvManager = DefaultFormsOnlineService.HierarchicalValidatorCacheManager.get();
        }
        return this.hvManager;
    }

    public int getHierarchicalValidatorState() {
        if (!this.isHierarchicalValidation()) {
            return 0;
        }
        if (StringUtil.isNotDefined((String)this.getHierarchicalValidatorOfCurrentUser())) {
            return 1;
        }
        if (OrganizationController.get().isComponentAvailableToUser(this.getInstanceId(), this.getHierarchicalValidatorOfCurrentUser())) {
            return 0;
        }
        return 2;
    }

    public Map<FormInstanceValidationType, Function<FormInstance, Supplier<List<User>>>> getPossibleRequestValidations() {
        if (this.possibleValidationTypes == null) {
            MemoizedSupplier supplier;
            this.possibleValidationTypes = new LinkedHashMap<FormInstanceValidationType, Function<FormInstance, Supplier<List<User>>>>(FormInstanceValidationType.values().length);
            if (this.isHierarchicalValidation()) {
                this.possibleValidationTypes.put(FormInstanceValidationType.HIERARCHICAL, f -> () -> Collections.singletonList(User.getById((String)f.getHierarchicalValidator())));
            }
            if (this.isIntermediateValidation()) {
                supplier = new MemoizedSupplier(this::getAllIntermediateReceivers);
                this.possibleValidationTypes.put(FormInstanceValidationType.INTERMEDIATE, f -> supplier);
            }
            if (this.isFinalValidation()) {
                supplier = new MemoizedSupplier(this::getAllFinalReceivers);
                this.possibleValidationTypes.put(FormInstanceValidationType.FINAL, f -> supplier);
            }
        }
        return this.possibleValidationTypes;
    }

    public boolean canBeSentBy(User user) {
        return this.isPublished() && this.isSender(user.getId());
    }
}

