/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import org.silverpeas.components.formsonline.model.FormsOnlineException;
import org.silverpeas.components.formsonline.model.FormsOnlineService;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.security.authorization.ComponentAuthorization;
import org.silverpeas.core.util.logging.SilverLogger;

@Named
public class FormsOnlineComponentAuthorization
implements ComponentAuthorization {
    private FormsOnlineComponentAuthorization() {
    }

    public boolean isRelatedTo(String instanceId) {
        return instanceId.startsWith("formsOnline");
    }

    public <T> Stream<T> filter(Collection<T> resources, Function<T, ComponentAuthorization.ComponentResourceReference> converter, String userId, AccessControlOperation ... operations) {
        Set<String> componentIds = resources.stream().map(r -> ((ComponentAuthorization.ComponentResourceReference)converter.apply(r)).getInstanceId()).collect(Collectors.toSet());
        componentIds = ComponentAccessControl.get().filterAuthorizedByUser(componentIds, userId).collect(Collectors.toSet());
        try {
            String orderBy = "name asc";
            Set formIds = FormsOnlineService.get().getAvailableFormsToSend(componentIds, userId, orderBy).stream().map(f -> String.valueOf(f.getId())).collect(Collectors.toSet());
            return resources.stream().filter(r -> formIds.contains(((ComponentAuthorization.ComponentResourceReference)converter.apply(r)).getLocalId()));
        }
        catch (FormsOnlineException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
            return Stream.empty();
        }
    }
}

