/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.virtual;

import java.util.Collection;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.core.virtual.VirtualNodeState;
import org.apache.jackrabbit.core.virtual.VirtualPropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.util.WeakIdentityCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVISProvider
implements VirtualItemStateProvider,
ItemStateListener {
    private static Logger log = LoggerFactory.getLogger(AbstractVISProvider.class);
    private VirtualNodeState root = null;
    protected final NodeId rootNodeId;
    protected final NodeTypeRegistry ntReg;
    private final Map<NodeId, NodeState> nodes = new ReferenceMap(0, 2);
    private final transient Collection<ItemStateListener> listeners = new WeakIdentityCollection(5);

    public AbstractVISProvider(NodeTypeRegistry ntReg, NodeId rootNodeId) {
        this.ntReg = ntReg;
        this.rootNodeId = rootNodeId;
    }

    protected abstract VirtualNodeState createRootNodeState() throws RepositoryException;

    @Override
    public boolean hasItemState(ItemId id) {
        if (id instanceof NodeId) {
            if (this.nodes.containsKey(id)) {
                return true;
            }
            if (id.equals(this.rootNodeId)) {
                return true;
            }
            return this.internalHasNodeState((NodeId)id);
        }
        return this.internalHasPropertyState((PropertyId)id);
    }

    @Override
    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        if (id instanceof NodeId) {
            ItemState s = this.nodes.containsKey(id) ? (ItemState)this.nodes.get(id) : (id.equals(this.rootNodeId) ? this.getRootState() : this.cache(this.internalGetNodeState((NodeId)id)));
            return s;
        }
        return this.internalGetPropertyState((PropertyId)id);
    }

    @Override
    public NodeReferences getNodeReferences(NodeId id) throws NoSuchItemStateException, ItemStateException {
        throw new NoSuchItemStateException(id.toString());
    }

    @Override
    public boolean hasNodeReferences(NodeId id) {
        return false;
    }

    @Override
    public boolean isVirtualRoot(ItemId id) {
        return id.equals(this.rootNodeId);
    }

    @Override
    public NodeId getVirtualRootId() {
        return this.rootNodeId;
    }

    @Override
    public NodeId[] getVirtualRootIds() {
        return new NodeId[]{this.rootNodeId};
    }

    public synchronized NodeState getRootState() throws ItemStateException {
        try {
            if (this.root == null) {
                this.root = this.createRootNodeState();
            }
            return this.root;
        }
        catch (RepositoryException e) {
            throw new ItemStateException("Error creating root node state", e);
        }
    }

    protected synchronized void discardAll() {
        if (this.root != null) {
            this.discardTree(this.root);
            this.nodes.clear();
            this.root = null;
        }
    }

    private void discardTree(NodeState state) {
        for (Name name : state.getPropertyNames()) {
            try {
                this.getItemState(new PropertyId(state.getNodeId(), name)).discard();
            }
            catch (ItemStateException e) {
                log.warn("Unable to discard virtual property " + name, (Throwable)e);
            }
        }
        for (ChildNodeEntry entry : state.getChildNodeEntries()) {
            try {
                this.discardTree((NodeState)this.getItemState(entry.getId()));
            }
            catch (ItemStateException e) {
                log.warn("Unable to discard virtual node " + entry.getId(), (Throwable)e);
            }
        }
        state.discard();
    }

    protected abstract boolean internalHasNodeState(NodeId var1);

    protected abstract VirtualNodeState internalGetNodeState(NodeId var1) throws NoSuchItemStateException, ItemStateException;

    protected boolean internalHasPropertyState(PropertyId id) {
        try {
            NodeState parent = (NodeState)this.getItemState(id.getParentId());
            if (parent instanceof VirtualNodeState) {
                return parent.hasPropertyName(id.getName());
            }
        }
        catch (ItemStateException itemStateException) {
            // empty catch block
        }
        return false;
    }

    protected VirtualPropertyState internalGetPropertyState(PropertyId id) throws NoSuchItemStateException, ItemStateException {
        NodeState parent = (NodeState)this.getItemState(id.getParentId());
        if (parent instanceof VirtualNodeState) {
            return ((VirtualNodeState)parent).getProperty(id.getName());
        }
        throw new NoSuchItemStateException(id.toString());
    }

    @Override
    public VirtualPropertyState createPropertyState(VirtualNodeState parent, Name name, int type, boolean multiValued) throws RepositoryException {
        PropertyId id = new PropertyId(parent.getNodeId(), name);
        VirtualPropertyState prop = new VirtualPropertyState(id);
        prop.setType(type);
        prop.setMultiValued(multiValued);
        return prop;
    }

    @Override
    public VirtualNodeState createNodeState(VirtualNodeState parent, Name name, NodeId id, Name nodeTypeName) throws RepositoryException {
        assert (id != null);
        VirtualNodeState state = new VirtualNodeState(this, parent.getNodeId(), id, nodeTypeName, Name.EMPTY_ARRAY);
        this.cache(state);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ItemStateListener listener) {
        Collection<ItemStateListener> collection = this.listeners;
        synchronized (collection) {
            assert (!this.listeners.contains(listener));
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ItemStateListener listener) {
        Collection<ItemStateListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
    }

    protected NodeTypeRegistry getNodeTypeRegistry() {
        return this.ntReg;
    }

    protected NodeState cache(NodeState state) {
        if (state != null) {
            this.nodes.put(state.getNodeId(), state);
            log.debug("item added to cache. size=" + this.nodes.size());
        }
        return state;
    }

    protected void evict(NodeId id) {
        this.nodes.remove(id);
    }

    public void invalidateItem(ItemId id, boolean recursive) {
        VirtualNodeState state;
        VirtualNodeState virtualNodeState = state = id.equals(this.rootNodeId) ? this.root : (VirtualNodeState)this.nodes.get(id);
        if (state != null) {
            if (recursive) {
                VirtualPropertyState[] props = state.getProperties();
                for (int i = 0; i < props.length; ++i) {
                    props[i].notifyStateUpdated();
                }
                for (ChildNodeEntry pe : state.getChildNodeEntries()) {
                    this.invalidateItem(pe.getId(), true);
                }
            }
            state.notifyStateUpdated();
        }
    }

    protected QPropertyDefinition getApplicablePropertyDef(NodeState parent, Name propertyName, int type, boolean multiValued) throws RepositoryException {
        return this.getEffectiveNodeType(parent).getApplicablePropertyDef(propertyName, type, multiValued);
    }

    protected QNodeDefinition getApplicableChildNodeDef(NodeState parent, Name nodeName, Name nodeTypeName) throws RepositoryException {
        return this.getEffectiveNodeType(parent).getApplicableChildNodeDef(nodeName, nodeTypeName, this.getNodeTypeRegistry());
    }

    protected EffectiveNodeType getEffectiveNodeType(NodeState parent) throws RepositoryException {
        try {
            NodeTypeRegistry ntReg = this.getNodeTypeRegistry();
            return ntReg.getEffectiveNodeType(parent.getNodeTypeName(), parent.getMixinTypeNames());
        }
        catch (NodeTypeConflictException ntce) {
            String msg = "internal error: failed to build effective node type for node " + parent.getNodeId();
            throw new RepositoryException(msg, (Throwable)ntce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateCreated(ItemState created) {
        ItemStateListener[] la;
        Collection<ItemStateListener> collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].stateCreated(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateModified(ItemState modified) {
        ItemStateListener[] la;
        Collection<ItemStateListener> collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].stateModified(modified);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateDestroyed(ItemState destroyed) {
        ItemStateListener[] la;
        if (destroyed.isNode() && destroyed.getId().equals(this.rootNodeId)) {
            try {
                this.root = this.createRootNodeState();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        this.evict((NodeId)destroyed.getId());
        Collection<ItemStateListener> collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].stateDestroyed(destroyed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateDiscarded(ItemState discarded) {
        ItemStateListener[] la;
        if (discarded.isNode() && discarded.getId().equals(this.rootNodeId)) {
            try {
                this.root = this.createRootNodeState();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        this.evict((NodeId)discarded.getId());
        Collection<ItemStateListener> collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].stateDiscarded(discarded);
        }
    }
}

