/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.cache.ConcurrentCache;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.util.Text;
import org.gradle.internal.classpath.Instrumented;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MembershipCache
implements UserConstants,
SynchronousEventListener,
SessionListener {
    private static final Logger log = LoggerFactory.getLogger(MembershipCache.class);
    private static final int MAX_CACHE_SIZE = Instrumented.getInteger((String)"org.apache.jackrabbit.MembershipCache", (int)5000, (String)"org.apache.jackrabbit.core.security.user.MembershipCache");
    private final SessionImpl systemSession;
    private final String groupsPath;
    private final boolean useMembersNode;
    private final String pMembers;
    private final ConcurrentCache<String, Collection<String>> cache;

    MembershipCache(SessionImpl systemSession, String groupsPath, boolean useMembersNode) throws RepositoryException {
        this.systemSession = systemSession;
        this.groupsPath = groupsPath == null ? "/rep:security/rep:authorizables/rep:groups" : groupsPath;
        this.useMembersNode = useMembersNode;
        this.pMembers = systemSession.getJCRName(UserManagerImpl.P_MEMBERS);
        this.cache = new ConcurrentCache("MembershipCache", 16);
        this.cache.setMaxMemorySize(MAX_CACHE_SIZE);
        String[] ntNames = new String[]{systemSession.getJCRName(UserConstants.NT_REP_GROUP), systemSession.getJCRName(UserConstants.NT_REP_MEMBERS)};
        systemSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, 28, groupsPath, true, null, ntNames, false);
        systemSession.addListener(this);
        log.debug("Membership cache initialized. Max Size = {}", (Object)MAX_CACHE_SIZE);
    }

    public void onEvent(EventIterator eventIterator) {
        boolean clear = false;
        while (eventIterator.hasNext() && !clear) {
            Event ev = eventIterator.nextEvent();
            try {
                if (this.pMembers.equals(Text.getName((String)ev.getPath()))) {
                    clear = true;
                    continue;
                }
                if (!this.useMembersNode) continue;
                int type = ev.getType();
                if (type == 4 || type == 16) {
                    Property p = this.systemSession.getProperty(ev.getPath());
                    Name declNtName = ((NodeTypeImpl)p.getDefinition().getDeclaringNodeType()).getQName();
                    clear = NT_REP_MEMBERS.equals(declNtName);
                    continue;
                }
                String parentId = ev.getIdentifier();
                Node n = this.systemSession.getNodeByIdentifier(parentId);
                Name ntName = ((NodeTypeImpl)n.getPrimaryNodeType()).getQName();
                clear = UserConstants.NT_REP_MEMBERS.equals(ntName);
            }
            catch (RepositoryException e) {
                log.warn(e.getMessage());
                clear = true;
            }
        }
        if (clear) {
            this.cache.clear();
            log.debug("Membership cache cleared because of observation event.");
        }
    }

    @Override
    public void loggingOut(SessionImpl session) {
        try {
            this.systemSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
        catch (RepositoryException e) {
            log.error("Unexpected error: Failed to stop event listening of MembershipCache.", (Throwable)e);
        }
    }

    @Override
    public void loggedOut(SessionImpl session) {
    }

    Collection<String> getDeclaredMemberOf(String authorizableNodeIdentifier) throws RepositoryException {
        return this.declaredMemberOf(authorizableNodeIdentifier);
    }

    Collection<String> getMemberOf(String authorizableNodeIdentifier) throws RepositoryException {
        HashSet<String> groupNodeIds = new HashSet<String>();
        this.memberOf(authorizableNodeIdentifier, groupNodeIds);
        return Collections.unmodifiableCollection(groupNodeIds);
    }

    int getSize() {
        return (int)this.cache.getElementCount();
    }

    void clear() {
        this.cache.clear();
    }

    Collection<String> collectDeclaredMembership(String authorizableNodeIdentifier, Session session) throws RepositoryException {
        long t0 = System.nanoTime();
        Collection<String> groupNodeIds = this.collectDeclaredMembershipFromReferences(authorizableNodeIdentifier, session);
        long t1 = System.nanoTime();
        if (log.isDebugEnabled()) {
            log.debug("  collected {} groups for {} via references in {}us", new Object[]{groupNodeIds == null ? -1 : groupNodeIds.size(), authorizableNodeIdentifier, (t1 - t0) / 1000L});
        }
        if (groupNodeIds == null) {
            groupNodeIds = this.collectDeclaredMembershipFromTraversal(authorizableNodeIdentifier, session);
            long t2 = System.nanoTime();
            if (log.isDebugEnabled()) {
                log.debug("  collected {} groups for {} via traversal in {}us", new Object[]{groupNodeIds == null ? -1 : groupNodeIds.size(), authorizableNodeIdentifier, (t2 - t1) / 1000L});
            }
        }
        return groupNodeIds;
    }

    Collection<String> collectMembership(String authorizableNodeIdentifier, Session session) throws RepositoryException {
        HashSet<String> groupNodeIds = new HashSet<String>();
        this.memberOf(authorizableNodeIdentifier, groupNodeIds, session);
        return groupNodeIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> declaredMemberOf(String authorizableNodeIdentifier) throws RepositoryException {
        long t0 = System.nanoTime();
        Collection<String> groupNodeIds = this.cache.get(authorizableNodeIdentifier);
        boolean wasCached = true;
        if (groupNodeIds == null) {
            wasCached = false;
            SessionImpl session = this.getSession();
            try {
                groupNodeIds = this.collectDeclaredMembership(authorizableNodeIdentifier, (Session)session);
                this.cache.put(authorizableNodeIdentifier, Collections.unmodifiableCollection(groupNodeIds), 1L);
            }
            finally {
                if (session != this.systemSession) {
                    session.logout();
                }
            }
        }
        if (log.isDebugEnabled()) {
            long t1 = System.nanoTime();
            log.debug("Membership cache {} {} declared memberships of {} in {}us. cache size = {}", new Object[]{wasCached ? "returns" : "collected", groupNodeIds.size(), authorizableNodeIdentifier, (t1 - t0) / 1000L, this.cache.getElementCount()});
        }
        return groupNodeIds;
    }

    private void memberOf(String authorizableNodeIdentifier, Collection<String> groupNodeIds) throws RepositoryException {
        Collection<String> declared = this.declaredMemberOf(authorizableNodeIdentifier);
        for (String identifier : declared) {
            if (!groupNodeIds.add(identifier)) continue;
            this.memberOf(identifier, groupNodeIds);
        }
    }

    private void memberOf(String authorizableNodeIdentifier, Collection<String> groupNodeIds, Session session) throws RepositoryException {
        Collection<String> declared = this.collectDeclaredMembership(authorizableNodeIdentifier, session);
        for (String identifier : declared) {
            if (!groupNodeIds.add(identifier)) continue;
            this.memberOf(identifier, groupNodeIds, session);
        }
    }

    private Collection<String> collectDeclaredMembershipFromReferences(String authorizableNodeIdentifier, Session session) throws RepositoryException {
        HashSet<String> pIds = new HashSet<String>();
        HashSet<String> nIds = new HashSet<String>();
        PropertyIterator refs = MembershipCache.getMembershipReferences(authorizableNodeIdentifier, session);
        if (refs == null) {
            return null;
        }
        while (refs.hasNext()) {
            try {
                HashSet<String> groupNodeIdentifiers;
                PropertyImpl pMember = (PropertyImpl)refs.nextProperty();
                NodeImpl nGroup = (NodeImpl)pMember.getParent();
                if (P_MEMBERS.equals(pMember.getQName())) {
                    groupNodeIdentifiers = pIds;
                } else {
                    groupNodeIdentifiers = nIds;
                    while (nGroup.isNodeType(NT_REP_MEMBERS)) {
                        nGroup = (NodeImpl)nGroup.getParent();
                    }
                }
                if (nGroup.isNodeType(NT_REP_GROUP)) {
                    groupNodeIdentifiers.add(nGroup.getIdentifier());
                    continue;
                }
                log.debug("Invalid member reference to '{}' -> Not included in membership set.", (Object)this);
            }
            catch (ItemNotFoundException itemNotFoundException) {
            }
            catch (AccessDeniedException accessDeniedException) {}
        }
        return this.select(pIds, nIds);
    }

    private Collection<String> collectDeclaredMembershipFromTraversal(String authorizableNodeIdentifier, Session session) throws RepositoryException {
        HashSet<String> pIds = new HashSet<String>();
        HashSet<String> nIds = new HashSet<String>();
        log.info("Traversing groups tree to collect membership.");
        if (session.nodeExists(this.groupsPath)) {
            Node groupsNode = session.getNode(this.groupsPath);
            this.traverseAndCollect(authorizableNodeIdentifier, pIds, nIds, (NodeImpl)groupsNode);
        }
        return this.select(pIds, nIds);
    }

    private void traverseAndCollect(String authorizableNodeIdentifier, Set<String> pIds, Set<String> nIds, NodeImpl node) throws RepositoryException {
        if (node.isNodeType(NT_REP_GROUP)) {
            String groupId = node.getIdentifier();
            if (node.hasProperty(P_MEMBERS)) {
                for (Value value : node.getProperty(P_MEMBERS).getValues()) {
                    String v = value.getString();
                    if (!v.equals(authorizableNodeIdentifier)) continue;
                    pIds.add(groupId);
                }
            }
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                NodeImpl child = (NodeImpl)iter.nextNode();
                if (!child.isNodeType(NT_REP_MEMBERS)) continue;
                this.isMemberOfNodeBaseMembershipGroup(authorizableNodeIdentifier, groupId, nIds, child);
            }
        } else {
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                NodeImpl child = (NodeImpl)iter.nextNode();
                this.traverseAndCollect(authorizableNodeIdentifier, pIds, nIds, child);
            }
        }
    }

    private void isMemberOfNodeBaseMembershipGroup(String authorizableNodeIdentifier, String groupId, Set<String> nIds, NodeImpl node) throws RepositoryException {
        PropertyIterator pIter = node.getProperties();
        while (pIter.hasNext()) {
            Value[] values;
            Value[] valueArray;
            PropertyImpl p = (PropertyImpl)pIter.nextProperty();
            if (p.getType() != 10) continue;
            if (p.isMultiple()) {
                valueArray = p.getValues();
            } else {
                Value[] valueArray2 = new Value[1];
                valueArray = valueArray2;
                valueArray2[0] = p.getValue();
            }
            for (Value v : values = valueArray) {
                if (!v.getString().equals(authorizableNodeIdentifier)) continue;
                nIds.add(groupId);
                return;
            }
        }
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            NodeImpl child = (NodeImpl)iter.nextNode();
            if (!child.isNodeType(NT_REP_MEMBERS)) continue;
            this.isMemberOfNodeBaseMembershipGroup(authorizableNodeIdentifier, groupId, nIds, child);
        }
    }

    private Set<String> select(Set<String> pIds, Set<String> nIds) {
        Set<String> result = this.useMembersNode ? (!nIds.isEmpty() || pIds.isEmpty() ? nIds : pIds) : (!pIds.isEmpty() || nIds.isEmpty() ? pIds : nIds);
        if (!pIds.isEmpty() && !nIds.isEmpty()) {
            log.warn("Found members node and members property. Ignoring {} members", (Object)(this.useMembersNode ? "property" : "node"));
        }
        return result;
    }

    private SessionImpl getSession() {
        try {
            return (SessionImpl)this.systemSession.createSession(this.systemSession.getWorkspace().getName());
        }
        catch (RepositoryException e) {
            return this.systemSession;
        }
    }

    private static PropertyIterator getMembershipReferences(String authorizableNodeIdentifier, Session session) {
        PropertyIterator refs = null;
        try {
            refs = session.getNodeByIdentifier(authorizableNodeIdentifier).getWeakReferences(null);
        }
        catch (RepositoryException e) {
            log.error("Failed to retrieve membership references of " + authorizableNodeIdentifier + ".", (Throwable)e);
        }
        return refs;
    }
}

