/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.util.Collection;
import java.util.Comparator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;

public class RowPathComparator
implements Comparator<Row> {
    private boolean isNullEqual = true;
    private Collection<String> selectors = null;

    public RowPathComparator(Collection<String> selectors) {
        this.selectors = selectors;
    }

    public RowPathComparator() {
        this(null);
    }

    @Override
    public int compare(Row a, Row b) {
        if (this.selectors != null) {
            for (String selector : this.selectors) {
                String pA = null;
                boolean aExists = true;
                String pB = null;
                boolean bExists = true;
                try {
                    pA = a.getPath(selector);
                }
                catch (RepositoryException e) {
                    aExists = false;
                }
                try {
                    pB = b.getPath(selector);
                }
                catch (RepositoryException e) {
                    bExists = false;
                }
                if (!aExists && bExists || aExists && !bExists) {
                    return aExists ? -1 : 1;
                }
                if (pA == null || pB == null) {
                    if (this.isNullEqual) continue;
                    return -1;
                }
                int local = pA.compareTo(pB);
                if (local == 0) continue;
                return local;
            }
            return 0;
        }
        try {
            return a.getPath().compareTo(b.getPath());
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to compare rows " + a + " and " + b, e);
        }
    }
}

