/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.core.query.lucene.IndexInfo;
import org.apache.jackrabbit.core.query.lucene.directory.IndexInputStream;
import org.apache.jackrabbit.core.query.lucene.directory.IndexOutputStream;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexInfos
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(IndexInfos.class);
    private static final int NAMES_ONLY = 0;
    private static final int WITH_GENERATION = 1;
    private int counter = 0;
    private LinkedHashMap<String, IndexInfo> indexes = new LinkedHashMap();
    private final Directory directory;
    private final String name;
    private long generation = 0L;
    private long lastModified;

    IndexInfos(Directory dir, String baseName) throws IOException {
        this.directory = dir;
        this.name = baseName;
        long[] gens = IndexInfos.getGenerations(IndexInfos.getFileNames(dir, baseName), baseName);
        if (gens.length == 0) {
            this.write();
        } else {
            for (int i = gens.length - 1; i >= 0; --i) {
                try {
                    this.generation = gens[i];
                    this.read();
                    break;
                }
                catch (EOFException e) {
                    String fileName = this.getFileName(gens[i]);
                    log.warn("deleting invalid index infos file: " + fileName);
                    dir.deleteFile(fileName);
                    this.generation = 0L;
                    continue;
                }
            }
        }
    }

    IndexInfos(Directory dir, String baseName, long generation) throws IOException {
        if (generation < 0L) {
            throw new IllegalArgumentException();
        }
        this.directory = dir;
        this.name = baseName;
        this.generation = generation;
        this.read();
    }

    String getFileName() {
        return this.getFileName(this.generation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write() throws IOException {
        ++this.generation;
        String newName = this.getFileName();
        boolean success = false;
        try {
            try (BufferedOutputStream out = new BufferedOutputStream(new IndexOutputStream(this.directory.createOutput(newName)));){
                log.debug("Writing IndexInfos {}", (Object)newName);
                DataOutputStream dataOut = new DataOutputStream(out);
                dataOut.writeInt(1);
                dataOut.writeInt(this.counter);
                dataOut.writeInt(this.indexes.size());
                Iterator<IndexInfo> it = this.iterator();
                while (it.hasNext()) {
                    IndexInfo info = it.next();
                    dataOut.writeUTF(info.getName());
                    dataOut.writeLong(info.getGeneration());
                    log.debug("  + {}:{}", (Object)info.getName(), (Object)info.getGeneration());
                }
            }
            this.directory.sync(Collections.singleton(newName));
            this.lastModified = System.currentTimeMillis();
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.directory.deleteFile(newName);
                }
                catch (IOException e) {
                    log.warn("Unable to delete file: " + this.directory + "/" + newName);
                }
                --this.generation;
            }
        }
    }

    Iterator<IndexInfo> iterator() {
        return this.indexes.values().iterator();
    }

    int size() {
        return this.indexes.size();
    }

    long getLastModified() {
        return this.lastModified;
    }

    void addName(String name, long generation) {
        if (this.indexes.containsKey(name)) {
            throw new IllegalArgumentException("already contains: " + name);
        }
        this.indexes.put(name, new IndexInfo(name, generation));
    }

    void updateGeneration(String name, long generation) {
        IndexInfo info = this.indexes.get(name);
        if (info == null) {
            throw new NoSuchElementException(name);
        }
        if (info.getGeneration() != generation) {
            info.setGeneration(generation);
        }
    }

    void removeName(String name) {
        this.indexes.remove(name);
    }

    boolean contains(String name) {
        return this.indexes.containsKey(name);
    }

    long getGeneration() {
        return this.generation;
    }

    String newName() {
        return "_" + Integer.toString(this.counter++, 36);
    }

    public IndexInfos clone() {
        try {
            IndexInfos clone = (IndexInfos)super.clone();
            clone.indexes = (LinkedHashMap)this.indexes.clone();
            for (Map.Entry<String, IndexInfo> entry : clone.indexes.entrySet()) {
                entry.setValue(entry.getValue().clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() throws IOException {
        String fileName = this.getFileName(this.generation);
        try (BufferedInputStream in = new BufferedInputStream(new IndexInputStream(this.directory.openInput(fileName)));){
            LinkedHashMap<String, IndexInfo> indexes = new LinkedHashMap<String, IndexInfo>();
            DataInputStream di = new DataInputStream(in);
            int version = this.generation == 0L ? 0 : di.readInt();
            int counter = di.readInt();
            for (int i = di.readInt(); i > 0; --i) {
                String indexName = di.readUTF();
                long gen = 0L;
                if (version >= 1) {
                    gen = di.readLong();
                }
                indexes.put(indexName, new IndexInfo(indexName, gen));
            }
            this.lastModified = this.directory.fileModified(fileName);
            this.indexes = indexes;
            this.counter = counter;
        }
    }

    private String getFileName(long gen) {
        if (gen == 0L) {
            return this.name;
        }
        return this.name + "_" + Long.toString(gen, 36);
    }

    private static String[] getFileNames(Directory directory, String base) {
        String[] names = null;
        try {
            names = directory.listAll();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (names == null) {
            return new String[0];
        }
        ArrayList<String> nameList = new ArrayList<String>(names.length);
        for (String n : names) {
            if (!n.startsWith(base)) continue;
            nameList.add(n);
        }
        return nameList.toArray(new String[nameList.size()]);
    }

    private static long generationFromFileName(String fileName, String base) {
        if (fileName.equals(base)) {
            return 0L;
        }
        return Long.parseLong(fileName.substring(base.length() + 1), 36);
    }

    private static long[] getGenerations(String[] fileNames, String base) {
        long[] gens = new long[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            gens[i] = IndexInfos.generationFromFileName(fileNames[i], base);
        }
        Arrays.sort(gens);
        return gens;
    }
}

