/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import org.apache.jackrabbit.core.cluster.ClusterRecord;
import org.apache.jackrabbit.core.cluster.ClusterRecordProcessor;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.xml.ClonedInputSource;
import org.xml.sax.InputSource;

public class WorkspaceRecord
extends ClusterRecord {
    static final char IDENTIFIER = 'W';
    public static final int CREATE_WORKSPACE_ACTION_TYPE = 1;
    private Action action;

    protected WorkspaceRecord(String workspace, ClonedInputSource inputSource, Record record) {
        super(record, workspace);
        this.action = new CreateWorkspaceAction(inputSource);
    }

    protected WorkspaceRecord(Record record) {
        super(record);
    }

    @Override
    protected void doRead() throws JournalException {
        this.workspace = this.record.readString();
        int action = this.record.readInt();
        if (action == 1) {
            this.action = new CreateWorkspaceAction();
        }
        if (this.action == null) {
            throw new JournalException("Unknown workspace action type");
        }
        this.action.read(this.record);
    }

    @Override
    protected void doWrite() throws JournalException {
        this.record.writeChar('W');
        this.record.writeString(this.workspace);
        this.record.writeInt(this.getActionType());
        if (this.action == null) {
            throw new JournalException("Can not write empty workspace action");
        }
        this.action.write(this.record);
    }

    public int getActionType() {
        return this.action != null ? this.action.getType() : -1;
    }

    public CreateWorkspaceAction getCreateWorkspaceAction() {
        return (CreateWorkspaceAction)this.action;
    }

    @Override
    public void process(ClusterRecordProcessor processor) {
        processor.process(this);
    }

    static final class CreateWorkspaceAction
    extends Action {
        private InputSource inputSource;
        private char[] charArray;
        private byte[] byteArray;

        @Override
        int getType() {
            return 1;
        }

        CreateWorkspaceAction() {
        }

        CreateWorkspaceAction(ClonedInputSource inputSource) {
            this.inputSource = inputSource;
            this.charArray = inputSource.getCharacterArray();
            this.byteArray = inputSource.getByteArray();
        }

        @Override
        void write(Record record) throws JournalException {
            record.writeString(this.inputSource.getEncoding());
            record.writeString(this.inputSource.getPublicId());
            record.writeString(this.inputSource.getSystemId());
            if (this.charArray != null) {
                record.writeBoolean(true);
                record.writeString(new String(this.charArray));
            } else {
                record.writeBoolean(false);
            }
            if (this.byteArray != null) {
                record.writeBoolean(true);
                record.writeInt(this.byteArray.length);
                record.write(this.byteArray);
            } else {
                record.writeBoolean(false);
            }
        }

        @Override
        void read(Record record) throws JournalException {
            this.inputSource = new InputSource();
            this.inputSource.setEncoding(record.readString());
            this.inputSource.setPublicId(record.readString());
            this.inputSource.setSystemId(record.readString());
            if (record.readBoolean()) {
                this.charArray = record.readString().toCharArray();
                this.inputSource.setCharacterStream(new CharArrayReader(this.charArray));
            }
            if (record.readBoolean()) {
                int size = record.readInt();
                this.byteArray = new byte[size];
                record.readFully(this.byteArray);
                this.inputSource.setByteStream(new ByteArrayInputStream(this.byteArray));
            }
        }

        public InputSource getInputSource() {
            return this.inputSource;
        }
    }

    public static abstract class Action {
        abstract int getType();

        abstract void write(Record var1) throws JournalException;

        abstract void read(Record var1) throws JournalException;
    }
}

