/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.patch;

import edu.psu.swe.commons.jaxrs.patch.ArrayIndex;
import edu.psu.swe.commons.jaxrs.patch.JsonPointerListener;
import edu.psu.swe.commons.jaxrs.patch.JsonPointerParser;
import edu.psu.swe.commons.jaxrs.patch.JsonReference;
import edu.psu.swe.commons.jaxrs.patch.PropertyName;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class JsonPointerBuilder
implements JsonPointerListener {
    List<Object> path = new ArrayList<Object>();

    public void visitTerminal(TerminalNode node) {
    }

    public void visitErrorNode(ErrorNode node) {
    }

    public void enterEveryRule(ParserRuleContext ctx) {
    }

    public void exitEveryRule(ParserRuleContext ctx) {
    }

    @Override
    public void enterJsonPointer(JsonPointerParser.JsonPointerContext ctx) {
    }

    @Override
    public void exitJsonPointer(JsonPointerParser.JsonPointerContext ctx) {
    }

    @Override
    public void enterReferenceToken(JsonPointerParser.ReferenceTokenContext ctx) {
    }

    @Override
    public void exitReferenceToken(JsonPointerParser.ReferenceTokenContext ctx) {
        String name = ctx.reference.getText().replace("~1", "/").replace("~0", "~");
        this.path.add(name);
    }

    @Override
    public void enterArrayIndex(JsonPointerParser.ArrayIndexContext ctx) {
    }

    @Override
    public void exitArrayIndex(JsonPointerParser.ArrayIndexContext ctx) {
        int arrayIndex = Integer.parseInt(ctx.index.getText());
        this.path.add(arrayIndex);
    }

    @Override
    public void enterEndOfArray(JsonPointerParser.EndOfArrayContext ctx) {
    }

    @Override
    public void exitEndOfArray(JsonPointerParser.EndOfArrayContext ctx) {
        int arrayIndex = -1;
        this.path.add(arrayIndex);
    }

    public JsonReference build() {
        return this.build(0);
    }

    private JsonReference build(int index) {
        JsonReference jsonReference;
        if (index < this.path.size()) {
            Object pathPart = this.path.get(index);
            JsonReference next = this.build(index + 1);
            jsonReference = pathPart instanceof String ? new PropertyName((String)pathPart, next) : new ArrayIndex((Integer)pathPart, next);
        } else {
            jsonReference = null;
        }
        return jsonReference;
    }
}

