/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.process.media;

import java.util.Collection;
import java.util.Date;
import org.silverpeas.components.gallery.model.InternalMedia;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.MetaData;
import org.silverpeas.components.gallery.model.Photo;
import org.silverpeas.components.gallery.process.AbstractGalleryDataProcess;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.process.management.ProcessExecutionContext;
import org.silverpeas.core.process.session.ProcessSession;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.logging.SilverLogger;

public class GalleryIndexMediaDataProcess
extends AbstractGalleryDataProcess {
    protected GalleryIndexMediaDataProcess(Media media) {
        super(media);
    }

    public static GalleryIndexMediaDataProcess getInstance(Media media) {
        return new GalleryIndexMediaDataProcess(media);
    }

    @Override
    protected void processData(ProcessExecutionContext context, ProcessSession session) {
    }

    public void onSuccessful() {
        if (this.getMedia() != null) {
            String xmlFormName;
            FullIndexEntry indexEntry = this.setUpIndexEntry();
            if (this.getMedia().getVisibilityPeriod().getBeginDatable().isDefined()) {
                indexEntry.setStartDate((Date)this.getMedia().getVisibilityPeriod().getBeginDatable());
            }
            if (this.getMedia().getVisibilityPeriod().getEndDatable().isDefined()) {
                indexEntry.setEndDate((Date)this.getMedia().getVisibilityPeriod().getEndDatable());
            }
            if (this.getMedia() instanceof InternalMedia) {
                this.setThumbnailData(indexEntry);
            }
            if (this.getMedia() instanceof Photo) {
                this.setPhotoMetadata(indexEntry);
            }
            if (StringUtil.isDefined((String)(xmlFormName = this.getOrganisationController().getComponentParameterValue(this.getMedia().getInstanceId(), "XMLFormName")))) {
                String xmlFormShortName = xmlFormName.substring(xmlFormName.indexOf("/") + 1, xmlFormName.indexOf("."));
                try {
                    PublicationTemplate pubTemplate = PublicationTemplateManager.getInstance().getPublicationTemplate(this.getMedia().getInstanceId() + ":" + xmlFormShortName);
                    RecordSet set = pubTemplate.getRecordSet();
                    set.indexRecord(this.getMedia().getMediaPK().getId(), xmlFormShortName, indexEntry);
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)((Object)this)).warn((Throwable)e);
                }
            }
            IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
        }
    }

    private void setPhotoMetadata(FullIndexEntry indexEntry) {
        String value;
        MetaData metaData;
        Photo photo = (Photo)this.getMedia();
        StringBuilder metaDataStr = new StringBuilder();
        Collection<String> properties = photo.getMetaDataProperties();
        for (String property : properties) {
            metaData = photo.getMetaData(property);
            value = metaData.getValue();
            metaDataStr.append(" ").append(value);
        }
        indexEntry.addTextContent(metaDataStr.toString());
        for (String property : properties) {
            metaData = photo.getMetaData(property);
            value = metaData.getValue();
            if (metaData.isDate()) {
                indexEntry.addField("IPTC_" + property, metaData.getDateValue());
                continue;
            }
            indexEntry.addField("IPTC_" + property, value);
        }
    }

    private void setThumbnailData(FullIndexEntry indexEntry) {
        InternalMedia iMedia = (InternalMedia)this.getMedia();
        if (StringUtil.isDefined((String)iMedia.getFileName())) {
            indexEntry.setThumbnail(iMedia.getFileName());
            indexEntry.setThumbnailMimeType(iMedia.getFileMimeType().getMimeType());
            indexEntry.setThumbnailDirectory(this.getMedia().getWorkspaceSubFolderName());
        }
    }

    private FullIndexEntry setUpIndexEntry() {
        FullIndexEntry indexEntry = new FullIndexEntry(this.getMedia().getMediaPK().getComponentName(), this.getMedia().getContributionType(), this.getMedia().getMediaPK().getId());
        indexEntry.setTitle(this.getMedia().getTitle());
        indexEntry.setPreview(this.getMedia().getDescription());
        indexEntry.setCreationDate(this.getMedia().getCreationDate());
        indexEntry.setCreationUser(this.getMedia().getCreatorId());
        indexEntry.setKeywords(this.getMedia().getKeyWord());
        return indexEntry;
    }
}

