/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.blog.notification;

import javax.inject.Named;
import org.silverpeas.components.blog.model.PostDetail;
import org.silverpeas.components.blog.notification.BlogUserAlertNotification;
import org.silverpeas.components.blog.service.BlogService;
import org.silverpeas.core.NotFoundException;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.notification.user.AbstractComponentInstanceManualUserNotification;
import org.silverpeas.core.notification.user.NotificationContext;
import org.silverpeas.core.notification.user.UserNotification;

@Named
public class BlogInstanceManualUserNotification
extends AbstractComponentInstanceManualUserNotification {
    private static final String POST_KEY = "PostDetailKey";

    protected boolean check(NotificationContext context) {
        String postId = context.getContributionId();
        String instanceId = context.getComponentId();
        ContributionIdentifier identifier = ContributionIdentifier.from((String)instanceId, (String)postId, (String)PostDetail.getResourceType());
        PostDetail post = this.getPost(identifier);
        context.put((Object)POST_KEY, (Object)post);
        return post.canBeAccessedBy(context.getSender());
    }

    public UserNotification createUserNotification(NotificationContext context) {
        PostDetail post = (PostDetail)context.getObject((Object)POST_KEY);
        context.put((Object)"publicationId", (Object)post.getPublication().getId());
        return new BlogUserAlertNotification(post, context.getSender()).build();
    }

    private PostDetail getPost(ContributionIdentifier postId) {
        return BlogService.get().getContributionById(postId).orElseThrow(() -> new NotFoundException("No such post " + postId.asString()));
    }
}

