/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.forums.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.silverpeas.components.forums.model.ForumPK;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.rating.model.ContributionRating;
import org.silverpeas.core.contribution.rating.model.ContributionRatingPK;
import org.silverpeas.core.contribution.rating.model.Rateable;
import org.silverpeas.core.contribution.rating.service.RatingService;

public class Forum
implements Contribution,
Rateable,
Serializable {
    public static final String RESOURCE_TYPE = "Forum";
    private static final long serialVersionUID = -2933341803291325081L;
    private int id;
    private String name;
    private String description;
    private boolean active;
    private int parentId;
    private String category;
    private Date creationDate;
    private String instanceId;
    private ForumPK pk;
    private ContributionRating contributionRating;

    public Forum(int id, String instanceId, String name, String description, boolean active, int parentId, String category) {
        this.id = id;
        this.instanceId = instanceId;
        this.name = name;
        this.description = description;
        this.active = active;
        this.parentId = parentId;
        this.category = category;
        this.pk = new ForumPK(instanceId, String.valueOf(id));
    }

    public int getId() {
        return this.id;
    }

    public String getIdAsString() {
        return String.valueOf(this.id);
    }

    public void setId(int id) {
        this.id = id;
    }

    public ContributionIdentifier getIdentifier() {
        return ContributionIdentifier.from((String)this.getInstanceId(), (String)this.getIdAsString(), (String)RESOURCE_TYPE);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int getParentId() {
        return this.parentId;
    }

    public String getParentIdAsString() {
        return String.valueOf(this.parentId);
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getLastUpdateDate() {
        return this.getCreationDate();
    }

    public User getCreator() {
        return User.getById((String)"0");
    }

    public User getLastUpdater() {
        return this.getCreator();
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public ForumPK getPk() {
        return this.pk;
    }

    public void setPk(ForumPK pk) {
        this.pk = pk;
    }

    public boolean isRoot() {
        return this.parentId == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Forum forum = (Forum)o;
        if (this.active != forum.active) {
            return false;
        }
        if (this.id != forum.id) {
            return false;
        }
        if (this.parentId != forum.parentId) {
            return false;
        }
        if (!Objects.equals(this.category, forum.category)) {
            return false;
        }
        if (!Objects.equals(this.creationDate, forum.creationDate)) {
            return false;
        }
        if (!Objects.equals(this.description, forum.description)) {
            return false;
        }
        if (!Objects.equals(this.instanceId, forum.instanceId)) {
            return false;
        }
        if (!Objects.equals(this.name, forum.name)) {
            return false;
        }
        return Objects.equals((Object)this.pk, (Object)forum.pk);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.active ? 1 : 0);
        result = 31 * result + this.parentId;
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        result = 31 * result + (this.creationDate != null ? this.creationDate.hashCode() : 0);
        result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        result = 31 * result + (this.pk != null ? this.pk.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Forum{id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", active=" + this.active + ", parentId=" + this.parentId + ", category=" + this.category + ", creationDate=" + this.creationDate + ", instanceId=" + this.instanceId + ", pk=" + this.pk + "}";
    }

    public ContributionRating getRating() {
        if (this.contributionRating == null) {
            this.contributionRating = RatingService.get().getRating(new ContributionRatingPK(String.valueOf(this.id), this.getInstanceId(), RESOURCE_TYPE));
        }
        return this.contributionRating;
    }
}

