/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.rssaggregator.model;

import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndImage;
import java.io.Serializable;
import java.util.Date;
import java.util.Random;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.components.rssaggregator.model.SPChannel;

public class RSSItem
implements Serializable,
Comparable<RSSItem> {
    private static final long serialVersionUID = -1235557051682143463L;
    private String itemTitle;
    private String itemDescription;
    private String itemLink;
    private Date itemDate;
    private String itemComments;
    private Long channelId;
    private Long externalChannelId;
    private String channelTitle;
    private String channelDescription;
    private SyndImage channelImage;
    private String channelUrl;
    private int nbDisplayedItems;

    public RSSItem(SyndEntry item, SyndFeed feed, SPChannel spChannel) {
        this.itemTitle = item.getTitle();
        this.itemDescription = item.getDescription() != null ? item.getDescription().getValue() : null;
        this.itemLink = item.getLink() == null ? item.getUri() : item.getLink();
        this.itemDate = item.getUpdatedDate() == null ? item.getPublishedDate() : item.getUpdatedDate();
        this.itemComments = item.getComments();
        this.externalChannelId = IdGenerator.GENERATOR.getId();
        this.channelTitle = feed.getTitle();
        this.channelImage = feed.getImage();
        this.channelDescription = feed.getDescription();
        this.channelId = Long.parseLong(spChannel.getPK().getId());
        this.channelUrl = spChannel.getUrl();
        this.nbDisplayedItems = spChannel.getNbDisplayedItems();
    }

    public String getItemTitle() {
        return this.itemTitle;
    }

    public String getItemDescription() {
        return this.itemDescription;
    }

    public String getItemLink() {
        return this.itemLink;
    }

    public Date getItemDate() {
        return this.itemDate != null ? (Date)this.itemDate.clone() : null;
    }

    public String getItemComments() {
        return this.itemComments;
    }

    public Long getExternalChannelId() {
        return this.externalChannelId;
    }

    public String getChannelTitle() {
        return this.channelTitle;
    }

    public String getChannelDescription() {
        return this.channelDescription;
    }

    public SyndImage getChannelImage() {
        return this.channelImage;
    }

    public Long getChannelId() {
        return this.channelId;
    }

    public String getChannelUrl() {
        return this.channelUrl;
    }

    public int getNbDisplayedItems() {
        return this.nbDisplayedItems;
    }

    @Override
    public int compareTo(RSSItem other) {
        if (this.getItemDate() != null && other.getItemDate() != null) {
            return other.getItemDate().compareTo(this.getItemDate());
        }
        if (this.getItemDate() == null && other.getItemDate() != null) {
            return 1;
        }
        if (this.getItemDate() != null && other.getItemDate() == null) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RSSItem)) {
            return false;
        }
        RSSItem rssItem = (RSSItem)o;
        if (this.itemTitle != null ? !this.itemTitle.equals(rssItem.itemTitle) : rssItem.itemTitle != null) {
            return false;
        }
        if (this.channelId != null ? !this.channelId.equals(rssItem.channelId) : rssItem.channelId != null) {
            return false;
        }
        return this.compareTo(rssItem) == 0;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.itemTitle).append((Object)this.channelId).append((Object)this.itemDate).toHashCode();
    }

    private static class IdGenerator {
        public static final IdGenerator GENERATOR = new IdGenerator();
        private static final long SEED = 100000L;
        private final Random rand = new Random(System.currentTimeMillis());

        private IdGenerator() {
        }

        public long getId() {
            return 100000L + this.rand.nextLong();
        }
    }
}

