/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.cache.GrowingLRUMap;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.security.authorization.AccessControlModifications;
import org.apache.jackrabbit.core.security.authorization.acl.ACLProvider;
import org.apache.jackrabbit.core.security.authorization.acl.EntryCollector;
import org.gradle.internal.classpath.Instrumented;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachingEntryCollector
extends EntryCollector {
    private static final Logger log = LoggerFactory.getLogger(CachingEntryCollector.class);
    private final EntryCache cache;
    private ConcurrentMap<NodeId, FutureEntries> futures = new ConcurrentHashMap<NodeId, FutureEntries>();
    private final String strategy;
    private final boolean cacheNoAcl;

    CachingEntryCollector(SessionImpl systemSession, NodeId rootID) throws RepositoryException {
        super(systemSession, rootID);
        this.cache = new EntryCache();
        String propname = "org.apache.jackrabbit.core.security.authorization.acl.CachingEntryCollector.strategy";
        this.strategy = Instrumented.systemProperty((String)propname, (String)"T", (String)"org.apache.jackrabbit.core.security.authorization.acl.CachingEntryCollector");
        if (!("S".equals(this.strategy) || "T".equals(this.strategy) || "P".equals(this.strategy))) {
            throw new RepositoryException("Invalid value " + this.strategy + " specified for system property " + propname);
        }
        log.info("Cache Update Strategy: " + this.strategy);
        propname = "org.apache.jackrabbit.core.security.authorization.acl.CachingEntryCollector.cacheNoACL";
        this.cacheNoAcl = Boolean.parseBoolean(Instrumented.systemProperty((String)propname, (String)"false", (String)"org.apache.jackrabbit.core.security.authorization.acl.CachingEntryCollector"));
        log.info("Caching entries with no ACLs: " + this.cacheNoAcl);
    }

    @Override
    protected void close() {
        super.close();
        this.cache.clear();
    }

    @Override
    protected EntryCollector.Entries getEntries(NodeImpl node) throws RepositoryException {
        NodeId nodeId = node.getNodeId();
        EntryCollector.Entries entries = this.cache.get(nodeId);
        if (entries == null) {
            entries = this.updateCache(node);
        }
        return entries;
    }

    @Override
    protected EntryCollector.Entries getEntries(NodeId nodeId) throws RepositoryException {
        EntryCollector.Entries entries = this.cache.get(nodeId);
        if (entries == null) {
            NodeImpl n = this.getNodeById(nodeId);
            entries = this.updateCache(n);
        }
        return entries;
    }

    private EntryCollector.Entries internalUpdateCache(NodeImpl node) throws RepositoryException {
        EntryCollector.Entries entries = super.getEntries(node);
        if (this.cacheNoAcl || this.isRootId(node.getNodeId()) && this.cache.specialCasesRoot() || !entries.isEmpty()) {
            entries.setNextId(this.getNextID(node));
            this.cache.put(node.getNodeId(), entries);
        }
        return entries;
    }

    private EntryCollector.Entries updateCache(NodeImpl node) throws RepositoryException {
        if ("T".equals(this.strategy)) {
            return this.throttledUpdateCache(node);
        }
        if ("S".equals(this.strategy)) {
            return this.synchronizedUpdateCache(node);
        }
        if ("P".equals(this.strategy)) {
            return this.parallelUpdateCache(node);
        }
        throw new RuntimeException("invalid value for updateCacheStrategy: " + this.strategy);
    }

    private synchronized EntryCollector.Entries synchronizedUpdateCache(NodeImpl node) throws RepositoryException {
        return this.internalUpdateCache(node);
    }

    private EntryCollector.Entries parallelUpdateCache(NodeImpl node) throws RepositoryException {
        return this.internalUpdateCache(node);
    }

    private EntryCollector.Entries throttledUpdateCache(NodeImpl node) throws RepositoryException {
        NodeId id = node.getNodeId();
        FutureEntries fe = null;
        FutureEntries nfe = new FutureEntries();
        boolean found = true;
        fe = this.futures.putIfAbsent(id, nfe);
        if (fe == null) {
            found = false;
            fe = nfe;
        }
        if (found) {
            return fe.get();
        }
        try {
            EntryCollector.Entries e = this.internalUpdateCache(node);
            this.futures.remove(id);
            fe.setResult(e);
            return e;
        }
        catch (Throwable problem) {
            this.futures.remove(id);
            fe.setProblem(problem);
            if (problem instanceof RepositoryException) {
                throw (RepositoryException)problem;
            }
            throw new RuntimeException(problem);
        }
    }

    private NodeId getNextID(NodeImpl node) throws RepositoryException {
        NodeImpl n = node;
        NodeId nextId = null;
        while (nextId == null && !this.isRootId(n.getNodeId())) {
            NodeId parentId = n.getParentId();
            if (this.cache.containsKey(parentId)) {
                nextId = parentId;
                continue;
            }
            NodeImpl parent = (NodeImpl)n.getParent();
            if (CachingEntryCollector.hasEntries(parent)) {
                nextId = parentId;
                continue;
            }
            n = parent;
        }
        return nextId;
    }

    private boolean isRootId(NodeId nodeId) {
        return this.rootID.equals(nodeId);
    }

    private static boolean hasEntries(NodeImpl n) throws RepositoryException {
        if (ACLProvider.isAccessControlled(n)) {
            NodeImpl aclNode = n.getNode(N_POLICY);
            return aclNode.hasNodes();
        }
        return false;
    }

    @Override
    public void notifyListeners(AccessControlModifications modifications) {
        for (Object key : modifications.getNodeIdentifiers()) {
            if (!(key instanceof NodeId)) {
                log.warn("Cannot process AC modificationMap entry. Keys must be NodeId.");
                continue;
            }
            NodeId nodeId = (NodeId)key;
            int type = modifications.getType(nodeId);
            if ((type & 1) == 1) {
                log.debug("Policy added, clearing the cache");
                this.cache.clear();
                break;
            }
            if ((type & 2) == 2) {
                this.cache.remove(nodeId, true);
                continue;
            }
            if ((type & 4) == 4) {
                this.cache.remove(nodeId, false);
                continue;
            }
            if ((type & 8) != 8) continue;
            log.debug("Move operation, clearing the cache");
            this.cache.clear();
            break;
        }
        super.notifyListeners(modifications);
    }

    private class EntryCache {
        private final Map<NodeId, EntryCollector.Entries> cache;
        private EntryCollector.Entries rootEntries;
        private boolean specialCaseRoot = true;

        public EntryCache() {
            int maxsize = 5000;
            String propname = "org.apache.jackrabbit.core.security.authorization.acl.CachingEntryCollector.maxsize";
            try {
                maxsize = Integer.parseInt(Instrumented.systemProperty((String)propname, (String)Integer.toString(maxsize), (String)"org.apache.jackrabbit.core.security.authorization.acl.CachingEntryCollector$EntryCache"));
            }
            catch (NumberFormatException ex) {
                log.debug("Parsing system property " + propname + " with value: " + Instrumented.systemProperty((String)propname, (String)"org.apache.jackrabbit.core.security.authorization.acl.CachingEntryCollector$EntryCache"), (Throwable)ex);
            }
            log.info("Creating cache with max size of: " + maxsize);
            this.cache = new GrowingLRUMap(1024, maxsize);
            String propsrname = "org.apache.jackrabbit.core.security.authorization.acl.CachingEntryCollector.scroot";
            this.specialCaseRoot = Boolean.parseBoolean(Instrumented.systemProperty((String)propsrname, (String)"true", (String)"org.apache.jackrabbit.core.security.authorization.acl.CachingEntryCollector$EntryCache"));
            log.info("Root is special-cased: " + this.specialCaseRoot);
        }

        public boolean specialCasesRoot() {
            return this.specialCaseRoot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(NodeId id) {
            if (this.specialCaseRoot && CachingEntryCollector.this.isRootId(id)) {
                return this.rootEntries != null;
            }
            Map<NodeId, EntryCollector.Entries> map = this.cache;
            synchronized (map) {
                return this.cache.containsKey(id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            this.rootEntries = null;
            Map<NodeId, EntryCollector.Entries> map = this.cache;
            synchronized (map) {
                this.cache.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EntryCollector.Entries get(NodeId id) {
            EntryCollector.Entries result;
            if (this.specialCaseRoot && CachingEntryCollector.this.isRootId(id)) {
                result = this.rootEntries;
            } else {
                Map<NodeId, EntryCollector.Entries> map = this.cache;
                synchronized (map) {
                    result = this.cache.get(id);
                }
            }
            if (result != null) {
                log.debug("Cache hit for nodeId {}", (Object)id);
            } else {
                log.debug("Cache miss for nodeId {}", (Object)id);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(NodeId id, EntryCollector.Entries entries) {
            log.debug("Updating cache for nodeId {}", (Object)id);
            if (id.equals(entries.getNextId())) {
                throw new IllegalArgumentException("Trying to update cache entry for " + id + " with a circular reference");
            }
            if (this.specialCaseRoot && CachingEntryCollector.this.isRootId(id)) {
                this.rootEntries = entries;
            } else {
                Map<NodeId, EntryCollector.Entries> map = this.cache;
                synchronized (map) {
                    this.cache.put(id, entries);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(NodeId id, boolean adjustNextIds) {
            log.debug("Removing nodeId {} from cache", (Object)id);
            Map<NodeId, EntryCollector.Entries> map = this.cache;
            synchronized (map) {
                EntryCollector.Entries result;
                if (this.specialCaseRoot && CachingEntryCollector.this.isRootId(id)) {
                    result = this.rootEntries;
                    this.rootEntries = null;
                } else {
                    result = this.cache.remove(id);
                }
                if (adjustNextIds && result != null) {
                    NodeId nextId = result.getNextId();
                    for (EntryCollector.Entries entry : this.cache.values()) {
                        if (!id.equals(entry.getNextId())) continue;
                        if (id.equals(nextId)) {
                            throw new IllegalArgumentException("Trying to update cache entry for " + id + " with a circular reference");
                        }
                        entry.setNextId(nextId);
                    }
                }
            }
        }
    }

    private class FutureEntries {
        private boolean ready = false;
        private EntryCollector.Entries result = null;
        private Throwable problem = null;

        private FutureEntries() {
        }

        public synchronized EntryCollector.Entries get() throws RepositoryException {
            while (!this.ready) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.problem != null) {
                if (this.problem instanceof RepositoryException) {
                    throw new RepositoryException(this.problem);
                }
                throw new RuntimeException(this.problem);
            }
            return this.result;
        }

        public synchronized void setResult(EntryCollector.Entries e) {
            this.result = e;
            this.ready = true;
            this.notifyAll();
        }

        public synchronized void setProblem(Throwable t) {
            this.problem = t;
            this.ready = true;
            this.notifyAll();
        }
    }
}

