/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.whitepages.control;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.silverpeas.components.whitepages.WhitePagesException;
import org.silverpeas.components.whitepages.control.CardHeader;
import org.silverpeas.components.whitepages.control.CardManager;
import org.silverpeas.components.whitepages.model.Card;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.contentcontainer.content.AbstractSilverpeasContentManager;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentVisibility;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.persistence.jdbc.bean.IdPK;
import org.silverpeas.core.util.logging.SilverLogger;

@Service
public class WhitePagesContentManager
extends AbstractSilverpeasContentManager {
    private static final String CONTENT_ICON_FILE_NAME = "whitePagesSmall.gif";

    protected WhitePagesContentManager() {
    }

    protected String getContentIconFileName(String componentInstanceId) {
        return CONTENT_ICON_FILE_NAME;
    }

    protected Optional<Contribution> getContribution(String resourceId, String componentInstanceId) {
        List<Contribution> contributions = this.getAccessibleContributions(Collections.singletonList(new ResourceReference(resourceId, componentInstanceId)), null);
        return contributions.isEmpty() ? Optional.empty() : Optional.of(contributions.get(0));
    }

    protected List<Contribution> getAccessibleContributions(List<ResourceReference> resourceReferences, String currentUserId) {
        try {
            List<String> resourceIds = resourceReferences.stream().map(ResourceReference::getLocalId).collect(Collectors.toList());
            return CardManager.getInstance().getCardsByIds(resourceIds).stream().map(c -> new CardHeader(Long.parseLong(c.getPK().getId()), (Card)((Object)c), c.getInstanceId(), c.getCreationDate(), Integer.toString(c.getCreatorId()))).collect(Collectors.toList());
        }
        catch (WhitePagesException e) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)((Object)e));
            return Collections.emptyList();
        }
    }

    protected int createSilverContent(Connection con, Card card) throws ContentManagerException {
        SilverContentVisibility scv = new SilverContentVisibility(this.isVisible(card));
        return this.getContentManager().addSilverContent(con, card.getPK().getId(), card.getInstanceId(), card.getUserId(), scv);
    }

    protected void updateSilverContentVisibility(Card card) throws ContentManagerException {
        int silverContentId = this.getContentManager().getSilverContentId(card.getPK().getId(), card.getPK().getComponentName());
        SilverContentVisibility scv = new SilverContentVisibility(this.isVisible(card));
        this.getContentManager().updateSilverContentVisibilityAttributes(scv, silverContentId);
    }

    protected void deleteSilverContent(Connection con, IdPK pk) throws ContentManagerException {
        this.deleteSilverContent(con, pk.getId(), pk.getComponentName());
    }

    private boolean isVisible(Card card) {
        return card.getHideStatus() == 0;
    }
}

