/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.processmanager;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.SilverpeasRuntimeException;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.Form;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.filter.FilterManager;
import org.silverpeas.core.contribution.content.form.filter.RecordFilter;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.util.logging.SilverLogger;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.model.ProcessModel;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.processmanager.ProcessManagerException;

public class ProcessFilter {
    private static final String PROCESS_FILTER = "ProcessFilter";
    private static final String FAIL_TO_CREATE_CRITERIA_FORM = "processFilter.FAIL_TO_CREATE_CRITERIA_FORM";
    private final FilterManager filter;
    private boolean collapse = false;
    private DataRecord criteria;

    public ProcessFilter(ProcessModel model, String role, String lang) throws ProcessManagerException {
        RecordTemplate rowTemplate = model.getRowTemplate(role, lang);
        this.filter = new FilterManager(rowTemplate, lang);
        RecordTemplate folderTemplate = null;
        try {
            folderTemplate = model.getDataFolder().toRecordTemplate(role, lang, false);
        }
        catch (WorkflowException e1) {
            throw new ProcessManagerException(PROCESS_FILTER, FAIL_TO_CREATE_CRITERIA_FORM, (Exception)((Object)e1));
        }
        try {
            GenericFieldTemplate state = new GenericFieldTemplate("instance.state", "text");
            State[] states = model.getStates();
            StringBuilder values = new StringBuilder();
            for (int s = 0; s < states.length; ++s) {
                if (s != 0) {
                    values.append("##");
                }
                values.append(states[s].getLabel(role, lang));
            }
            state.addParameter("keys", values.toString());
            this.filter.addFieldParameter("instance.state", (FieldTemplate)state);
            FieldTemplate[] fields = rowTemplate.getFieldTemplates();
            for (int f = 2; f < fields.length; ++f) {
                FieldTemplate field = fields[f];
                FieldTemplate folderField = folderTemplate.getFieldTemplate(field.getFieldName());
                Map parameters = folderField.getParameters(lang);
                if (parameters == null || !parameters.containsKey("values") && !parameters.containsKey("keys") && !"jdbc".equals(folderField.getTypeName())) continue;
                this.filter.addFieldParameter(field.getFieldName(), folderField);
            }
        }
        catch (FormException e) {
            throw new ProcessManagerException(PROCESS_FILTER, FAIL_TO_CREATE_CRITERIA_FORM, (Exception)((Object)e));
        }
    }

    public Form getPresentationForm() throws ProcessManagerException {
        try {
            return this.filter.getCriteriaForm();
        }
        catch (FormException e) {
            throw new ProcessManagerException(PROCESS_FILTER, FAIL_TO_CREATE_CRITERIA_FORM, (Exception)((Object)e));
        }
    }

    public DataRecord getCriteriaRecord() throws ProcessManagerException {
        if (this.criteria == null) {
            try {
                this.criteria = this.filter.getEmptyCriteriaRecord();
            }
            catch (FormException e) {
                throw new ProcessManagerException(PROCESS_FILTER, "processFilter.FAIL_TO_CREATE_CRITERIA_RECORD", (Exception)((Object)e));
            }
        }
        return this.criteria;
    }

    public void setCriteriaRecord(DataRecord criteria) {
        this.criteria = criteria;
    }

    void copySharedCriteria(ProcessFilter source) {
        DataRecord copiedCriteria = null;
        String[] criteriaNames = null;
        try {
            copiedCriteria = source.getCriteriaRecord();
            criteriaNames = source.filter.getCriteriaTemplate().getFieldNames();
            this.getCriteriaRecord();
        }
        catch (FormException | ProcessManagerException e) {
            SilverLogger.getLogger((Object)this).silent((Throwable)e);
            return;
        }
        for (int i = 0; i < criteriaNames.length; ++i) {
            try {
                Field criteriumField = this.criteria.getField(criteriaNames[i]);
                if (criteriumField == null || copiedCriteria == null) continue;
                criteriumField.setValue(copiedCriteria.getField(criteriaNames[i]).getValue(""), "");
                continue;
            }
            catch (FormException e) {
                SilverLogger.getLogger((Object)this).silent((Throwable)e);
            }
        }
    }

    public boolean isCollapse() {
        return this.collapse;
    }

    public void setCollapse(boolean collapse) {
        this.collapse = collapse;
    }

    public List<DataRecord> filter(List<ProcessInstance> allInstances, String role, String lang) throws ProcessManagerException {
        try {
            Stream<DataRecord> stream = allInstances.stream().map(p -> this.getDataRecord((ProcessInstance)p, role, lang));
            if (this.getCriteriaRecord() != null) {
                RecordFilter recordFilter = this.filter.getRecordFilter(this.getCriteriaRecord());
                stream = stream.filter(d -> this.matchCriteria(recordFilter, (DataRecord)d));
            }
            return stream.collect(Collectors.toList());
        }
        catch (SilverpeasRuntimeException | FormException e) {
            throw new ProcessManagerException(PROCESS_FILTER, "processFilter.FAIL_TO_USE_CRITERIA_RECORD", (Exception)e);
        }
    }

    private boolean matchCriteria(RecordFilter recordFilter, DataRecord dataRecord) {
        try {
            return recordFilter.match(dataRecord);
        }
        catch (FormException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    private DataRecord getDataRecord(ProcessInstance p, String role, String lang) {
        try {
            return p.getRowDataRecord(role, lang);
        }
        catch (WorkflowException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }
}

