/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.viewer.model;

import org.silverpeas.core.io.temp.TemporaryDataManagementSetting;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.SettingBundle;
import org.silverpeas.core.viewer.service.JsonPdfToolManager;

public class ViewerSettings {
    protected static SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.viewer.viewer");

    private ViewerSettings() {
        throw new IllegalStateException("Utility class");
    }

    public static int getPreviewMaxWidth() {
        return settings.getInteger("preview.width.max", 500);
    }

    public static int getPreviewMaxHeight() {
        return settings.getInteger("preview.height.max", 500);
    }

    public static boolean pdfViewerEnabled() {
        return settings.getBoolean("pdf.viewer.enabled", true);
    }

    public static String getLicenceKey() {
        return settings.getString("flexpaper.licenseKey", "");
    }

    public static boolean isCacheEnabled() {
        return settings.getBoolean("viewer.cache.enabled", true);
    }

    public static boolean isSplitStrategyEnabled() {
        return settings.getBoolean("viewer.conversion.strategy.split.enabled", true) && JsonPdfToolManager.isActivated();
    }

    public static boolean isSilentConversionEnabled() {
        return ViewerSettings.isCacheEnabled() && settings.getBoolean("viewer.cache.conversion.silent.enabled", true);
    }

    public static boolean isTimeToLiveEnabled() {
        return ViewerSettings.isCacheEnabled() && TemporaryDataManagementSetting.getTimeAfterThatFilesMustBeDeleted() >= 0L && settings.getBoolean("viewer.cache.timeToLive.enabled", true);
    }

    public static int nbMaxConversionsAtSameInstant() {
        return settings.getInteger("viewer.conversion.nb.max", 3);
    }
}

