/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.workflowextensions;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import net.htmlparser.jericho.Source;
import org.silverpeas.components.kmelia.service.KmeliaService;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.attachment.AttachmentException;
import org.silverpeas.core.contribution.attachment.AttachmentService;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.DataRecordUtil;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldDisplayer;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.Form;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.TypeManager;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.WysiwygFCKFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.ExplorerField;
import org.silverpeas.core.contribution.content.form.field.FileField;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateImpl;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.OperationContext;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.logging.SilverLogger;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.instance.HistoryStep;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.instance.UpdatableProcessInstance;
import org.silverpeas.core.workflow.api.model.Action;
import org.silverpeas.core.workflow.api.model.Parameter;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.external.impl.ExternalActionImpl;

@Named(value="SendInKmeliaHandler")
public class SendInKmelia
extends ExternalActionImpl {
    private static final String UNKNOWN = "unknown";
    @Inject
    private NodeService nodeService;
    @Inject
    private KmeliaService kmeliaService;

    public void execute() {
        String role = this.getEvent().getUserRoleName();
        String userId = OperationContext.getFromCache().getUser().getId();
        Parameter parameter = this.getTriggerParameter("explorerFieldName");
        Target target = new Target(role, userId, parameter).invoke();
        String targetId = target.getTargetId();
        String topicId = target.getTopicId();
        String pubTitle = this.getPublicationTitle();
        String pubDesc = this.getPublicationDescription();
        String xmlFormName = this.getXmlFormName();
        boolean formIsUsed = StringUtil.isDefined((String)xmlFormName);
        PdfHistory pdfHistory = new PdfHistory().invoke();
        boolean isHistoryEnable = pdfHistory.isEnable();
        boolean isHistoryFirstAdding = pdfHistory.isFirstAdding();
        String pdfHistoryName = pdfHistory.getFileName();
        PublicationPK pubPK = new PublicationPK("0", targetId);
        Date now = new Date();
        String pubName = this.getProcessInstance().getTitle(role, this.getLanguage());
        pubName = this.applySubstitution(role, pubTitle, pubName);
        String desc = "";
        desc = this.applySubstitution(role, pubDesc, desc);
        PublicationDetail pubDetail = PublicationDetail.builder((String)this.getLanguage()).setPk(pubPK).setNameAndDescription(pubName, desc).created(now, userId).setBeginDateTime(now, null).setImportance(1).build();
        if (formIsUsed) {
            pubDetail.setInfoId(xmlFormName);
        }
        KmeliaService kmelia = this.getKmeliaService();
        NodePK nodePK = new NodePK(topicId, targetId);
        String pubId = kmelia.createPublicationIntoTopic(pubDetail, nodePK);
        pubPK.setId(pubId);
        if (isHistoryEnable && isHistoryFirstAdding) {
            this.addPdfHistory(pdfHistoryName, role, pubPK, userId);
        }
        ResourceReference fromPK = new ResourceReference(this.getProcessInstance().getInstanceId(), this.getProcessInstance().getModelId());
        ResourceReference toPK = new ResourceReference((WAPrimaryKey)pubPK);
        this.copyFiles(fromPK, toPK, DocumentType.attachment, DocumentType.attachment);
        if (isHistoryEnable && !isHistoryFirstAdding) {
            this.addPdfHistory(pdfHistoryName, role, pubPK, userId);
        }
        if (formIsUsed) {
            this.populateFields(pubId, fromPK, toPK, xmlFormName);
        } else {
            this.copyFiles(fromPK, toPK, DocumentType.form, DocumentType.attachment);
        }
        Parameter draftOutParameter = this.getTriggerParameter("forceDraftOut");
        if (draftOutParameter != null && StringUtil.getBooleanValue((String)draftOutParameter.getValue())) {
            this.getKmeliaService().draftOutPublication(pubPK, nodePK, SilverpeasRole.ADMIN.toString());
        }
    }

    private String getXmlFormName() {
        String xmlFormName = null;
        if (this.getTriggerParameter("xmlFormName") != null && StringUtil.isDefined((String)(xmlFormName = this.getTriggerParameter("xmlFormName").getValue())) && xmlFormName.lastIndexOf(".xml") != -1) {
            xmlFormName = xmlFormName.substring(0, xmlFormName.lastIndexOf(".xml"));
        }
        return xmlFormName;
    }

    private String getPublicationTitle() {
        return this.getTriggerParameter("pubTitle").getValue();
    }

    private String getPublicationDescription() {
        Parameter paramDescription = this.getTriggerParameter("pubDescription");
        String pubDesc = paramDescription != null && StringUtil.isDefined((String)paramDescription.getValue()) ? paramDescription.getValue() : null;
        return pubDesc;
    }

    private String applySubstitution(String role, String text, String defaultText) {
        String result = defaultText;
        if (StringUtil.isDefined((String)text)) {
            try {
                result = DataRecordUtil.applySubstitution((String)text, (DataRecord)this.getProcessInstance().getAllDataRecord(role, "fr"), (String)"fr");
            }
            catch (WorkflowException e) {
                SilverLogger.getLogger((Object)((Object)this)).error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public void populateFields(String pubId, ResourceReference fromPK, ResourceReference toPK, String xmlFormName) {
        UpdatableProcessInstance currentProcessInstance = (UpdatableProcessInstance)this.getProcessInstance();
        try {
            PublicationTemplateManager.getInstance().addDynamicPublicationTemplate(toPK.getComponentInstanceId() + ":" + xmlFormName, xmlFormName + ".xml");
            PublicationTemplateImpl pubTemplate = (PublicationTemplateImpl)PublicationTemplateManager.getInstance().getPublicationTemplate(toPK.getComponentInstanceId() + ":" + xmlFormName);
            DataRecord record = pubTemplate.getRecordSet().getEmptyRecord();
            record.setId(pubId);
            for (String fieldName : record.getFieldNames()) {
                Object fieldValue = this.getFieldValue(fromPK, toPK, currentProcessInstance, pubTemplate, fieldName);
                record.getField(fieldName).setObjectValue(fieldValue);
            }
            pubTemplate.getRecordSet().save(record);
        }
        catch (FormException | PublicationTemplateException e) {
            SilverLogger.getLogger((Object)((Object)this)).error(e.getMessage(), e);
        }
    }

    private Object getFieldValue(ResourceReference fromPK, ResourceReference toPK, UpdatableProcessInstance currentProcessInstance, PublicationTemplateImpl pubTemplate, String fieldName) throws FormException, PublicationTemplateException {
        Object fieldValue = null;
        try {
            Field fieldOfFolder = currentProcessInstance.getField(fieldName);
            FieldTemplate fieldTemplate = pubTemplate.getRecordTemplate().getFieldTemplate(fieldName);
            fieldValue = fieldOfFolder.getObjectValue();
            if (fieldOfFolder instanceof FileField) {
                fieldValue = this.copyFormFile(fromPK, toPK, ((FileField)fieldOfFolder).getAttachmentId());
            } else if ("wysiwyg".equals(fieldTemplate.getDisplayerName())) {
                WysiwygFCKFieldDisplayer displayer = new WysiwygFCKFieldDisplayer();
                fieldValue = displayer.duplicateContent(fieldTemplate, fromPK, toPK, I18NHelper.DEFAULT_LANGUAGE);
            }
        }
        catch (WorkflowException e) {
            SilverLogger.getLogger((Object)((Object)this)).warn((Throwable)e);
        }
        return fieldValue;
    }

    private String copyFormFile(ResourceReference fromPK, ResourceReference toPK, String attachmentId) {
        AttachmentService service;
        SimpleDocument attachment;
        if (StringUtil.isDefined((String)attachmentId) && (attachment = (service = AttachmentServiceProvider.getAttachmentService()).searchDocumentById(new SimpleDocumentPK(attachmentId, fromPK.getInstanceId()), null)) != null) {
            SimpleDocumentPK copyPK = this.copyFileWithoutDocumentTypeChange(attachment, toPK);
            return copyPK.getId();
        }
        return null;
    }

    private Map<String, String> copyFiles(ResourceReference fromPK, ResourceReference toPK, DocumentType fromType, DocumentType toType) {
        HashMap<String, String> fileIds = new HashMap<String, String>();
        try {
            SimpleDocumentList origins = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(fromPK, fromType, this.getLanguage());
            for (SimpleDocument origin : origins) {
                SimpleDocumentPK copyPk = this.copyFile(origin, toPK, toType);
                fileIds.put(origin.getId(), copyPk.getId());
            }
        }
        catch (AttachmentException e) {
            SilverLogger.getLogger((Object)((Object)this)).error(e.getMessage(), (Throwable)e);
        }
        return fileIds;
    }

    private SimpleDocumentPK copyFileWithoutDocumentTypeChange(SimpleDocument file, ResourceReference toPK) {
        return this.copyFile(file, toPK, null);
    }

    private SimpleDocumentPK copyFile(SimpleDocument file, ResourceReference toPK, DocumentType type) {
        if (type != null) {
            file.setDocumentType(type);
        }
        return AttachmentServiceProvider.getAttachmentService().copyDocument(file, toPK);
    }

    private byte[] generatePDF(String role, ProcessInstance instance) {
        Document document = new Document();
        try {
            HistoryStep[] steps;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            for (HistoryStep historyStep : steps = instance.getHistorySteps()) {
                this.generatePDFStep(role, historyStep, document);
            }
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)((Object)this)).error(e.getMessage(), (Throwable)e);
            return new byte[0];
        }
    }

    private void generatePDFStep(String role, HistoryStep step, Document document) {
        if (step != null) {
            this.generatePDFStepHeader(role, step, document);
            this.generatePDFStepContent(role, step, document);
        }
    }

    private void generatePDFStepHeader(String role, HistoryStep step, Document document) {
        try {
            String activity = "";
            if (step.getResolvedState() != null) {
                State resolvedState = step.getProcessInstance().getProcessModel().getState(step.getResolvedState());
                activity = resolvedState.getLabel(role, this.getLanguage());
            }
            String sAction = this.getAction(role, step);
            Object actor = step.getUser().getFullName();
            String substituteId = step.getSubstituteId();
            if (StringUtil.isDefined((String)substituteId)) {
                actor = User.getById((String)substituteId).getDisplayedName() + " >> " + (String)actor;
            }
            String date = DateUtil.getOutputDateAndHour((Date)step.getActionDate(), (String)this.getLanguage());
            Object header = "";
            if (StringUtil.isDefined((String)activity)) {
                header = (String)header + activity + " - ";
            }
            header = (String)header + sAction + " (" + (String)actor + " - " + date + ")";
            Font fontHeader = new Font(Font.FontFamily.HELVETICA, 12.0f, 0);
            PdfPCell pCell = new PdfPCell(new Phrase((String)header, fontHeader));
            pCell.setFixedHeight(28.0f);
            pCell.setBackgroundColor(new BaseColor(239, 239, 239));
            pCell.setVerticalAlignment(5);
            PdfPTable pTable = new PdfPTable(1);
            pTable.setWidthPercentage(100.0f);
            pTable.addCell(pCell);
            document.add((Element)pTable);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)((Object)this)).error(e.getMessage(), (Throwable)e);
        }
    }

    private String getAction(String role, HistoryStep step) {
        try {
            String sAction;
            if ("#question#".equals(step.getAction())) {
                sAction = this.getString("processManager.question");
            } else if ("#response#".equals(step.getAction())) {
                sAction = this.getString("processManager.response");
            } else if ("#reAssign#".equals(step.getAction())) {
                sAction = this.getString("processManager.reAffectation");
            } else {
                Action action = step.getProcessInstance().getProcessModel().getAction(step.getAction());
                sAction = action.getLabel(role, this.getLanguage());
            }
            return sAction;
        }
        catch (WorkflowException we) {
            return "##";
        }
    }

    private void generatePDFStepContent(String role, HistoryStep step, Document document) {
        try {
            Form form = "#question#".equals(step.getAction()) || "#response#".equals(step.getAction()) ? null : this.getProcessInstance().getProcessModel().getPresentationForm(step.getAction(), role, this.getLanguage());
            if (form != null && step.getActionRecord() != null) {
                DataRecord data = step.getActionRecord();
                PagesContext pageContext = new PagesContext();
                pageContext.setLanguage(this.getLanguage());
                float[] colsWidth = new float[]{25.0f, 75.0f};
                PdfPTable tableContent = new PdfPTable(colsWidth);
                tableContent.setWidthPercentage(100.0f);
                List fieldTemplates = form.getFieldTemplates();
                for (FieldTemplate fieldTemplate : fieldTemplates) {
                    this.generatePdfFieldContent(step, data, pageContext, tableContent, (GenericFieldTemplate)fieldTemplate);
                }
                document.add((Element)tableContent);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)((Object)this)).error(e.getMessage(), (Throwable)e);
        }
    }

    private void generatePdfFieldContent(HistoryStep step, DataRecord data, PagesContext pageContext, PdfPTable tableContent, GenericFieldTemplate fieldTemplate) {
        try {
            Font fontLabel = new Font(Font.FontFamily.HELVETICA, 10.0f, 1);
            Font fontValue = new Font(Font.FontFamily.HELVETICA, 10.0f, 0);
            String fieldLabel = fieldTemplate.getLabel(this.getLanguage());
            String fieldValue = null;
            Field field = data.getField(fieldTemplate.getFieldName());
            String componentId = step.getProcessInstance().getProcessModel().getModelId();
            if ("wysiwyg".equals(fieldTemplate.getDisplayerName())) {
                String file = WysiwygFCKFieldDisplayer.getFile((String)componentId, (String)this.getProcessInstance().getInstanceId(), (String)fieldTemplate.getFieldName(), (String)this.getLanguage());
                Source source = new Source((InputStream)new FileInputStream(file));
                fieldValue = source.getTextExtractor().toString();
            } else if ("file".equals(fieldTemplate.getTypeName())) {
                SimpleDocument doc;
                if (StringUtil.isDefined((String)field.getValue()) && (doc = AttachmentServiceProvider.getAttachmentService().searchDocumentById(new SimpleDocumentPK(field.getValue(), componentId), null)) != null) {
                    fieldValue = doc.getFilename();
                }
            } else {
                FieldDisplayer fieldDisplayer = TypeManager.getInstance().getDisplayer(fieldTemplate.getTypeName(), "simpletext");
                StringWriter sw = new StringWriter();
                PrintWriter out = new PrintWriter(sw);
                fieldDisplayer.display(out, field, (FieldTemplate)fieldTemplate, pageContext);
                fieldValue = sw.toString();
            }
            boolean displayField = true;
            if (!Util.isEmptyFieldsDisplayed() && !StringUtil.isDefined(fieldValue)) {
                displayField = false;
            }
            if (displayField) {
                PdfPCell cell = new PdfPCell(new Phrase(fieldLabel, fontLabel));
                cell.setBorderWidth(0.0f);
                cell.setPaddingBottom(5.0f);
                tableContent.addCell(cell);
                cell = new PdfPCell(new Phrase(fieldValue, fontValue));
                cell.setBorderWidth(0.0f);
                cell.setPaddingBottom(5.0f);
                tableContent.addCell(cell);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)((Object)this)).error(e.getMessage(), (Throwable)e);
        }
    }

    private String getString(String key) {
        return key;
    }

    private String getLanguage() {
        return I18NHelper.DEFAULT_LANGUAGE;
    }

    private KmeliaService getKmeliaService() {
        return this.kmeliaService;
    }

    private void addPdfHistory(String pdfHistoryName, String role, PublicationPK pubPK, String userId) {
        Object fileName = pdfHistoryName != null && !pdfHistoryName.trim().isEmpty() ? (!pdfHistoryName.endsWith(".pdf") ? pdfHistoryName + ".pdf" : pdfHistoryName) : "processHistory_" + this.getProcessInstance().getInstanceId() + ".pdf";
        byte[] pdf = this.generatePDF(role, this.getProcessInstance());
        this.getKmeliaService().addAttachmentToPublication(pubPK, userId, (String)fileName, "", pdf);
    }

    private class PdfHistory {
        private boolean addPDFHistory;
        private boolean addPDFHistoryFirst;
        private String pdfHistoryName;

        private PdfHistory() {
        }

        public boolean isEnable() {
            return this.addPDFHistory;
        }

        public boolean isFirstAdding() {
            return this.addPDFHistoryFirst;
        }

        public String getFileName() {
            return this.pdfHistoryName;
        }

        public PdfHistory invoke() {
            if (SendInKmelia.this.getTriggerParameter("addPDFHistory") != null) {
                this.addPDFHistory = StringUtil.getBooleanValue((String)SendInKmelia.this.getTriggerParameter("addPDFHistory").getValue());
                this.addPDFHistoryFirst = SendInKmelia.this.getTriggerParameter("addPDFHistoryFirst") != null ? StringUtil.getBooleanValue((String)SendInKmelia.this.getTriggerParameter("addPDFHistoryFirst").getValue()) : true;
                Parameter paramPDFName = SendInKmelia.this.getTriggerParameter("pdfHistoryName");
                this.pdfHistoryName = paramPDFName != null ? SendInKmelia.this.getTriggerParameter("pdfHistoryName").getValue() : null;
            } else {
                this.addPDFHistory = true;
                this.addPDFHistoryFirst = true;
                this.pdfHistoryName = null;
            }
            return this;
        }
    }

    private class Target {
        private final String role;
        private final String userId;
        private final Parameter parameter;
        private String targetId;
        private String topicId;

        public Target(String role, String userId, Parameter parameter) {
            this.role = role;
            this.userId = userId;
            this.parameter = parameter;
        }

        public String getTargetId() {
            return this.targetId;
        }

        public String getTopicId() {
            return this.topicId;
        }

        public Target invoke() {
            if (this.parameter != null && StringUtil.isDefined((String)this.parameter.getValue())) {
                String explorerFieldName = this.parameter.getValue();
                try {
                    ExplorerField explorer = (ExplorerField)SendInKmelia.this.getProcessInstance().getField(explorerFieldName);
                    ResourceReference pk = (ResourceReference)explorer.getObjectValue();
                    this.targetId = pk.getInstanceId();
                    this.topicId = pk.getId();
                }
                catch (WorkflowException e) {
                    SilverLogger.getLogger((Object)((Object)SendInKmelia.this)).error(e.getMessage(), (Throwable)e);
                    this.targetId = SendInKmelia.UNKNOWN;
                    this.topicId = SendInKmelia.UNKNOWN;
                }
            } else {
                this.targetId = SendInKmelia.this.getTriggerParameter("targetComponentId").getValue();
                Parameter paramTopicPath = SendInKmelia.this.getTriggerParameter("targetFolderPath");
                if (paramTopicPath != null && StringUtil.isDefined((String)paramTopicPath.getValue())) {
                    try {
                        String path = DataRecordUtil.applySubstitution((String)paramTopicPath.getValue(), (DataRecord)SendInKmelia.this.getProcessInstance().getAllDataRecord(this.role, "fr"), (String)"fr");
                        this.topicId = this.getNodeId(path, this.targetId, this.userId);
                    }
                    catch (WorkflowException e) {
                        SilverLogger.getLogger((Object)((Object)SendInKmelia.this)).error(e.getMessage(), (Throwable)e);
                        this.topicId = "0";
                    }
                } else {
                    this.topicId = SendInKmelia.this.getTriggerParameter("targetTopicId").getValue();
                }
            }
            return this;
        }

        private String getNodeId(String explicitPath, String targetId, String userId) {
            return (String)Transaction.performInNew(() -> {
                String[] path = explicitPath.substring(1).split("/");
                NodePK nodePK = new NodePK(SendInKmelia.UNKNOWN, targetId);
                String parentId = "0";
                for (String name : path) {
                    NodePK newNodePK;
                    NodeDetail existingNode = this.getNodeService().getDetailByNameAndFatherId(nodePK, name, Integer.parseInt(parentId));
                    if (existingNode != null) {
                        parentId = existingNode.getNodePK().getId();
                        continue;
                    }
                    NodeDetail newNode = new NodeDetail();
                    newNode.setName(name);
                    newNode.setNodePK(new NodePK(SendInKmelia.UNKNOWN, targetId));
                    newNode.setFatherPK(new NodePK(parentId, targetId));
                    newNode.setCreatorId(userId);
                    try {
                        newNodePK = this.getNodeService().createNode(newNode);
                    }
                    catch (Exception e) {
                        SilverLogger.getLogger((Object)this).warn("Cannot create node {0} in path {1}: {2}", new Object[]{name, explicitPath, e.getMessage()});
                        return "0";
                    }
                    parentId = newNodePK.getId();
                }
                return parentId;
            });
        }

        private NodeService getNodeService() {
            return SendInKmelia.this.nodeService;
        }
    }
}

