/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.notification;

import java.io.File;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.silverpeas.components.kmelia.notification.KmeliaDelayedVisibilityUserNotificationReminder;
import org.silverpeas.components.kmelia.service.KmeliaService;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.core.util.file.FileRepositoryManager;

@Service
public class KmeliaDelayedVisibilityUserNotificationReminderInitializer
implements Initialization {
    private File dataFile = new File(FileRepositoryManager.getInitDataDirPath(), "kmeliaDelayedVisibilityReminderInitialization");
    @Inject
    private KmeliaDelayedVisibilityUserNotificationReminder delayedVisibilityUserNotificationReminder;

    public void init() throws Exception {
        if (!this.dataFile.exists()) {
            ListSlice potentialPubIds = JdbcSqlQuery.createSelect((String)"pubId, instanceId", (Object[])new Object[0]).from(new String[]{"sb_publication_publi"}).where("instanceId like 'kmelia%'", new Object[0]).and("pubbegindate >= ?", new Object[]{DateUtil.today2SQLDate()}).execute(r -> new PublicationPK(String.valueOf(r.getInt(1)), r.getString(2)));
            StringBuilder report = new StringBuilder((potentialPubIds.size() + 1) * 180);
            try {
                if (potentialPubIds.isEmpty()) {
                    report.append("No reminder has been set about delayed visibility.");
                } else {
                    potentialPubIds.forEach(i -> {
                        PublicationDetail potentialPub = KmeliaService.get().getPublicationDetail((PublicationPK)i);
                        if (this.delayedVisibilityUserNotificationReminder.setAbout(potentialPub)) {
                            report.append(MessageFormat.format("Reminder set for publication with id {0}, located into instance {1}, with visibility set to {2} at {3}\n", potentialPub.getId(), potentialPub.getComponentInstanceId(), LocalDateTime.ofInstant(potentialPub.getBeginDate().toInstant(), ZoneId.systemDefault()).toLocalDate(), potentialPub.getBeginHour()));
                        }
                    });
                }
            }
            finally {
                FileUtils.write((File)this.dataFile, (CharSequence)report.toString(), (Charset)Charsets.UTF_8);
            }
        }
    }
}

