/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.notification;

import javax.inject.Named;
import org.silverpeas.components.kmelia.service.KmeliaService;
import org.silverpeas.core.admin.ProfiledObjectType;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.notification.user.AbstractComponentInstanceManualUserNotification;
import org.silverpeas.core.notification.user.NotificationContext;
import org.silverpeas.core.notification.user.UserNotification;
import org.silverpeas.core.util.StringUtil;

@Named
public class KmeliaInstanceManualUserNotification
extends AbstractComponentInstanceManualUserNotification {
    public UserNotification createUserNotification(NotificationContext context) {
        String docId;
        NodeDetail node;
        String componentId = context.getComponentId();
        String folderId = context.getNodeId();
        String pubId = context.getPublicationId();
        if (!"0".equals(folderId) && (node = this.getKmeliaService().getNodeHeader(folderId, componentId)).haveRights()) {
            context.put((Object)"resourceId", (Object)this.asResourceId(node.getRightsDependsOn()));
        }
        UserNotification notification = StringUtil.isDefined((String)pubId) ? (StringUtil.isDefined((String)(docId = context.get((Object)"docId"))) ? this.getUserNotification(componentId, folderId, pubId, docId) : this.getUserNotification(componentId, folderId, pubId)) : this.getUserNotification(componentId, folderId);
        return notification;
    }

    protected NodePK getNodePK(String cmpId, String nodeId) {
        return StringUtil.isDefined((String)nodeId) ? new NodePK(nodeId, cmpId) : null;
    }

    private UserNotification getUserNotification(String cmpId, String nodeId, String pubId, String docId) {
        NodePK nodePK = this.getNodePK(cmpId, nodeId);
        PublicationPK pubPk = new PublicationPK(pubId, cmpId);
        SimpleDocumentPK documentPk = new SimpleDocumentPK(docId, cmpId);
        return this.getKmeliaService().getUserNotification(pubPk, documentPk, nodePK);
    }

    private UserNotification getUserNotification(String cmpId, String nodeId, String pubId) {
        NodePK nodePK = this.getNodePK(cmpId, nodeId);
        PublicationPK pubPk = new PublicationPK(pubId, cmpId);
        return this.getKmeliaService().getUserNotification(pubPk, nodePK);
    }

    private UserNotification getUserNotification(String cmpId, String nodeId) {
        NodePK nodePK = new NodePK(nodeId, cmpId);
        return this.getKmeliaService().getUserNotification(nodePK);
    }

    private KmeliaService getKmeliaService() {
        return KmeliaService.get();
    }

    private String asResourceId(String folderId) {
        return ProfiledObjectType.NODE.getCode() + folderId;
    }
}

