/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.projectmanager.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.components.projectmanager.model.Filtre;
import org.silverpeas.components.projectmanager.model.HolidayDetail;
import org.silverpeas.components.projectmanager.model.ProjectManagerCalendarDAO;
import org.silverpeas.components.projectmanager.model.ProjectManagerDAO;
import org.silverpeas.components.projectmanager.model.ProjectManagerRuntimeException;
import org.silverpeas.components.projectmanager.model.TaskDetail;
import org.silverpeas.components.projectmanager.model.TaskPK;
import org.silverpeas.components.projectmanager.service.ProjectManagerService;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.comment.service.CommentService;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.Attachments;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.io.upload.UploadedFile;
import org.silverpeas.core.notification.NotificationException;
import org.silverpeas.core.notification.user.client.NotificationMetaData;
import org.silverpeas.core.notification.user.client.NotificationSender;
import org.silverpeas.core.notification.user.client.UserRecipient;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.personalorganizer.model.TodoDetail;
import org.silverpeas.core.personalorganizer.service.SilverpeasCalendar;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.Link;
import org.silverpeas.core.util.LocalizationBundle;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.logging.SilverLogger;

@Service
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultProjectManagerService
implements ProjectManagerService {
    @Inject
    private CommentService commentController;
    @Inject
    private SilverpeasCalendar silverpeasCalendar;

    private CommentService getCommentService() {
        return this.commentController;
    }

    @Override
    public List<TaskDetail> getProjects(String instanceId) {
        Connection con = this.getConnection();
        try {
            List<TaskDetail> list = ProjectManagerDAO.getTasksByMotherId(con, instanceId, -1);
            return list;
        }
        catch (SQLException re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<TaskDetail> getTasksByMotherId(String instanceId, int motherId) {
        Connection con = this.getConnection();
        try {
            List<TaskDetail> list = ProjectManagerDAO.getTasksByMotherId(con, instanceId, motherId);
            return list;
        }
        catch (SQLException re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<TaskDetail> getTasksByMotherIdAndPreviousId(String instanceId, int motherId, int previousId) {
        Connection con = this.getConnection();
        try {
            List<TaskDetail> list = ProjectManagerDAO.getTasksByMotherIdAndPreviousId(con, instanceId, motherId, previousId);
            return list;
        }
        catch (SQLException re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<TaskDetail> getAllTasks(String instanceId, Filtre filtre) {
        Connection con = this.getConnection();
        try {
            List<TaskDetail> list = ProjectManagerDAO.getAllTasks(con, instanceId, filtre);
            return list;
        }
        catch (SQLException re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public TaskDetail getTask(int id) {
        Connection con = this.getConnection();
        try {
            TaskDetail taskDetail = ProjectManagerDAO.getTask(con, id);
            return taskDetail;
        }
        catch (SQLException re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public TaskDetail getTaskByTodoId(String todoId) {
        Connection con = this.getConnection();
        String actionId = null;
        try {
            TodoDetail todo = this.getTodo(todoId);
            actionId = todo.getExternalId();
            TaskDetail taskDetail = ProjectManagerDAO.getTask(con, actionId);
            return taskDetail;
        }
        catch (Exception re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public TaskDetail getMostDistantTask(String instanceId, int taskId) {
        Connection con = this.getConnection();
        try {
            TaskDetail taskDetail = ProjectManagerDAO.getMostDistantTask(con, taskId);
            return taskDetail;
        }
        catch (Exception re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional
    public int addTask(TaskDetail task, Collection<UploadedFile> uploadedFiles) {
        Connection con = this.getConnection();
        try {
            if (task.getAvancement() == 100) {
                task.setStatut(3);
            }
            int id = ProjectManagerDAO.addTask(con, task);
            task.setId(id);
            if (task.getMereId() != -1) {
                ProjectManagerDAO.actionEstDecomposee(con, task.getMereId(), 1);
            }
            this.updateChargesMotherTask(con, task);
            this.addTodo(task);
            Attachments.from(uploadedFiles).attachTo(task.asContribution());
            this.createIndex(task);
            if (task.getMereId() != -1) {
                this.alertResource(task, true);
            }
            int n = id;
            return n;
        }
        catch (SQLException re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional
    public void removeTask(int id, String instanceId) {
        Connection con = this.getConnection();
        try {
            TaskDetail actionASupprimer = ProjectManagerDAO.getTask(con, id);
            List<TaskDetail> tree = ProjectManagerDAO.getTree(con, id);
            TaskDetail task = null;
            for (int t = 0; t < tree.size(); ++t) {
                task = tree.get(t);
                this.removeTask(con, task.getId(), task.getInstanceId());
            }
            List<TaskDetail> actionsSoeur = ProjectManagerDAO.getTree(con, actionASupprimer.getMereId());
            if (actionsSoeur.size() == 1) {
                ProjectManagerDAO.actionEstDecomposee(con, actionASupprimer.getMereId(), 0);
            }
            List<TaskDetail> nextTasks = ProjectManagerDAO.getNextTasks(con, id);
            TaskDetail nextTask = null;
            for (int n = 0; n < nextTasks.size(); ++n) {
                nextTask = nextTasks.get(n);
                nextTask.setPreviousTaskId(-1);
                ProjectManagerDAO.updateTask(con, nextTask);
            }
            this.updateChargesMotherTask(con, task);
        }
        catch (Exception re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private void removeTask(Connection con, int id, String instanceId) throws SQLException {
        ProjectManagerDAO.removeTask(con, id);
        this.removeTodo(id, instanceId);
        TaskPK taskPK = new TaskPK(id, instanceId);
        ResourceReference ref = new ResourceReference((WAPrimaryKey)taskPK);
        SimpleDocumentList attachments = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKey(ref, null);
        for (SimpleDocument attachment : attachments) {
            AttachmentServiceProvider.getAttachmentService().deleteAttachment(attachment);
        }
        this.getCommentService().deleteAllCommentsOnResource(TaskDetail.getResourceType(), ref);
        this.removeIndex(id, instanceId);
    }

    @Override
    @Transactional
    public void updateTask(TaskDetail task, String userId) {
        Connection con = this.getConnection();
        try {
            Date beginDate = task.getDateDebut();
            Date endDate = task.getDateFin();
            List<Date> holidays = this.getHolidayDates(task.getInstanceId());
            Calendar calendar = Calendar.getInstance();
            this.updateNextTasks(task, userId, con, endDate, holidays, calendar);
            this.updateSubTasks(task, userId, con, beginDate, holidays, calendar);
            if (task.getAvancement() == 100) {
                task.setStatut(3);
            }
            ProjectManagerDAO.updateTask(con, task);
            this.updateChargesMotherTask(con, task);
            this.updateTodo(task);
            this.createIndex(task);
            if (task.getMereId() != -1 && !userId.equals(Integer.toString(task.getResponsableId()))) {
                this.alertResource(task, false);
            }
        }
        catch (SQLException re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private void updateSubTasks(TaskDetail task, String userId, Connection con, Date beginDate, List<Date> holidays, Calendar calendar) throws SQLException {
        List<TaskDetail> subTasks = ProjectManagerDAO.getTasksByMotherIdAndPreviousId(con, task.getInstanceId(), task.getId(), -1);
        TaskDetail subTask = null;
        for (int t = 0; t < subTasks.size(); ++t) {
            boolean isModifBeginDate = false;
            subTask = subTasks.get(t);
            this.updateSubTask(userId, beginDate, holidays, calendar, subTask, isModifBeginDate);
        }
    }

    private void updateSubTask(String userId, Date beginDate, List<Date> holidays, Calendar calendar, TaskDetail subTask, boolean isModifBeginDate) {
        Date endDateSub;
        Date beginDateSub;
        Date saveBeginDate = beginDateSub = subTask.getDateDebut();
        calendar.setTime(beginDateSub);
        beginDateSub = this.goAfterHoliday(holidays, calendar, subTask, beginDateSub);
        if (beginDate.after(beginDateSub)) {
            beginDateSub = beginDate;
            subTask.setDateDebut(beginDate);
        }
        Date saveEndDate = endDateSub = subTask.getDateFin();
        endDateSub = this.processEndDate(subTask, calendar, holidays);
        subTask.setDateFin(endDateSub);
        if (!beginDateSub.equals(saveBeginDate)) {
            isModifBeginDate = true;
        }
        if (!endDateSub.equals(saveEndDate)) {
            isModifBeginDate = true;
        }
        if (isModifBeginDate) {
            this.updateTask(subTask, userId);
        }
    }

    private void updateNextTasks(TaskDetail task, String userId, Connection con, Date endDate, List<Date> holidays, Calendar calendar) throws SQLException {
        List<TaskDetail> nextTasks = ProjectManagerDAO.getNextTasks(con, task.getId());
        Calendar calendar2 = Calendar.getInstance();
        for (int t = 0; t < nextTasks.size(); ++t) {
            Date endDateLinked;
            Date beginDateLinked;
            TaskDetail linkedTask = nextTasks.get(t);
            Date saveBeginDate = beginDateLinked = linkedTask.getDateDebut();
            calendar.setTime(beginDateLinked);
            beginDateLinked = this.goAfterHoliday(holidays, calendar, linkedTask, beginDateLinked);
            Date saveEndDate = endDateLinked = linkedTask.getDateFin();
            if (endDate.equals(endDateLinked) || endDate.after(endDateLinked)) {
                beginDateLinked = this.moveTask(endDate, holidays, calendar, linkedTask);
            }
            endDateLinked = this.processEndDate(linkedTask, calendar, holidays);
            linkedTask.setDateFin(endDateLinked);
            this.updateTask(userId, linkedTask, beginDateLinked, saveBeginDate, endDateLinked, saveEndDate);
            TaskDetail motherTask = ProjectManagerDAO.getTask(con, task.getMereId());
            if (motherTask.getMereId() == -1) continue;
            this.updateMotherTask(con, holidays, calendar, linkedTask, motherTask, calendar2);
        }
    }

    private void updateMotherTask(Connection con, List<Date> holidays, Calendar calendar, TaskDetail linkedTask, TaskDetail motherTask, Calendar calendar2) throws SQLException {
        boolean updateMother = false;
        Date endDateLinked = linkedTask.getDateFin();
        calendar.setTime(motherTask.getDateFin());
        while (holidays.contains(motherTask.getDateFin())) {
            calendar.add(5, 1);
            motherTask.setDateFin(calendar.getTime());
            updateMother = true;
        }
        if (endDateLinked.after(motherTask.getDateFin())) {
            motherTask.setDateFin(endDateLinked);
            updateMother = true;
        }
        if (updateMother) {
            calendar.setTime(motherTask.getDateDebut());
            calendar2.setTime(motherTask.getDateFin());
            float charge = 0.0f;
            while (calendar.before(calendar2) || calendar.equals(calendar2)) {
                charge += 1.0f;
                calendar.add(5, 1);
            }
            motherTask.setCharge(charge);
            ProjectManagerDAO.updateTask(con, motherTask);
        }
    }

    private void updateTask(String userId, TaskDetail linkedTask, Date beginDateLinked, Date saveBeginDate, Date endDateLinked, Date saveEndDate) {
        boolean isModifBeginDate = false;
        boolean isModifEndDate = false;
        if (!beginDateLinked.equals(saveBeginDate)) {
            isModifBeginDate = true;
        }
        if (!endDateLinked.equals(saveEndDate)) {
            isModifEndDate = true;
        }
        if (isModifBeginDate || isModifEndDate) {
            this.updateTask(linkedTask, userId);
        }
    }

    private Date moveTask(Date endDate, List<Date> holidays, Calendar calendar, TaskDetail linkedTask) {
        Date beginDateLinked = this.getBeginDate(calendar, endDate, holidays);
        linkedTask.setDateDebut(beginDateLinked);
        return beginDateLinked;
    }

    private Date goAfterHoliday(List<Date> holidays, Calendar calendar, TaskDetail linkedTask, Date beginDateLinked) {
        while (holidays.contains(beginDateLinked)) {
            calendar.add(5, 1);
            beginDateLinked = calendar.getTime();
            linkedTask.setDateDebut(beginDateLinked);
        }
        return beginDateLinked;
    }

    private String getNotificationSubject(LocalizationBundle message, boolean onCreation) {
        String subject = onCreation ? message.getString("projectManager.NewTask") : message.getString("projectManager.UpdateTask");
        return subject;
    }

    private String getNotificationBody(LocalizationBundle message, boolean onCreation, String taskName) {
        StringBuilder body = new StringBuilder();
        if (onCreation) {
            body.append(message.getString("projectManager.NewTaskNamed")).append(" '" + taskName + "' ").append(message.getString("projectManager.NewTaskAssigned")).append("\n");
        } else {
            body.append(message.getString("projectManager.UpdateTaskNamed")).append(" '" + taskName + "' ").append(message.getString("projectManager.UpdateTaskAssigned")).append("\n");
        }
        return body.toString();
    }

    private void alertResource(TaskDetail task, boolean onCreation) {
        NotificationSender notifSender = new NotificationSender(task.getInstanceId());
        String url = URLUtil.getURL((String)"projectManager", null, (String)task.getInstanceId()) + "searchResult?Type=Task&Id=" + task.getId();
        LocalizationBundle message = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.projectManager.multilang.projectManagerBundle", (String)DisplayI18NHelper.getDefaultLanguage());
        String subject = this.getNotificationSubject(message, onCreation);
        String body = this.getNotificationBody(message, onCreation, task.getNom());
        NotificationMetaData notifMetaData = new NotificationMetaData(0, subject, body);
        for (String language : DisplayI18NHelper.getLanguages()) {
            message = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.projectManager.multilang.projectManagerBundle", (String)language);
            subject = this.getNotificationSubject(message, onCreation);
            body = this.getNotificationBody(message, onCreation, task.getNom());
            notifMetaData.addLanguage(language, subject, body);
            Link link = new Link(url, message.getString("projectManager.notifLinkLabel"));
            notifMetaData.setLink(link, language);
        }
        notifMetaData.setSender(Integer.toString(task.getOrganisateurId()));
        notifMetaData.addUserRecipient(new UserRecipient(String.valueOf(task.getResponsableId())));
        try {
            notifSender.notifyUser(notifMetaData);
        }
        catch (NotificationException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }

    private Date getBeginDate(Calendar calendar, Date endDate, List<Date> holidays) {
        calendar.setTime(endDate);
        calendar.add(5, 1);
        while (holidays.contains(calendar.getTime())) {
            calendar.add(5, 1);
        }
        return calendar.getTime();
    }

    @Override
    public Date processEndDate(TaskDetail task) {
        return this.processEndDate(task, null, null);
    }

    private Date processEndDate(TaskDetail task, Calendar theCalendar, List<Date> theHolidays) {
        float toRound = 0.49f;
        int charge = Math.round(task.getCharge() + toRound) - 1;
        Calendar calendar = theCalendar;
        List<Date> holidays = theHolidays;
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        if (holidays == null) {
            holidays = this.getHolidayDates(task.getInstanceId());
        }
        calendar.setTime(task.getDateDebut());
        while (charge != 0) {
            calendar.add(5, 1);
            Date currentDate = calendar.getTime();
            if (holidays.contains(currentDate)) continue;
            --charge;
        }
        return calendar.getTime();
    }

    @Override
    public Date processEndDate(float fCharge, String instanceId, Date dateDebut) {
        float toRound = 0.49f;
        int charge = Math.round(fCharge + toRound) - 1;
        Calendar calendar = Calendar.getInstance();
        List<Date> holidays = this.getHolidayDates(instanceId);
        calendar.setTime(dateDebut);
        while (charge != 0) {
            calendar.add(5, 1);
            Date currentDate = calendar.getTime();
            if (holidays.contains(currentDate)) continue;
            --charge;
        }
        return calendar.getTime();
    }

    @Override
    @Transactional
    public void calculateAllTasksDates(String instanceId, int projectId, String userId) {
        List<TaskDetail> tasks = this.getTasksByMotherIdAndPreviousId(instanceId, projectId, -1);
        List<Date> holidays = this.getHolidayDates(instanceId);
        Calendar calendar = Calendar.getInstance();
        TaskDetail task = null;
        Date beginDate = null;
        Date endDate = null;
        boolean isModifBeginDate = false;
        Date saveBeginDate = null;
        Date saveEndDate = null;
        for (int t = 0; t < tasks.size(); ++t) {
            isModifBeginDate = false;
            task = tasks.get(t);
            saveBeginDate = beginDate = task.getDateDebut();
            while (holidays.contains(beginDate)) {
                calendar.setTime(beginDate);
                calendar.add(5, 1);
                beginDate = calendar.getTime();
            }
            if (!beginDate.equals(saveBeginDate)) {
                task.setDateDebut(beginDate);
                isModifBeginDate = true;
            }
            saveEndDate = task.getDateFin();
            endDate = this.processEndDate(task, calendar, holidays);
            if (!endDate.equals(saveEndDate)) {
                task.setDateFin(endDate);
                isModifBeginDate = true;
            }
            if (!isModifBeginDate) continue;
            this.updateTask(task, userId);
        }
    }

    private void updateChargesMotherTask(Connection con, TaskDetail task) {
        try {
            TaskDetail motherTask = ProjectManagerDAO.getTask(con, task.getMereId());
            if (motherTask != null && motherTask.getMereId() != -1) {
                List<TaskDetail> subTasks = ProjectManagerDAO.getTasksByMotherId(con, motherTask.getInstanceId(), motherTask.getId());
                TaskDetail subTask = null;
                float somConsomme = 0.0f;
                float somRaf = 0.0f;
                for (int t = 0; t < subTasks.size(); ++t) {
                    subTask = subTasks.get(t);
                    somConsomme += subTask.getConsomme();
                    somRaf += subTask.getRaf();
                }
                motherTask.setConsomme(somConsomme);
                motherTask.setRaf(somRaf);
                ProjectManagerDAO.updateTask(con, motherTask);
            }
        }
        catch (SQLException re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<Date> getHolidayDates(String instanceId) {
        Connection con = this.getConnection();
        try {
            List<Date> list = ProjectManagerCalendarDAO.getHolidayDates(con, instanceId);
            return list;
        }
        catch (Exception re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<Date> getHolidayDates(String instanceId, Date beginDate, Date endDate) {
        Connection con = this.getConnection();
        try {
            List<Date> list = ProjectManagerCalendarDAO.getHolidayDates(con, instanceId, beginDate, endDate);
            return list;
        }
        catch (SQLException re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void addHolidayDate(HolidayDetail holiday) {
        Connection con = this.getConnection();
        try {
            ProjectManagerCalendarDAO.addHolidayDate(con, holiday);
        }
        catch (SQLException re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional
    public void addHolidayDates(List<HolidayDetail> holidayDates) {
        Connection con = this.getConnection();
        try {
            for (HolidayDetail holiday : holidayDates) {
                ProjectManagerCalendarDAO.addHolidayDate(con, holiday);
            }
        }
        catch (SQLException re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional
    public void removeHolidayDate(HolidayDetail holiday) {
        Connection con = this.getConnection();
        try {
            ProjectManagerCalendarDAO.removeHolidayDate(con, holiday);
        }
        catch (SQLException re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional
    public void removeHolidayDates(List<HolidayDetail> holidayDates) {
        Connection con = this.getConnection();
        try {
            for (HolidayDetail holiday : holidayDates) {
                ProjectManagerCalendarDAO.removeHolidayDate(con, holiday);
            }
        }
        catch (SQLException re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public boolean isHolidayDate(HolidayDetail date) {
        Connection con = this.getConnection();
        try {
            boolean bl = ProjectManagerCalendarDAO.isHolidayDate(con, date);
            return bl;
        }
        catch (SQLException re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private TodoDetail getTodo(String todoId) {
        return this.silverpeasCalendar.getTodoDetail(todoId);
    }

    private void addTodo(TaskDetail task) {
        TodoDetail todo = task.toTodoDetail();
        this.silverpeasCalendar.addToDo(todo);
    }

    private void removeTodo(int id, String instanceId) {
        this.silverpeasCalendar.removeToDoFromExternal("useless", instanceId, Integer.toString(id));
    }

    private void updateTodo(TaskDetail task) {
        this.silverpeasCalendar.removeToDoFromExternal("useless", task.getInstanceId(), Integer.toString(task.getId()));
        this.silverpeasCalendar.addToDo(task.toTodoDetail());
    }

    private void createIndex(TaskDetail task) {
        FullIndexEntry indexEntry = null;
        indexEntry = new FullIndexEntry(task.getInstanceId(), "Action", Integer.toString(task.getId()));
        indexEntry.setTitle(task.getNom());
        indexEntry.setPreview(task.getDescription());
        IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
    }

    private void removeIndex(int id, String instanceId) {
        IndexEntryKey indexEntry = new IndexEntryKey(instanceId, "Action", Integer.toString(id));
        IndexEngineProxy.removeIndexEntry((IndexEntryKey)indexEntry);
    }

    @Override
    public void index(String instanceId) {
        List<TaskDetail> tasks = this.getAllTasks(instanceId, null);
        for (TaskDetail task : tasks) {
            this.indexTask(task);
        }
    }

    private void indexTask(TaskDetail task) {
        this.createIndex(task);
        TaskPK taskPK = new TaskPK(task.getId(), task.getInstanceId());
        ResourceReference ref = new ResourceReference((WAPrimaryKey)taskPK);
        AttachmentServiceProvider.getAttachmentService().indexAllDocuments(ref, null, null);
        this.getCommentService().indexAllCommentsOnPublication(TaskDetail.getResourceType(), ref);
    }

    private Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new ProjectManagerRuntimeException(e);
        }
    }

    @Override
    public int getOccupationByUser(String userId, Date dateDeb, Date dateFin) {
        Connection con = this.getConnection();
        try {
            int n = ProjectManagerDAO.getOccupationByUser(con, userId, dateDeb, dateFin);
            return n;
        }
        catch (SQLException re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public int getOccupationByUser(String userId, Date dateDeb, Date dateFin, int excludedTaskId) {
        Connection con = this.getConnection();
        try {
            int n = ProjectManagerDAO.getOccupationByUser(con, userId, dateDeb, dateFin, excludedTaskId);
            return n;
        }
        catch (SQLException re) {
            throw new ProjectManagerRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }
}

