/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.almanach;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.silverstatistics.volume.model.UserIdCountVolumeCouple;
import org.silverpeas.core.silverstatistics.volume.service.ComponentStatisticsProvider;

@Provider
@Named(value="almanachStatistics")
public class AlmanachStatistics
implements ComponentStatisticsProvider {
    public Collection<UserIdCountVolumeCouple> getVolume(String spaceId, String componentId) {
        return this.getEvents(componentId).map(e -> {
            UserIdCountVolumeCouple myCouple = new UserIdCountVolumeCouple();
            myCouple.setUserId(e.getLastUpdater().getId());
            myCouple.setCountVolume(1L);
            return myCouple;
        }).collect(Collectors.toList());
    }

    private Stream<CalendarEvent> getEvents(String componentId) {
        return Calendar.getByComponentInstanceId((String)componentId).stream().flatMap(c -> Calendar.getEvents().filter(f -> f.onCalendar(new Calendar[]{c})).stream());
    }
}

