/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.xml.ConfigurationParser;
import org.ehcache.xml.XmlConfiguration;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DomUtil {
    private static final URL CORE_SCHEMA_URL = XmlConfiguration.class.getResource("/ehcache-core.xsd");

    public static DocumentBuilder createAndGetDocumentBuilder(Collection<Source> schemaSources) throws SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = DomUtil.createAndGetFactory(schemaSources);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new TransformationErrorHandler());
        return documentBuilder;
    }

    public static DocumentBuilder createAndGetDocumentBuilder(Source schemaSource) throws SAXException, ParserConfigurationException, IOException {
        ArrayList<Source> schemaSources = new ArrayList<Source>(2);
        schemaSources.add(new StreamSource(CORE_SCHEMA_URL.openStream()));
        schemaSources.add(schemaSource);
        return DomUtil.createAndGetDocumentBuilder(schemaSources);
    }

    public static DocumentBuilder createAndGetDocumentBuilder() throws SAXException, ParserConfigurationException, IOException {
        return DomUtil.createAndGetDocumentBuilder(new StreamSource(CORE_SCHEMA_URL.openStream()));
    }

    private static DocumentBuilderFactory createAndGetFactory(Collection<Source> schemaSources) throws SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setSchema(ConfigurationParser.newSchema(schemaSources.toArray(new Source[schemaSources.size()])));
        return factory;
    }

    public static Document createDocumentRoot(Source schemaSource) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder domBuilder = DomUtil.createAndGetDocumentBuilder(schemaSource);
        Document doc = domBuilder.newDocument();
        return doc;
    }

    static class TransformationErrorHandler
    implements ErrorHandler {
        TransformationErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }
}

