/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist.service.notification;

import java.text.MessageFormat;
import javax.enterprise.inject.Alternative;
import javax.inject.Singleton;
import org.silverpeas.components.mailinglist.service.model.beans.Message;
import org.silverpeas.components.mailinglist.service.notification.AbstractNotificationFormatter;
import org.silverpeas.core.util.LocalizationBundle;
import org.silverpeas.core.util.ResourceLocator;

@Singleton
@Alternative
public class SimpleNotificationFormatter
extends AbstractNotificationFormatter {
    public static final String TITLE_KEY = "mailinglist.notification.title";
    public static final String TITLE_MODERATION_KEY = "mailinglist.notification.moderation.title";
    public static final String BODY_KEY = "mailinglist.notification.body";
    public static final String BODY_MODERATION_KEY = "mailinglist.notification.moderation.body";
    private MessageFormat titleFormatter;
    private MessageFormat titleModerationFormatter;
    private MessageFormat bodyFormatter;
    private MessageFormat bodyModerationFormatter;

    public SimpleNotificationFormatter() {
        LocalizationBundle resources = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.mailinglist.multilang.mailinglistBundle");
        this.titleFormatter = new MessageFormat(resources.getString(TITLE_KEY));
        this.titleModerationFormatter = new MessageFormat(resources.getString(TITLE_MODERATION_KEY));
        this.bodyFormatter = new MessageFormat(resources.getString(BODY_KEY));
        this.bodyModerationFormatter = new MessageFormat(resources.getString(BODY_MODERATION_KEY));
    }

    @Override
    public String formatTitle(Message message, String mailingListName, String lang, boolean moderate) {
        if (moderate) {
            return this.titleModerationFormatter.format(new String[]{mailingListName, message.getTitle()});
        }
        return this.titleFormatter.format(new String[]{mailingListName, message.getTitle()});
    }

    @Override
    public String formatMessage(Message message, String lang, boolean moderate) {
        if (moderate) {
            return this.bodyModerationFormatter.format(new String[]{message.getSummary(), this.prepareUrl(message, moderate), message.getTitle()});
        }
        return this.bodyFormatter.format(new String[]{message.getSummary(), this.prepareUrl(message, moderate), message.getTitle()});
    }
}

