/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist.service.model.dao;

import java.util.List;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.transaction.Transactional;
import org.silverpeas.components.mailinglist.service.model.beans.MailingList;
import org.silverpeas.components.mailinglist.service.model.dao.MailingListDao;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.util.logging.SilverLogger;

@Repository
@Named(value="mailingListDAO")
@Transactional
public class MailingListDaoImpl
implements MailingListDao {
    @PersistenceContext
    private EntityManager entityManager;

    private EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public String createMailingList(MailingList mailingList) {
        this.getEntityManager().persist((Object)mailingList);
        return mailingList.getId();
    }

    @Override
    public void deleteMailingList(MailingList mailingList) {
        EntityManager theEntityManager = this.getEntityManager();
        MailingList attachedMailingList = (MailingList)theEntityManager.merge((Object)mailingList);
        theEntityManager.remove((Object)attachedMailingList);
    }

    @Override
    public MailingList findByComponentId(String componentId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("mailinglist.findByComponentId", MailingList.class);
        query.setParameter("componentId", (Object)componentId);
        MailingList result = null;
        try {
            result = (MailingList)query.getSingleResult();
        }
        catch (NoResultException ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    @Override
    public MailingList findById(String id) {
        return (MailingList)this.getEntityManager().find(MailingList.class, (Object)id);
    }

    @Override
    public List<MailingList> listMailingLists() {
        TypedQuery query = this.getEntityManager().createNamedQuery("mailinglist.findAll", MailingList.class);
        return query.getResultList();
    }

    @Override
    public void updateMailingList(MailingList mailingList) {
        this.getEntityManager().merge((Object)mailingList);
    }
}

