/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.whitepages.service;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.components.whitepages.dao.SearchFieldDao;
import org.silverpeas.components.whitepages.model.SearchField;
import org.silverpeas.components.whitepages.service.SearchFieldComparator;
import org.silverpeas.components.whitepages.service.WhitePagesService;
import org.silverpeas.core.annotation.Service;

@Service
@Transactional
public class DefaultWhitePagesService
implements WhitePagesService {
    public static final String COMPONENT_NAME = "whitePages";
    @Inject
    private SearchFieldDao searchFieldDao;

    @Override
    public void createSearchFields(String[] fields, String instanceId) {
        this.deleteFields(instanceId);
        for (String field : fields) {
            SearchField searchField = new SearchField();
            searchField.setFieldId(field);
            searchField.setInstanceId(instanceId);
            this.searchFieldDao.createSearchField(searchField);
        }
    }

    @Override
    public SortedSet<SearchField> getSearchFields(String instanceId) {
        TreeSet<SearchField> fields = new TreeSet<SearchField>(new SearchFieldComparator());
        Set<SearchField> searchFields = this.searchFieldDao.getSearchFields(instanceId);
        if (searchFields != null && searchFields.size() > 0) {
            fields.addAll(searchFields);
        }
        return fields;
    }

    @Override
    public void deleteFields(String instanceId) {
        this.searchFieldDao.deleteSearchFieldsFor(instanceId);
    }
}

