/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FreqProxFields;
import org.apache.lucene.index.FreqProxTermsWriterPerField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.SortingLeafReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.TermsHash;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.IOUtils;

final class FreqProxTermsWriter
extends TermsHash {
    public FreqProxTermsWriter(DocumentsWriterPerThread docWriter, TermsHash termVectors) {
        super(docWriter, true, termVectors);
    }

    private void applyDeletes(SegmentWriteState state, Fields fields) throws IOException {
        if (state.segUpdates != null && state.segUpdates.deleteTerms.size() > 0) {
            Map<Term, Integer> segDeletes = state.segUpdates.deleteTerms;
            ArrayList<Term> deleteTerms = new ArrayList<Term>(segDeletes.keySet());
            Collections.sort(deleteTerms);
            String lastField = null;
            TermsEnum termsEnum = null;
            PostingsEnum postingsEnum = null;
            for (Term deleteTerm : deleteTerms) {
                int doc;
                if (!deleteTerm.field().equals(lastField)) {
                    lastField = deleteTerm.field();
                    Terms terms = fields.terms(lastField);
                    termsEnum = terms != null ? terms.iterator() : null;
                }
                if (termsEnum == null || !termsEnum.seekExact(deleteTerm.bytes())) continue;
                postingsEnum = termsEnum.postings(postingsEnum, 0);
                int delDocLimit = segDeletes.get(deleteTerm);
                assert (delDocLimit < Integer.MAX_VALUE);
                while ((doc = postingsEnum.nextDoc()) < delDocLimit) {
                    if (state.liveDocs == null) {
                        state.liveDocs = state.segmentInfo.getCodec().liveDocsFormat().newLiveDocs(state.segmentInfo.maxDoc());
                    }
                    if (!state.liveDocs.get(doc)) continue;
                    ++state.delCountOnFlush;
                    state.liveDocs.clear(doc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(Map<String, TermsHashPerField> fieldsToFlush, SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        block8: {
            FieldsConsumer consumer;
            block7: {
                super.flush(fieldsToFlush, state, sortMap);
                ArrayList<FreqProxTermsWriterPerField> allFields = new ArrayList<FreqProxTermsWriterPerField>();
                for (TermsHashPerField f : fieldsToFlush.values()) {
                    FreqProxTermsWriterPerField perField = (FreqProxTermsWriterPerField)f;
                    if (perField.bytesHash.size() <= 0) continue;
                    perField.sortPostings();
                    assert (perField.fieldInfo.getIndexOptions() != IndexOptions.NONE);
                    allFields.add(perField);
                }
                CollectionUtil.introSort(allFields);
                Fields fields = new FreqProxFields(allFields);
                this.applyDeletes(state, fields);
                if (sortMap != null) {
                    fields = new SortingLeafReader.SortingFields(fields, state.fieldInfos, sortMap);
                }
                consumer = state.segmentInfo.getCodec().postingsFormat().fieldsConsumer(state);
                boolean success = false;
                try {
                    consumer.write(fields);
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(consumer);
                    } else {
                        IOUtils.closeWhileHandlingException(consumer);
                    }
                    throw throwable;
                }
                IOUtils.close(consumer);
                break block8;
            }
            IOUtils.closeWhileHandlingException(consumer);
        }
    }

    @Override
    public TermsHashPerField addField(FieldInvertState invertState, FieldInfo fieldInfo) {
        return new FreqProxTermsWriterPerField(invertState, this, fieldInfo, this.nextTermsHash.addField(invertState, fieldInfo));
    }
}

