/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.viewer.form.displayers;

import java.io.File;
import java.io.PrintWriter;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFileFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.FileField;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.core.viewer.service.ViewerProvider;

public class FileFieldDisplayer
extends AbstractFileFieldDisplayer {
    public void display(PrintWriter out, FileField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String contentLanguage = I18NHelper.checkLanguage((String)pageContext.getContentLanguage());
        StringBuilder html = new StringBuilder(1024);
        AbstractFileFieldDisplayer.Operation defaultOperation = AbstractFileFieldDisplayer.Operation.ADD;
        String fieldName = Util.getFieldOccurrenceName((String)template.getFieldName(), (int)field.getOccurrence());
        String attachmentId = field.getAttachmentId();
        String componentId = pageContext.getComponentId();
        String webContext = URLUtil.getApplicationURL();
        SimpleDocument attachment = null;
        if (StringUtil.isDefined((String)attachmentId)) {
            attachment = AttachmentServiceProvider.getAttachmentService().searchDocumentById(new SimpleDocumentPK(attachmentId, componentId), contentLanguage);
            if (attachment != null) {
                defaultOperation = AbstractFileFieldDisplayer.Operation.UPDATE;
            }
        } else {
            attachmentId = "";
        }
        if (!template.isHidden()) {
            if (template.isReadOnly()) {
                if (attachment != null) {
                    html.append("<img alt=\"\" src=\"").append(attachment.getDisplayIcon()).append("\"/>&nbsp;");
                    Object url = webContext + attachment.getAttachmentURL();
                    if (pageContext.isSharingContext()) {
                        url = pageContext.getSharingContext().getSharedUriOf(attachment).toString();
                    }
                    html.append("<a href=\"").append((String)url).append("\" target=\"_blank\">").append(attachment.getFilename()).append("</a>");
                    if (!pageContext.isSharingContext()) {
                        File attachmentFile = new File(attachment.getAttachmentPath());
                        if (ViewerProvider.isPreviewable(attachmentFile)) {
                            html.append("<img onclick=\"javascript:previewFormFile(this, '").append(attachment.getId()).append("');\" class=\"preview-file\" src=\"").append(webContext).append("/util/icons/preview.png\" alt=\"").append(Util.getString((String)"GML.preview.file", (String)contentLanguage)).append("\" title=\"").append(Util.getString((String)"GML.preview.file", (String)contentLanguage)).append("\"/>");
                        }
                        if (ViewerProvider.isViewable(attachmentFile)) {
                            html.append("<img onclick=\"javascript:viewFormFile(this, '").append(attachment.getId()).append("');\" class=\"view-file\" src=\"").append(webContext).append("/util/icons/view.png\" alt=\"").append(Util.getString((String)"GML.view.file", (String)contentLanguage)).append("\" title=\"").append(Util.getString((String)"GML.view.file", (String)contentLanguage)).append("\"/>");
                        }
                        if (attachment.isSharingAllowedForRolesFrom((User)UserDetail.getById((String)pageContext.getUserId()))) {
                            html.append("<img onclick=\"javascript:createSharingTicketPopup({ componentId : '").append(attachment.getInstanceId()).append("',type : 'Attachment', id: '").append(attachment.getOldSilverpeasId()).append("', name : '").append(WebEncodeHelper.javaStringToJsString((String)attachment.getFilename())).append("'});\" class=\"share-file\" src=\"").append(webContext).append("/util/icons/share.png\" alt=\"").append(Util.getString((String)"GML.share.file", (String)contentLanguage)).append("\" title=\"").append(Util.getString((String)"GML.share.file", (String)contentLanguage)).append("\"/>");
                        }
                    }
                }
            } else if (!template.isDisabled()) {
                html.append("<input type=\"file\" size=\"50\" id=\"").append(fieldName).append("\" name=\"").append(fieldName).append("\"/>").append("<input type=\"hidden\" id=\"").append(fieldName + "_id").append("\" name=\"").append(fieldName + "$$id").append("\" value=\"").append(attachmentId).append("\"/>").append("<input type=\"hidden\" id=\"").append(fieldName).append("Operation\" name=\"").append(fieldName).append("Operation\" value=\"").append(defaultOperation.name()).append("\"/>");
                if (attachment != null) {
                    String deleteImg = Util.getIcon((String)"delete");
                    String deleteLab = Util.getString((String)"removeFile", (String)contentLanguage);
                    html.append("&nbsp;<span class=\"fileArea\" id=\"div").append(fieldName).append("\">").append("<img alt=\"\" align=\"top\" src=\"").append(attachment.getDisplayIcon()).append("\"/>&nbsp;").append("<a href=\"").append(webContext).append(attachment.getAttachmentURL()).append("\" target=\"_blank\">").append(attachment.getFilename()).append("</a>").append("&nbsp;<a href=\"#\" onclick=\"javascript:document.getElementById('div").append(fieldName).append("').style.display='none';document.").append(pageContext.getFormName()).append(".").append(fieldName).append("Operation.value='").append(AbstractFileFieldDisplayer.Operation.DELETION.name()).append("';return false;\">").append("<img src=\"").append(deleteImg).append("\" width=\"15\" height=\"15\" border=\"0\" alt=\"").append(deleteLab).append("\" align=\"top\" title=\"").append(deleteLab).append("\"/></a>").append("</span>");
                }
                if (template.isMandatory() && pageContext.useMandatory()) {
                    html.append(Util.getMandatorySnippet());
                }
            }
        }
        html.append(this.displayPreviewJavascript(pageContext));
        html.append(this.displayViewJavascript(pageContext));
        out.println(html.toString());
    }

    private String displayPreviewJavascript(PagesContext context) {
        StringBuilder sb = new StringBuilder(50);
        sb.append("<script type=\"text/javascript\">\n");
        sb.append("function previewFormFile(target, attachmentId) {\n");
        sb.append("$(target).preview(\"previewAttachment\", {\n");
        sb.append("componentInstanceId: \"").append(context.getComponentId()).append("\",\n");
        sb.append("attachmentId: attachmentId,\n");
        sb.append("lang: '").append(context.getContentLanguage()).append("'\n");
        sb.append("});\n");
        sb.append("return false;");
        sb.append("}\n");
        sb.append("</script>\n");
        return sb.toString();
    }

    private String displayViewJavascript(PagesContext context) {
        StringBuilder sb = new StringBuilder(50);
        sb.append("<script type=\"text/javascript\">\n");
        sb.append("function viewFormFile(target, attachmentId) {\n");
        sb.append("$(target).view(\"viewAttachment\", {\n");
        sb.append("componentInstanceId: \"").append(context.getComponentId()).append("\",\n");
        sb.append("attachmentId: attachmentId,\n");
        sb.append("lang: '").append(context.getContentLanguage()).append("'\n");
        sb.append("});\n");
        sb.append("return false;");
        sb.append("}\n");
        sb.append("</script>\n");
        return sb.toString();
    }

    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 2;
    }
}

